/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.blockmeta;

import com.gmail.nossr50.util.blockmeta.ChunkletStore;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class PrimitiveExChunkletStore
implements ChunkletStore,
Externalizable {
    private static final long serialVersionUID = 8603603827094383873L;
    public boolean[][][] store = new boolean[16][16][64];

    @Override
    public boolean isTrue(int x, int y, int z) {
        return this.store[x][z][y];
    }

    @Override
    public void setTrue(int x, int y, int z) {
        this.store[x][z][y] = true;
    }

    @Override
    public void setFalse(int x, int y, int z) {
        this.store[x][z][y] = false;
    }

    @Override
    public boolean isEmpty() {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 64; ++y) {
                    if (!this.store[x][z][y]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public void copyFrom(ChunkletStore otherStore) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 64; ++y) {
                    this.store[x][z][y] = otherStore.isTrue(x, y, z);
                }
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte[] buffer = new byte[2304];
        int bufferIndex = 0;
        for (int x = 0; x < 16; ++x) {
            block1: for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 64; ++y) {
                    if (!this.store[x][z][y]) continue;
                    byte[] temp = this.constructColumn(x, z);
                    for (int i = 0; i < 9; ++i) {
                        buffer[bufferIndex] = temp[i];
                        ++bufferIndex;
                    }
                    continue block1;
                }
            }
        }
        out.write(buffer, 0, bufferIndex);
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        byte[] temp = new byte[9];
        while (in.read(temp, 0, 9) == 9) {
            int x = PrimitiveExChunkletStore.addressByteX(temp[0]);
            int z = PrimitiveExChunkletStore.addressByteZ(temp[0]);
            boolean[] yColumn = new boolean[64];
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    yColumn[j + i * 8] = (temp[i + 1] & 1 << j) != 0;
                }
            }
            this.store[x][z] = yColumn;
        }
    }

    private byte[] constructColumn(int x, int z) {
        byte[] column = new byte[9];
        int index = 1;
        column[0] = PrimitiveExChunkletStore.makeAddressByte(x, z);
        for (int i = 0; i < 8; ++i) {
            byte yCompressed = 0;
            int subColumnIndex = 8 * i;
            int subColumnEnd = subColumnIndex + 8;
            for (int y = subColumnIndex; y < subColumnEnd; ++y) {
                if (!this.store[x][z][y]) continue;
                yCompressed = (byte)(yCompressed | 1 << y % 8);
            }
            column[index] = yCompressed;
            ++index;
        }
        return column;
    }

    protected static byte makeAddressByte(int x, int z) {
        return (byte)((x << 4) + z);
    }

    protected static int addressByteX(byte address) {
        return (address & 0xF0) >>> 4;
    }

    protected static int addressByteZ(byte address) {
        return address & 0xF;
    }
}

