/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.player;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.mcMMO;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class UserManager {
    private UserManager() {
    }

    public static McMMOPlayer addUser(Player player) {
        McMMOPlayer mcMMOPlayer = new McMMOPlayer(player);
        player.setMetadata("mcMMO: Player Data", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)mcMMOPlayer));
        return mcMMOPlayer;
    }

    public static void remove(Player player) {
        player.removeMetadata("mcMMO: Player Data", (Plugin)mcMMO.p);
    }

    public static void clearAll() {
        for (Player player : mcMMO.p.getServer().getOnlinePlayers()) {
            UserManager.remove(player);
        }
    }

    public static void saveAll() {
        Player[] onlinePlayers = mcMMO.p.getServer().getOnlinePlayers();
        mcMMO.p.debug("Saving mcMMOPlayers... (" + onlinePlayers.length + ")");
        for (Player player : onlinePlayers) {
            UserManager.getPlayer(player).getProfile().save();
        }
    }

    public static Collection<McMMOPlayer> getPlayers() {
        ArrayList<McMMOPlayer> playerCollection = new ArrayList<McMMOPlayer>();
        for (Player player : mcMMO.p.getServer().getOnlinePlayers()) {
            playerCollection.add(UserManager.getPlayer(player));
        }
        return playerCollection;
    }

    public static McMMOPlayer getPlayer(String playerName) {
        return UserManager.retrieveMcMMOPlayer(playerName, false);
    }

    public static McMMOPlayer getOfflinePlayer(OfflinePlayer player) {
        if (player instanceof Player) {
            return UserManager.getPlayer((Player)player);
        }
        return UserManager.retrieveMcMMOPlayer(player.getName(), true);
    }

    public static McMMOPlayer getOfflinePlayer(String playerName) {
        return UserManager.retrieveMcMMOPlayer(playerName, true);
    }

    public static McMMOPlayer getPlayer(Player player) {
        return (McMMOPlayer)((MetadataValue)player.getMetadata("mcMMO: Player Data").get(0)).value();
    }

    private static McMMOPlayer retrieveMcMMOPlayer(String playerName, boolean offlineValid) {
        Player player = mcMMO.p.getServer().getPlayerExact(playerName);
        if (player == null) {
            if (!offlineValid) {
                mcMMO.p.getLogger().warning("A valid mcMMOPlayer object could not be found for " + playerName + ".");
            }
            return null;
        }
        return UserManager.getPlayer(player);
    }

    public static boolean hasPlayerDataKey(Entity entity) {
        return entity != null && entity.hasMetadata("mcMMO: Player Data");
    }
}

