/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.events.skills.secondaryabilities.SecondaryAbilityWeightedActivationCheckEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.PerksUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SkillUtils {
    public static int handleFoodSkills(Player player, SkillType skill, int eventFoodLevel, int baseLevel, int maxLevel, int rankChange) {
        int skillLevel = UserManager.getPlayer(player).getSkillLevel(skill);
        int currentFoodLevel = player.getFoodLevel();
        int foodChange = eventFoodLevel - currentFoodLevel;
        for (int i = baseLevel; i <= maxLevel; i += rankChange) {
            if (skillLevel < i) continue;
            ++foodChange;
        }
        return currentFoodLevel + foodChange;
    }

    public static int calculateTimeLeft(long deactivatedTimeStamp, int cooldown, Player player) {
        return (int)((deactivatedTimeStamp + (long)(PerksUtils.handleCooldownPerks(player, cooldown) * 1000) - System.currentTimeMillis()) / 1000L);
    }

    public static boolean cooldownExpired(long deactivatedTimeStamp, int cooldown) {
        return System.currentTimeMillis() >= (deactivatedTimeStamp + (long)cooldown) * 1000L;
    }

    public static boolean isSkill(String skillName) {
        return Config.getInstance().getLocale().equalsIgnoreCase("en_US") ? SkillType.getSkill(skillName) != null : SkillUtils.isLocalizedSkill(skillName);
    }

    public static void sendSkillMessage(Player player, String message) {
        Location location = player.getLocation();
        for (Player otherPlayer : player.getWorld().getPlayers()) {
            if (otherPlayer == player || !Misc.isNear(location, otherPlayer.getLocation(), 10.0)) continue;
            otherPlayer.sendMessage(message);
        }
    }

    public static void handleAbilitySpeedIncrease(Player player) {
        if (HiddenConfig.getInstance().useEnchantmentBuffs()) {
            ItemStack heldItem = player.getItemInHand();
            if (heldItem == null || heldItem.getType() == Material.AIR) {
                return;
            }
            int efficiencyLevel = heldItem.getEnchantmentLevel(Enchantment.DIG_SPEED);
            ItemMeta itemMeta = heldItem.getItemMeta();
            List<String> itemLore = new ArrayList<String>();
            if (itemMeta.hasLore()) {
                itemLore = itemMeta.getLore();
            }
            itemLore.add("mcMMO Ability Tool");
            itemMeta.addEnchant(Enchantment.DIG_SPEED, efficiencyLevel + AdvancedConfig.getInstance().getEnchantBuff(), true);
            itemMeta.setLore(itemLore);
            heldItem.setItemMeta(itemMeta);
        } else {
            McMMOPlayer mcMMOPlayer;
            int duration = 0;
            int amplifier = 0;
            if (player.hasPotionEffect(PotionEffectType.FAST_DIGGING)) {
                for (PotionEffect effect : player.getActivePotionEffects()) {
                    if (effect.getType() != PotionEffectType.FAST_DIGGING) continue;
                    duration = effect.getDuration();
                    amplifier = effect.getAmplifier();
                    break;
                }
            }
            SkillType skill = (mcMMOPlayer = UserManager.getPlayer(player)).getAbilityMode(AbilityType.SUPER_BREAKER) ? SkillType.MINING : SkillType.EXCAVATION;
            int ticks = PerksUtils.handleActivationPerks(player, 2 + mcMMOPlayer.getSkillLevel(skill) / AdvancedConfig.getInstance().getAbilityLength(), skill.getAbility().getMaxLength()) * 20;
            PotionEffect abilityBuff = new PotionEffect(PotionEffectType.FAST_DIGGING, duration + ticks, amplifier + 10);
            player.addPotionEffect(abilityBuff, true);
        }
    }

    public static void handleAbilitySpeedDecrease(Player player) {
        if (!HiddenConfig.getInstance().useEnchantmentBuffs()) {
            return;
        }
        for (ItemStack item : player.getInventory().getContents()) {
            SkillUtils.removeAbilityBuff(item);
        }
    }

    public static void removeAbilityBuff(ItemStack item) {
        List itemLore;
        if (item == null || item.getType() == Material.AIR || !ItemUtils.isPickaxe(item) && !ItemUtils.isShovel(item) || !item.containsEnchantment(Enchantment.DIG_SPEED)) {
            return;
        }
        ItemMeta itemMeta = item.getItemMeta();
        if (itemMeta.hasLore() && (itemLore = itemMeta.getLore()).remove("mcMMO Ability Tool")) {
            int efficiencyLevel = item.getEnchantmentLevel(Enchantment.DIG_SPEED);
            if (efficiencyLevel <= AdvancedConfig.getInstance().getEnchantBuff()) {
                itemMeta.removeEnchant(Enchantment.DIG_SPEED);
            } else {
                itemMeta.addEnchant(Enchantment.DIG_SPEED, efficiencyLevel - AdvancedConfig.getInstance().getEnchantBuff(), true);
            }
            itemMeta.setLore(itemLore);
            item.setItemMeta(itemMeta);
        }
    }

    public static void handleDurabilityChange(ItemStack itemStack, int durabilityModifier) {
        SkillUtils.handleDurabilityChange(itemStack, durabilityModifier, 1.0);
    }

    public static void handleDurabilityChange(ItemStack itemStack, int durabilityModifier, double maxDamageModifier) {
        Material type = itemStack.getType();
        short maxDurability = mcMMO.getRepairableManager().isRepairable(type) ? mcMMO.getRepairableManager().getRepairable(type).getMaximumDurability() : type.getMaxDurability();
        durabilityModifier = (int)Math.min((double)(durabilityModifier / (itemStack.getEnchantmentLevel(Enchantment.DURABILITY) + 1)), (double)maxDurability * maxDamageModifier);
        itemStack.setDurability((short)Math.min(itemStack.getDurability() + durabilityModifier, maxDurability));
    }

    public static boolean activationSuccessful(SecondaryAbility skillAbility, Player player, SkillType skill) {
        return SkillUtils.activationSuccessful(skillAbility, player, UserManager.getPlayer(player).getSkillLevel(skill), PerksUtils.handleLuckyPerks(player, skill));
    }

    public static boolean activationSuccessful(SecondaryAbility skillAbility, Player player, int skillLevel, int activationChance) {
        return SkillUtils.activationSuccessful(skillAbility, player, skillLevel, activationChance, AdvancedConfig.getInstance().getMaxChance(skillAbility), AdvancedConfig.getInstance().getMaxBonusLevel(skillAbility));
    }

    public static boolean activationSuccessful(SecondaryAbility skillAbility, Player player, int skillLevel, int activationChance, double maxChance, int maxLevel) {
        double chance = maxChance / (double)maxLevel * (double)Math.min(skillLevel, maxLevel) / (double)activationChance;
        SecondaryAbilityWeightedActivationCheckEvent event = new SecondaryAbilityWeightedActivationCheckEvent(player, skillAbility, chance);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        return event.getChance() * (double)activationChance > (double)Misc.getRandom().nextInt(activationChance);
    }

    public static boolean treasureDropSuccessful(Player player, double dropChance, int activationChance) {
        SecondaryAbilityWeightedActivationCheckEvent event = new SecondaryAbilityWeightedActivationCheckEvent(player, SecondaryAbility.EXCAVATION_TREASURE_HUNTER, dropChance / (double)activationChance);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        return event.getChance() * (double)activationChance > Misc.getRandom().nextDouble() * (double)activationChance;
    }

    private static boolean isLocalizedSkill(String skillName) {
        for (SkillType skill : SkillType.values()) {
            if (!skillName.equalsIgnoreCase(LocaleLoader.getString(StringUtils.getCapitalized(skill.toString()) + ".SkillName"))) continue;
            return true;
        }
        return false;
    }
}

