/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.chat;

import com.gmail.nossr50.events.chat.McMMOChatEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public abstract class ChatManager {
    protected Plugin plugin;
    protected boolean useDisplayNames;
    protected String chatPrefix;
    protected String senderName;
    protected String displayName;
    protected String message;

    protected ChatManager(Plugin plugin, boolean useDisplayNames, String chatPrefix) {
        this.plugin = plugin;
        this.useDisplayNames = useDisplayNames;
        this.chatPrefix = chatPrefix;
    }

    protected void handleChat(McMMOChatEvent event) {
        this.plugin.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.senderName = event.getSender();
        this.displayName = this.useDisplayNames ? event.getDisplayName() : this.senderName;
        this.message = LocaleLoader.formatString(this.chatPrefix, this.displayName) + " " + event.getMessage();
        this.sendMessage();
    }

    public void handleChat(String senderName, String message) {
        this.handleChat(senderName, senderName, message, false);
    }

    public void handleChat(Player player, String message, boolean isAsync) {
        this.handleChat(player.getName(), player.getDisplayName(), message, isAsync);
    }

    public void handleChat(String senderName, String displayName, String message) {
        this.handleChat(senderName, displayName, message, false);
    }

    public abstract void handleChat(String var1, String var2, String var3, boolean var4);

    protected abstract void sendMessage();
}

