/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.party;

import com.gmail.nossr50.commands.party.PartySubcommandType;
import com.gmail.nossr50.datatypes.party.Party;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.commands.CommandUtils;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class PartyLockCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (args.length) {
            case 1: {
                if (args[0].equalsIgnoreCase("lock")) {
                    this.togglePartyLock(sender, true);
                } else if (args[0].equalsIgnoreCase("unlock")) {
                    this.togglePartyLock(sender, false);
                }
                return true;
            }
            case 2: {
                if (!args[0].equalsIgnoreCase("lock")) {
                    this.sendUsageStrings(sender);
                    return true;
                }
                if (CommandUtils.shouldEnableToggle(args[1])) {
                    this.togglePartyLock(sender, true);
                } else if (CommandUtils.shouldDisableToggle(args[1])) {
                    this.togglePartyLock(sender, false);
                } else {
                    this.sendUsageStrings(sender);
                }
                return true;
            }
        }
        this.sendUsageStrings(sender);
        return true;
    }

    private void sendUsageStrings(CommandSender sender) {
        sender.sendMessage(LocaleLoader.getString("Commands.Usage.2", "party", "lock", "[on|off]"));
        sender.sendMessage(LocaleLoader.getString("Commands.Usage.1", "party", "unlock"));
    }

    private void togglePartyLock(CommandSender sender, boolean lock) {
        Party party = UserManager.getPlayer((Player)sender).getParty();
        if (!Permissions.partySubcommand((Permissible)sender, lock ? PartySubcommandType.LOCK : PartySubcommandType.UNLOCK)) {
            sender.sendMessage(LocaleLoader.getString("mcMMO.NoPermission"));
            return;
        }
        if (lock ? party.isLocked() : !party.isLocked()) {
            sender.sendMessage(LocaleLoader.getString("Party." + (lock ? "IsLocked" : "IsntLocked")));
            return;
        }
        party.setLocked(lock);
        sender.sendMessage(LocaleLoader.getString("Party." + (lock ? "Locked" : "Unlocked")));
    }
}

