/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.axes.Axes;
import com.gmail.nossr50.util.Permissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class AxesCommand
extends SkillCommand {
    private String critChance;
    private String critChanceLucky;
    private double axeMasteryDamage;
    private double impactDamage;
    private String skullSplitterLength;
    private String skullSplitterLengthEndurance;
    private boolean canSkullSplitter;
    private boolean canCritical;
    private boolean canAxeMastery;
    private boolean canImpact;
    private boolean canGreaterImpact;

    public AxesCommand() {
        super(SkillType.AXES);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canImpact) {
            this.impactDamage = 1.0f + skillValue / (float)Axes.impactIncreaseLevel;
        }
        if (this.canSkullSplitter) {
            String[] skullSplitterStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.skullSplitterLength = skullSplitterStrings[0];
            this.skullSplitterLengthEndurance = skullSplitterStrings[1];
        }
        if (this.canCritical) {
            String[] criticalHitStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.CRITICAL_HIT, isLucky);
            this.critChance = criticalHitStrings[0];
            this.critChanceLucky = criticalHitStrings[1];
        }
        if (this.canAxeMastery) {
            this.axeMasteryDamage = Math.min((double)skillValue / ((double)Axes.axeMasteryMaxBonusLevel / Axes.axeMasteryMaxBonus), Axes.axeMasteryMaxBonus);
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.canSkullSplitter = Permissions.skullSplitter((Permissible)player);
        this.canCritical = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.CRITICAL_HIT);
        this.canAxeMastery = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.AXE_MASTERY);
        this.canImpact = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.ARMOR_IMPACT);
        this.canGreaterImpact = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.GREATER_IMPACT);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canSkullSplitter) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Axes.Effect.0"), LocaleLoader.getString("Axes.Effect.1")));
        }
        if (this.canCritical) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Axes.Effect.2"), LocaleLoader.getString("Axes.Effect.3")));
        }
        if (this.canAxeMastery) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Axes.Effect.4"), LocaleLoader.getString("Axes.Effect.5")));
        }
        if (this.canImpact) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Axes.Effect.6"), LocaleLoader.getString("Axes.Effect.7")));
        }
        if (this.canGreaterImpact) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Axes.Effect.8"), LocaleLoader.getString("Axes.Effect.9")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canAxeMastery) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.0"), LocaleLoader.getString("Axes.Ability.Bonus.1", this.axeMasteryDamage)));
        }
        if (this.canImpact) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.2"), LocaleLoader.getString("Axes.Ability.Bonus.3", this.impactDamage)));
        }
        if (this.canGreaterImpact) {
            messages.add(LocaleLoader.getString("Ability.Generic.Template", LocaleLoader.getString("Axes.Ability.Bonus.4"), LocaleLoader.getString("Axes.Ability.Bonus.5", Axes.greaterImpactBonusDamage)));
        }
        if (this.canCritical) {
            messages.add(LocaleLoader.getString("Axes.Combat.CritChance", this.critChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.critChanceLucky) : ""));
        }
        if (this.canSkullSplitter) {
            messages.add(LocaleLoader.getString("Axes.Combat.SS.Length", this.skullSplitterLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.skullSplitterLengthEndurance) : ""));
        }
        return messages;
    }
}

