/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.commands.skills;

import com.gmail.nossr50.commands.skills.SkillCommand;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.skills.herbalism.Herbalism;
import com.gmail.nossr50.util.Permissions;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class HerbalismCommand
extends SkillCommand {
    private String greenTerraLength;
    private String greenTerraLengthEndurance;
    private String greenThumbChance;
    private String greenThumbChanceLucky;
    private int greenThumbStage;
    private int farmersDietRank;
    private String doubleDropChance;
    private String doubleDropChanceLucky;
    private String hylianLuckChance;
    private String hylianLuckChanceLucky;
    private String shroomThumbChance;
    private String shroomThumbChanceLucky;
    private boolean hasHylianLuck;
    private boolean canGreenTerra;
    private boolean canGreenThumbPlants;
    private boolean canGreenThumbBlocks;
    private boolean canFarmersDiet;
    private boolean canDoubleDrop;
    private boolean canShroomThumb;

    public HerbalismCommand() {
        super(SkillType.HERBALISM);
    }

    @Override
    protected void dataCalculations(Player player, float skillValue, boolean isLucky) {
        if (this.canGreenTerra) {
            String[] greenTerraStrings = this.calculateLengthDisplayValues(player, skillValue);
            this.greenTerraLength = greenTerraStrings[0];
            this.greenTerraLengthEndurance = greenTerraStrings[1];
        }
        if (this.canFarmersDiet) {
            this.farmersDietRank = this.calculateRank(skillValue, Herbalism.farmersDietMaxLevel, Herbalism.farmersDietRankLevel1);
        }
        if (this.canGreenThumbBlocks || this.canGreenThumbPlants) {
            this.greenThumbStage = this.calculateRank(skillValue, Herbalism.greenThumbStageMaxLevel, Herbalism.greenThumbStageChangeLevel);
            String[] greenThumbStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.GREEN_THUMB_PLANT, isLucky);
            this.greenThumbChance = greenThumbStrings[0];
            this.greenThumbChanceLucky = greenThumbStrings[1];
        }
        if (this.canDoubleDrop) {
            String[] doubleDropStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.HERBALISM_DOUBLE_DROPS, isLucky);
            this.doubleDropChance = doubleDropStrings[0];
            this.doubleDropChanceLucky = doubleDropStrings[1];
        }
        if (this.hasHylianLuck) {
            String[] hylianLuckStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.HYLIAN_LUCK, isLucky);
            this.hylianLuckChance = hylianLuckStrings[0];
            this.hylianLuckChanceLucky = hylianLuckStrings[1];
        }
        if (this.canShroomThumb) {
            String[] shroomThumbStrings = this.calculateAbilityDisplayValues(skillValue, SecondaryAbility.SHROOM_THUMB, isLucky);
            this.shroomThumbChance = shroomThumbStrings[0];
            this.shroomThumbChanceLucky = shroomThumbStrings[1];
        }
    }

    @Override
    protected void permissionsCheck(Player player) {
        this.hasHylianLuck = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.HYLIAN_LUCK);
        this.canGreenTerra = Permissions.greenTerra((Permissible)player);
        this.canGreenThumbPlants = Permissions.greenThumbPlant((Permissible)player, Material.CROPS) || Permissions.greenThumbPlant((Permissible)player, Material.CARROT) || Permissions.greenThumbPlant((Permissible)player, Material.POTATO) || Permissions.greenThumbPlant((Permissible)player, Material.NETHER_WARTS) || Permissions.greenThumbPlant((Permissible)player, Material.COCOA);
        this.canGreenThumbBlocks = Permissions.greenThumbBlock((Permissible)player, Material.DIRT) || Permissions.greenThumbBlock((Permissible)player, Material.COBBLESTONE) || Permissions.greenThumbBlock((Permissible)player, Material.COBBLE_WALL) || Permissions.greenThumbBlock((Permissible)player, Material.SMOOTH_BRICK);
        this.canFarmersDiet = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.FARMERS_DIET);
        this.canDoubleDrop = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.HERBALISM_DOUBLE_DROPS) && !this.skill.getDoubleDropsDisabled();
        this.canShroomThumb = Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SHROOM_THUMB);
    }

    @Override
    protected List<String> effectsDisplay() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canGreenTerra) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Herbalism.Effect.0"), LocaleLoader.getString("Herbalism.Effect.1")));
        }
        if (this.canGreenThumbPlants) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Herbalism.Effect.2"), LocaleLoader.getString("Herbalism.Effect.3")));
        }
        if (this.canGreenThumbBlocks) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Herbalism.Effect.4"), LocaleLoader.getString("Herbalism.Effect.5")));
        }
        if (this.canFarmersDiet) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Herbalism.Effect.6"), LocaleLoader.getString("Herbalism.Effect.7")));
        }
        if (this.hasHylianLuck) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Herbalism.Effect.10"), LocaleLoader.getString("Herbalism.Effect.11")));
        }
        if (this.canShroomThumb) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Herbalism.Effect.12"), LocaleLoader.getString("Herbalism.Effect.13")));
        }
        if (this.canDoubleDrop) {
            messages.add(LocaleLoader.getString("Effects.Template", LocaleLoader.getString("Herbalism.Effect.8"), LocaleLoader.getString("Herbalism.Effect.9")));
        }
        return messages;
    }

    @Override
    protected List<String> statsDisplay(Player player, float skillValue, boolean hasEndurance, boolean isLucky) {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.canGreenTerra) {
            messages.add(LocaleLoader.getString("Herbalism.Ability.GTe.Length", this.greenTerraLength) + (hasEndurance ? LocaleLoader.getString("Perks.ActivationTime.Bonus", this.greenTerraLengthEndurance) : ""));
        }
        if (this.canGreenThumbBlocks || this.canGreenThumbPlants) {
            messages.add(LocaleLoader.getString("Herbalism.Ability.GTh.Chance", this.greenThumbChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.greenThumbChanceLucky) : ""));
        }
        if (this.canGreenThumbPlants) {
            messages.add(LocaleLoader.getString("Herbalism.Ability.GTh.Stage", this.greenThumbStage));
        }
        if (this.canFarmersDiet) {
            messages.add(LocaleLoader.getString("Herbalism.Ability.FD", this.farmersDietRank));
        }
        if (this.hasHylianLuck) {
            messages.add(LocaleLoader.getString("Herbalism.Ability.HylianLuck", this.hylianLuckChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.hylianLuckChanceLucky) : ""));
        }
        if (this.canShroomThumb) {
            messages.add(LocaleLoader.getString("Herbalism.Ability.ShroomThumb.Chance", this.shroomThumbChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.shroomThumbChanceLucky) : ""));
        }
        if (this.canDoubleDrop) {
            messages.add(LocaleLoader.getString("Herbalism.Ability.DoubleDropChance", this.doubleDropChance) + (isLucky ? LocaleLoader.getString("Perks.Lucky.Bonus", this.doubleDropChanceLucky) : ""));
        }
        return messages;
    }
}

