/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config;

import com.gmail.nossr50.config.AutoUpdateConfigLoader;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.party.PartyFeature;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.util.StringUtils;
import java.util.ArrayList;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.EntityType;

public class Config
extends AutoUpdateConfigLoader {
    private static Config instance;

    private Config() {
        super("config.yml");
        this.validate();
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    @Override
    protected boolean validateKeys() {
        ArrayList<String> reason = new ArrayList<String>();
        if (this.getSaveInterval() <= 0) {
            reason.add("General.Save_Interval should be greater than 0!");
        }
        if (this.getMobHealthbarTime() == 0) {
            reason.add("Mob_Healthbar.Display_Time cannot be 0! Set to -1 to disable or set a valid value.");
        }
        if (this.getRankScoreboardTime() != -1 && this.getRankScoreboardTime() <= 0) {
            reason.add("Scoreboard.Types.Rank.Display_Time should be greater than 0, or -1!");
        }
        if (this.getStatsScoreboardTime() != -1 && this.getStatsScoreboardTime() <= 0) {
            reason.add("Scoreboard.Types.Stats.Display_Time should be greater than 0, or -1!");
        }
        if (this.getTopScoreboardTime() != -1 && this.getTopScoreboardTime() <= 0) {
            reason.add("Scoreboard.Types.Top.Display_Time should be greater than 0, or -1!");
        }
        if (this.getInspectScoreboardTime() != -1 && this.getInspectScoreboardTime() <= 0) {
            reason.add("Scoreboard.Types.Inspect.Display_Time should be greater than 0, or -1!");
        }
        if (this.getSkillScoreboardTime() != -1 && this.getSkillScoreboardTime() <= 0) {
            reason.add("Scoreboard.Types.Skill.Display_Time should be greater than 0, or -1!");
        }
        if (this.getSkillLevelUpTime() != -1 && this.getSkillScoreboardTime() <= 0) {
            reason.add("Scoreboard.Types.Skill.Display_Time should be greater than 0, or -1!");
        }
        if (!this.getRankUseChat() && !this.getRankUseBoard()) {
            reason.add("Either Board or Print in Scoreboard.Types.Rank must be true!");
        }
        if (!this.getTopUseChat() && !this.getTopUseBoard()) {
            reason.add("Either Board or Print in Scoreboard.Types.Top must be true!");
        }
        if (!this.getStatsUseChat() && !this.getStatsUseBoard()) {
            reason.add("Either Board or Print in Scoreboard.Types.Stats must be true!");
        }
        if (!this.getInspectUseChat() && !this.getInspectUseBoard()) {
            reason.add("Either Board or Print in Scoreboard.Types.Inspect must be true!");
        }
        if (this.getPurgeInterval() < -1) {
            reason.add("Database_Purging.Purge_Interval should be greater than, or equal to -1!");
        }
        if (this.getOldUsersCutoff() != -1 && this.getOldUsersCutoff() <= 0) {
            reason.add("Database_Purging.Old_User_Cutoff should be greater than 0 or -1!");
        }
        if (this.getHardcoreDeathStatPenaltyPercentage() < 0.01 || this.getHardcoreDeathStatPenaltyPercentage() > 100.0) {
            reason.add("Hardcore.Death_Stat_Loss.Penalty_Percentage only accepts values from 0.01 to 100!");
        }
        if (this.getHardcoreVampirismStatLeechPercentage() < 0.01 || this.getHardcoreVampirismStatLeechPercentage() > 100.0) {
            reason.add("Hardcore.Vampirism.Leech_Percentage only accepts values from 0.01 to 100!");
        }
        if (this.getChimaeraUseCost() < 1 || this.getChimaeraUseCost() > 64) {
            reason.add("Items.Chimaera_Wing.Use_Cost only accepts values from 1 to 64!");
        }
        if (this.getChimaeraRecipeCost() < 1 || this.getChimaeraRecipeCost() > 9) {
            reason.add("Items.Chimaera_Wing.Recipe_Cost only accepts values from 1 to 9!");
        }
        if (this.getChimaeraItem() == null) {
            reason.add("Items.Chimaera_Wing.Item_Name is invalid!");
        }
        if (this.getLevelUpEffectsTier() < 1) {
            reason.add("Particles.LevelUp_Tier should be at least 1!");
        }
        if (this.getAutoPartyKickInterval() < -1) {
            reason.add("Party.AutoKick_Interval should be at least -1!");
        }
        if (this.getAutoPartyKickTime() < 0) {
            reason.add("Party.Old_Party_Member_Cutoff should be at least 0!");
        }
        if (this.getPartyShareBonusBase() <= 0.0) {
            reason.add("Party.Sharing.ExpShare_bonus_base should be greater than 0!");
        }
        if (this.getPartyShareBonusIncrease() < 0.0) {
            reason.add("Party.Sharing.ExpShare_bonus_increase should be at least 0!");
        }
        if (this.getPartyShareBonusCap() <= 0.0) {
            reason.add("Party.Sharing.ExpShare_bonus_cap should be greater than 0!");
        }
        if (this.getPartyShareRange() <= 0.0) {
            reason.add("Party.Sharing.Range should be greater than 0!");
        }
        if (this.getPartyXpCurveMultiplier() < 1) {
            reason.add("Party.Leveling.Xp_Curve_Modifier should be at least 1!");
        }
        for (PartyFeature partyFeature : PartyFeature.values()) {
            if (this.getPartyFeatureUnlockLevel(partyFeature) >= 0) continue;
            reason.add("Party.Leveling." + StringUtils.getPrettyPartyFeatureString(partyFeature).replace(" ", "") + "_UnlockLevel should be at least 0!");
        }
        if (this.getInspectDistance() <= 0.0) {
            reason.add("Commands.inspect.Max_Distance should be greater than 0!");
        }
        if (this.getTreeFellerThreshold() <= 0) {
            reason.add("Abilities.Limits.Tree_Feller_Threshold should be greater than 0!");
        }
        if (this.getDetonatorItem() == null) {
            reason.add("Skills.Mining.Detonator_Item is invalid!");
        }
        if (this.getRepairAnvilMaterial() == null) {
            reason.add("Skills.Repair.Anvil_Type is invalid!!");
        }
        if (this.getSalvageAnvilMaterial() == null) {
            reason.add("Skills.Repair.Salvage_Anvil_Type is invalid!");
        }
        if (this.getRepairAnvilMaterial() == this.getSalvageAnvilMaterial()) {
            reason.add("Cannot use the same item for Repair and Salvage anvils!");
        }
        if (this.getTamingCOTWMaterial(EntityType.WOLF) == null) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Wolf.Item_Material is invalid!!");
        }
        if (this.getTamingCOTWMaterial(EntityType.OCELOT) == null) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Ocelot.Item_Material is invalid!!");
        }
        if (this.getTamingCOTWMaterial(EntityType.HORSE) == null) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Horse.Item_Material is invalid!!");
        }
        if (this.getTamingCOTWCost(EntityType.WOLF) <= 0) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Wolf.Item_Amount should be greater than 0!");
        }
        if (this.getTamingCOTWCost(EntityType.OCELOT) <= 0) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Ocelot.Item_Amount should be greater than 0!");
        }
        if (this.getTamingCOTWCost(EntityType.HORSE) <= 0) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Horse.Item_Amount should be greater than 0!");
        }
        if (this.getTamingCOTWAmount(EntityType.WOLF) <= 0) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Wolf.Summon_Amount should be greater than 0!");
        }
        if (this.getTamingCOTWAmount(EntityType.OCELOT) <= 0) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Ocelot.Summon_Amount should be greater than 0!");
        }
        if (this.getTamingCOTWAmount(EntityType.HORSE) <= 0) {
            reason.add("Skills.Taming.Call_Of_The_Wild.Horse.Summon_Amount should be greater than 0!");
        }
        return this.noErrorsInConfig(reason);
    }

    @Override
    protected void loadKeys() {
    }

    public String getLocale() {
        return this.config.getString("General.Locale", "en_us");
    }

    public boolean getMOTDEnabled() {
        return this.config.getBoolean("General.MOTD_Enabled", true);
    }

    public boolean getDonateMessageEnabled() {
        return this.config.getBoolean("Commands.mcmmo.Donate_Message", true);
    }

    public int getSaveInterval() {
        return this.config.getInt("General.Save_Interval", 10);
    }

    public boolean getStatsTrackingEnabled() {
        return this.config.getBoolean("General.Stats_Tracking", true);
    }

    public boolean getUpdateCheckEnabled() {
        return this.config.getBoolean("General.Update_Check", true);
    }

    public boolean getPreferBeta() {
        return this.config.getBoolean("General.Prefer_Beta", false);
    }

    public boolean getEventCallbackEnabled() {
        return this.config.getBoolean("General.Event_Callback", true);
    }

    public boolean getVerboseLoggingEnabled() {
        return this.config.getBoolean("General.Verbose_Logging", false);
    }

    public String getPartyChatPrefix() {
        return this.config.getString("Commands.partychat.Chat_Prefix_Format", "[[GREEN]]([[WHITE]]{0}[[GREEN]])");
    }

    public boolean getPartyChatColorLeaderName() {
        return this.config.getBoolean("Commands.partychat.Gold_Leader_Name", true);
    }

    public boolean getPartyDisplayNames() {
        return this.config.getBoolean("Commands.partychat.Use_Display_Names", true);
    }

    public String getPartyChatPrefixAlly() {
        return this.config.getString("Commands.partychat.Chat_Prefix_Format_Ally", "[[GREEN]](A)[[RESET]]");
    }

    public String getAdminChatPrefix() {
        return this.config.getString("Commands.adminchat.Chat_Prefix_Format", "[[AQUA]][[[WHITE]]{0}[[AQUA]]]");
    }

    public boolean getAdminDisplayNames() {
        return this.config.getBoolean("Commands.adminchat.Use_Display_Names", true);
    }

    public boolean getMatchOfflinePlayers() {
        return this.config.getBoolean("Commands.Generic.Match_OfflinePlayers", false);
    }

    public long getDatabasePlayerCooldown() {
        return this.config.getLong("Commands.Database.Player_Cooldown", 1750L);
    }

    public boolean getLevelUpSoundsEnabled() {
        return this.config.getBoolean("General.LevelUp_Sounds", true);
    }

    public MobHealthbarType getMobHealthbarDefault() {
        try {
            return MobHealthbarType.valueOf(this.config.getString("Mob_Healthbar.Display_Type", "HEARTS").toUpperCase().trim());
        }
        catch (IllegalArgumentException ex) {
            return MobHealthbarType.HEARTS;
        }
    }

    public int getMobHealthbarTime() {
        return this.config.getInt("Mob_Healthbar.Display_Time", 3);
    }

    public boolean getRankUseChat() {
        return this.config.getBoolean("Scoreboard.Types.Rank.Print", false);
    }

    public boolean getRankUseBoard() {
        return this.config.getBoolean("Scoreboard.Types.Rank.Board", true);
    }

    public int getRankScoreboardTime() {
        return this.config.getInt("Scoreboard.Types.Rank.Display_Time", 10);
    }

    public boolean getTopUseChat() {
        return this.config.getBoolean("Scoreboard.Types.Top.Print", true);
    }

    public boolean getTopUseBoard() {
        return this.config.getBoolean("Scoreboard.Types.Top.Board", true);
    }

    public int getTopScoreboardTime() {
        return this.config.getInt("Scoreboard.Types.Top.Display_Time", 15);
    }

    public boolean getStatsUseChat() {
        return this.config.getBoolean("Scoreboard.Types.Stats.Print", true);
    }

    public boolean getStatsUseBoard() {
        return this.config.getBoolean("Scoreboard.Types.Stats.Board", true);
    }

    public int getStatsScoreboardTime() {
        return this.config.getInt("Scoreboard.Types.Stats.Display_Time", 10);
    }

    public boolean getInspectUseChat() {
        return this.config.getBoolean("Scoreboard.Types.Inspect.Print", true);
    }

    public boolean getInspectUseBoard() {
        return this.config.getBoolean("Scoreboard.Types.Inspect.Board", true);
    }

    public int getInspectScoreboardTime() {
        return this.config.getInt("Scoreboard.Types.Inspect.Display_Time", 25);
    }

    public boolean getCooldownUseChat() {
        return this.config.getBoolean("Scoreboard.Types.Cooldown.Print", false);
    }

    public boolean getCooldownUseBoard() {
        return this.config.getBoolean("Scoreboard.Types.Cooldown.Board", true);
    }

    public int getCooldownScoreboardTime() {
        return this.config.getInt("Scoreboard.Types.Cooldown.Display_Time", 41);
    }

    public boolean getSkillUseBoard() {
        return this.config.getBoolean("Scoreboard.Types.Skill.Board", true);
    }

    public int getSkillScoreboardTime() {
        return this.config.getInt("Scoreboard.Types.Skill.Display_Time", 30);
    }

    public boolean getSkillLevelUpBoard() {
        return this.config.getBoolean("Scoreboard.Types.Skill.LevelUp_Board", true);
    }

    public int getSkillLevelUpTime() {
        return this.config.getInt("Scoreboard.Types.Skill.LevelUp_Time", 5);
    }

    public boolean getPowerLevelTagsEnabled() {
        return this.config.getBoolean("Scoreboard.Power_Level_Tags", false);
    }

    public boolean getAllowKeepBoard() {
        return this.config.getBoolean("Scoreboard.Allow_Keep", true);
    }

    public boolean getScoreboardRainbows() {
        return this.config.getBoolean("Scoreboard.Rainbows", false);
    }

    public int getPurgeInterval() {
        return this.config.getInt("Database_Purging.Purge_Interval", -1);
    }

    public int getOldUsersCutoff() {
        return this.config.getInt("Database_Purging.Old_User_Cutoff", 6);
    }

    public boolean getBackupsEnabled() {
        return this.config.getBoolean("Backups.Enabled", true);
    }

    public boolean getKeepLast24Hours() {
        return this.config.getBoolean("Backups.Keep.Last_24_Hours", true);
    }

    public boolean getKeepDailyLastWeek() {
        return this.config.getBoolean("Backups.Keep.Daily_Last_Week", true);
    }

    public boolean getKeepWeeklyPastMonth() {
        return this.config.getBoolean("Backups.Keep.Weekly_Past_Months", true);
    }

    public boolean getUseMySQL() {
        return this.config.getBoolean("MySQL.Enabled", false);
    }

    public String getMySQLTablePrefix() {
        return this.config.getString("MySQL.Database.TablePrefix", "mcmmo_");
    }

    public String getMySQLDatabaseName() {
        return this.getStringIncludingInts("MySQL.Database.Name");
    }

    public String getMySQLUserName() {
        return this.getStringIncludingInts("MySQL.Database.User_Name");
    }

    public int getMySQLServerPort() {
        return this.config.getInt("MySQL.Server.Port", 3306);
    }

    public String getMySQLServerName() {
        return this.config.getString("MySQL.Server.Address", "localhost");
    }

    public String getMySQLUserPassword() {
        return this.getStringIncludingInts("MySQL.Database.User_Password");
    }

    private String getStringIncludingInts(String key) {
        String str = this.config.getString(key);
        if (str == null) {
            str = String.valueOf(this.config.getInt(key));
        }
        if (str.equals("0")) {
            str = "No value set for '" + key + "'";
        }
        return str;
    }

    public boolean getHardcoreStatLossEnabled(SkillType skillType) {
        return this.config.getBoolean("Hardcore.Death_Stat_Loss.Enabled." + StringUtils.getCapitalized(skillType.toString()), false);
    }

    public void setHardcoreStatLossEnabled(SkillType skillType, boolean enabled) {
        this.config.set("Hardcore.Death_Stat_Loss.Enabled." + StringUtils.getCapitalized(skillType.toString()), (Object)enabled);
    }

    public double getHardcoreDeathStatPenaltyPercentage() {
        return this.config.getDouble("Hardcore.Death_Stat_Loss.Penalty_Percentage", 75.0);
    }

    public void setHardcoreDeathStatPenaltyPercentage(double value) {
        this.config.set("Hardcore.Death_Stat_Loss.Penalty_Percentage", (Object)value);
    }

    public int getHardcoreDeathStatPenaltyLevelThreshold() {
        return this.config.getInt("Hardcore.Death_Stat_Loss.Level_Threshold", 0);
    }

    public boolean getHardcoreVampirismEnabled(SkillType skillType) {
        return this.config.getBoolean("Hardcore.Vampirism.Enabled." + StringUtils.getCapitalized(skillType.toString()), false);
    }

    public void setHardcoreVampirismEnabled(SkillType skillType, boolean enabled) {
        this.config.set("Hardcore.Vampirism.Enabled." + StringUtils.getCapitalized(skillType.toString()), (Object)enabled);
    }

    public double getHardcoreVampirismStatLeechPercentage() {
        return this.config.getDouble("Hardcore.Vampirism.Leech_Percentage", 5.0);
    }

    public void setHardcoreVampirismStatLeechPercentage(double value) {
        this.config.set("Hardcore.Vampirism.Leech_Percentage", (Object)value);
    }

    public int getHardcoreVampirismLevelThreshold() {
        return this.config.getInt("Hardcore.Vampirism.Level_Threshold", 0);
    }

    public boolean getToolModsEnabled() {
        return this.config.getBoolean("Mods.Tool_Mods_Enabled", false);
    }

    public boolean getArmorModsEnabled() {
        return this.config.getBoolean("Mods.Armor_Mods_Enabled", false);
    }

    public boolean getBlockModsEnabled() {
        return this.config.getBoolean("Mods.Block_Mods_Enabled", false);
    }

    public boolean getEntityModsEnabled() {
        return this.config.getBoolean("Mods.Entity_Mods_Enabled", false);
    }

    public int getChimaeraUseCost() {
        return this.config.getInt("Items.Chimaera_Wing.Use_Cost", 1);
    }

    public int getChimaeraRecipeCost() {
        return this.config.getInt("Items.Chimaera_Wing.Recipe_Cost", 5);
    }

    public Material getChimaeraItem() {
        return Material.matchMaterial((String)this.config.getString("Items.Chimaera_Wing.Item_Name", "Feather"));
    }

    public boolean getChimaeraEnabled() {
        return this.config.getBoolean("Items.Chimaera_Wing.Enabled", true);
    }

    public boolean getChimaeraPreventUseUnderground() {
        return this.config.getBoolean("Items.Chimaera_Wing.Prevent_Use_Underground", true);
    }

    public int getChimaeraCooldown() {
        return this.config.getInt("Items.Chimaera_Wing.Cooldown", 240);
    }

    public int getChimaeraWarmup() {
        return this.config.getInt("Items.Chimaera_Wing.Warmup", 5);
    }

    public int getChimaeraRecentlyHurtCooldown() {
        return this.config.getInt("Items.Chimaera_Wing.RecentlyHurt_Cooldown", 60);
    }

    public boolean getChimaeraSoundEnabled() {
        return this.config.getBoolean("Items.Chimaera_Wing.Sound_Enabled", true);
    }

    public boolean getAbilityActivationEffectEnabled() {
        return this.config.getBoolean("Particles.Ability_Activation", true);
    }

    public boolean getAbilityDeactivationEffectEnabled() {
        return this.config.getBoolean("Particles.Ability_Deactivation", true);
    }

    public boolean getDodgeEffectEnabled() {
        return this.config.getBoolean("Particles.Dodge", true);
    }

    public boolean getBleedEffectEnabled() {
        return this.config.getBoolean("Particles.Bleed", true);
    }

    public boolean getGreaterImpactEffectEnabled() {
        return this.config.getBoolean("Particles.Greater_Impact", true);
    }

    public boolean getLevelUpEffectsEnabled() {
        return this.config.getBoolean("Particles.LevelUp_Enabled", true);
    }

    public int getLevelUpEffectsTier() {
        return this.config.getInt("Particles.LevelUp_Tier", 100);
    }

    public boolean getLargeFireworks() {
        return this.config.getBoolean("Particles.LargeFireworks", true);
    }

    public int getAutoPartyKickInterval() {
        return this.config.getInt("Party.AutoKick_Interval", 12);
    }

    public int getAutoPartyKickTime() {
        return this.config.getInt("Party.Old_Party_Member_Cutoff", 7);
    }

    public double getPartyShareBonusBase() {
        return this.config.getDouble("Party.Sharing.ExpShare_bonus_base", 1.1);
    }

    public double getPartyShareBonusIncrease() {
        return this.config.getDouble("Party.Sharing.ExpShare_bonus_increase", 0.05);
    }

    public double getPartyShareBonusCap() {
        return this.config.getDouble("Party.Sharing.ExpShare_bonus_cap", 1.5);
    }

    public double getPartyShareRange() {
        return this.config.getDouble("Party.Sharing.Range", 75.0);
    }

    public int getPartyLevelCap() {
        int cap = this.config.getInt("Party.Leveling.Level_Cap", 10);
        return cap <= 0 ? Integer.MAX_VALUE : cap;
    }

    public int getPartyXpCurveMultiplier() {
        return this.config.getInt("Party.Leveling.Xp_Curve_Modifier", 3);
    }

    public boolean getPartyXpNearMembersNeeded() {
        return this.config.getBoolean("Party.Leveling.Near_Members_Needed", false);
    }

    public boolean getPartyInformAllMembers() {
        return this.config.getBoolean("Party.Leveling.Inform_All_Party_Members_On_LevelUp", false);
    }

    public int getPartyFeatureUnlockLevel(PartyFeature partyFeature) {
        return this.config.getInt("Party.Leveling." + StringUtils.getPrettyPartyFeatureString(partyFeature).replace(" ", "") + "_UnlockLevel", 0);
    }

    public int getPTPCommandCooldown() {
        return this.config.getInt("Commands.ptp.Cooldown", 120);
    }

    public int getPTPCommandWarmup() {
        return this.config.getInt("Commands.ptp.Warmup", 5);
    }

    public int getPTPCommandRecentlyHurtCooldown() {
        return this.config.getInt("Commands.ptp.RecentlyHurt_Cooldown", 60);
    }

    public int getPTPCommandTimeout() {
        return this.config.getInt("Commands.ptp.Request_Timeout", 300);
    }

    public boolean getPTPCommandConfirmRequired() {
        return this.config.getBoolean("Commands.ptp.Accept_Required", true);
    }

    public boolean getPTPCommandWorldPermissions() {
        return this.config.getBoolean("Commands.ptp.World_Based_Permissions", false);
    }

    public double getInspectDistance() {
        return this.config.getDouble("Commands.inspect.Max_Distance", 30.0);
    }

    public boolean getAbilityMessagesEnabled() {
        return this.config.getBoolean("Abilities.Messages", true);
    }

    public boolean getAbilitiesEnabled() {
        return this.config.getBoolean("Abilities.Enabled", true);
    }

    public boolean getAbilitiesOnlyActivateWhenSneaking() {
        return this.config.getBoolean("Abilities.Activation.Only_Activate_When_Sneaking", false);
    }

    public int getCooldown(AbilityType ability) {
        return this.config.getInt("Abilities.Cooldowns." + ability.toString());
    }

    public int getMaxLength(AbilityType ability) {
        return this.config.getInt("Abilities.Max_Seconds." + ability.toString());
    }

    public int getAbilityToolDamage() {
        return this.config.getInt("Abilities.Tools.Durability_Loss", 1);
    }

    public int getTreeFellerThreshold() {
        return this.config.getInt("Abilities.Limits.Tree_Feller_Threshold", 500);
    }

    public boolean getDoubleDropsEnabled(SkillType skill, Material material) {
        return this.config.getBoolean("Double_Drops." + StringUtils.getCapitalized(skill.toString()) + "." + StringUtils.getPrettyItemString(material).replace(" ", "_"));
    }

    public boolean getDoubleDropsDisabled(SkillType skill) {
        String skillName = StringUtils.getCapitalized(skill.toString());
        ConfigurationSection section = this.config.getConfigurationSection("Double_Drops." + skillName);
        Set keys = section.getKeys(false);
        boolean disabled = true;
        for (String key : keys) {
            if (!this.config.getBoolean("Double_Drops." + skillName + "." + key)) continue;
            disabled = false;
            break;
        }
        return disabled;
    }

    public boolean getDodgeLightningDisabled() {
        return this.config.getBoolean("Skills.Acrobatics.Prevent_Dodge_Lightning", false);
    }

    public int getXPAfterTeleportCooldown() {
        return this.config.getInt("Skills.Acrobatics.XP_After_Teleport_Cooldown", 5);
    }

    public boolean getEnabledForHoppers() {
        return this.config.getBoolean("Skills.Alchemy.Enabled_for_Hoppers", true);
    }

    public boolean getPreventHopperTransfer() {
        return this.config.getBoolean("Skills.Alchemy.Prevent_Hopper_Transfer", false);
    }

    public boolean getFishingDropsEnabled() {
        return this.config.getBoolean("Skills.Fishing.Drops_Enabled", true);
    }

    public boolean getFishingOverrideTreasures() {
        return this.config.getBoolean("Skills.Fishing.Override_Vanilla_Treasures", true);
    }

    public boolean getFishingExtraFish() {
        return this.config.getBoolean("Skills.Fishing.Extra_Fish", true);
    }

    public Material getDetonatorItem() {
        return Material.matchMaterial((String)this.config.getString("Skills.Mining.Detonator_Name", "FLINT_AND_STEEL"));
    }

    public boolean getRepairAnvilMessagesEnabled() {
        return this.config.getBoolean("Skills.Repair.Anvil_Messages", true);
    }

    public boolean getRepairAnvilPlaceSoundsEnabled() {
        return this.config.getBoolean("Skills.Repair.Anvil_Placed_Sounds", true);
    }

    public boolean getRepairAnvilUseSoundsEnabled() {
        return this.config.getBoolean("Skills.Repair.Anvil_Use_Sounds", true);
    }

    public Material getRepairAnvilMaterial() {
        return Material.matchMaterial((String)this.config.getString("Skills.Repair.Anvil_Material", "IRON_BLOCK"));
    }

    public Material getSalvageAnvilMaterial() {
        return Material.matchMaterial((String)this.config.getString("Skills.Repair.Salvage_Anvil_Material", "GOLD_BLOCK"));
    }

    public boolean getSalvageTools() {
        return this.config.getBoolean("Skills.Repair.Salvage_tools", true);
    }

    public boolean getSalvageArmor() {
        return this.config.getBoolean("Skills.Repair.Salvage_armor", true);
    }

    public boolean getRepairConfirmRequired() {
        return this.config.getBoolean("Skills.Repair.Confirm_Required", true);
    }

    public boolean getUnarmedBlockCrackerSmoothbrickToCracked() {
        return this.config.getBoolean("Skills.Unarmed.Block_Cracker.SmoothBrick_To_CrackedBrick", true);
    }

    public Material getTamingCOTWMaterial(EntityType type) {
        return Material.matchMaterial((String)this.config.getString("Skills.Taming.Call_Of_The_Wild." + StringUtils.getPrettyEntityTypeString(type) + ".Item_Material"));
    }

    public int getTamingCOTWCost(EntityType type) {
        return this.config.getInt("Skills.Taming.Call_Of_The_Wild." + StringUtils.getPrettyEntityTypeString(type) + ".Item_Amount");
    }

    public int getTamingCOTWAmount(EntityType type) {
        return this.config.getInt("Skills.Taming.Call_Of_The_Wild." + StringUtils.getPrettyEntityTypeString(type) + ".Summon_Amount");
    }

    public double getTamingCOTWRange() {
        return this.config.getDouble("Skills.Taming.Call_Of_The_Wild.Range", 40.0);
    }

    public boolean getWoodcuttingDoubleDropsEnabled(TreeSpecies species) {
        return this.config.getBoolean("Double_Drops.Woodcutting." + StringUtils.getPrettyTreeSpeciesString(species).replace(" ", "_"));
    }

    public boolean getTreeFellerSoundsEnabled() {
        return this.config.getBoolean("Skills.Woodcutting.Tree_Feller_Sounds", true);
    }

    public boolean getAcrobaticsPreventAFK() {
        return this.config.getBoolean("Skills.Acrobatics.Prevent_AFK_Leveling", true);
    }

    public int getAcrobaticsAFKMaxTries() {
        return this.config.getInt("Skills.Acrobatics.Max_Tries_At_Same_Location", 3);
    }

    public boolean getHerbalismPreventAFK() {
        return this.config.getBoolean("Skills.Herbalism.Prevent_AFK_Leveling", true);
    }

    public int getPowerLevelCap() {
        int cap = this.config.getInt("General.Power_Level_Cap", 0);
        return cap <= 0 ? Integer.MAX_VALUE : cap;
    }

    public int getLevelCap(SkillType skill) {
        int cap = this.config.getInt("Skills." + StringUtils.getCapitalized(skill.toString()) + ".Level_Cap");
        return cap <= 0 ? Integer.MAX_VALUE : cap;
    }

    public boolean getPVPEnabled(SkillType skill) {
        return this.config.getBoolean("Skills." + StringUtils.getCapitalized(skill.toString()) + ".Enabled_For_PVP", true);
    }

    public boolean getPVEEnabled(SkillType skill) {
        return this.config.getBoolean("Skills." + StringUtils.getCapitalized(skill.toString()) + ".Enabled_For_PVE", true);
    }
}

