/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.config.mods;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.mods.CustomEntity;
import java.util.HashMap;
import org.apache.commons.lang.ClassUtils;
import org.bukkit.Material;
import org.bukkit.material.MaterialData;

public class CustomEntityConfig
extends ConfigLoader {
    public HashMap<String, CustomEntity> customEntityClassMap = new HashMap();
    public HashMap<String, CustomEntity> customEntityTypeMap = new HashMap();

    protected CustomEntityConfig(String fileName) {
        super("mods", fileName);
        this.loadKeys();
    }

    @Override
    protected void loadKeys() {
        if (this.config.getConfigurationSection("Hostile") != null) {
            this.backup();
            return;
        }
        for (String entityName : this.config.getKeys(false)) {
            Class clazz = null;
            String className = this.config.getString(entityName + ".Class", "");
            try {
                clazz = ClassUtils.getClass((String)className);
            }
            catch (ClassNotFoundException e) {
                plugin.getLogger().warning("Invalid class (" + className + ") detected for " + entityName + ".");
                plugin.getLogger().warning("This custom entity may not function properly.");
            }
            String entityTypeName = entityName.replace("_", ".");
            double xpMultiplier = this.config.getDouble(entityName + ".XP_Multiplier", 1.0);
            boolean canBeTamed = this.config.getBoolean(entityName + ".Tameable");
            int tamingXp = this.config.getInt(entityName + ".Taming_XP");
            boolean canBeSummoned = this.config.getBoolean(entityName + ".CanBeSummoned");
            Material callOfTheWildMaterial = Material.matchMaterial((String)this.config.getString(entityName + ".COTW_Material", ""));
            byte callOfTheWildData = (byte)this.config.getInt(entityName + ".COTW_Material_Data");
            int callOfTheWildAmount = this.config.getInt(entityName + ".COTW_Material_Amount");
            if (canBeSummoned && (callOfTheWildMaterial == null || callOfTheWildAmount == 0)) {
                plugin.getLogger().warning("Incomplete Call of the Wild information. This entity will not be able to be summoned by Call of the Wild.");
                canBeSummoned = false;
            }
            CustomEntity entity = new CustomEntity(xpMultiplier, canBeTamed, tamingXp, canBeSummoned, canBeSummoned ? new MaterialData(callOfTheWildMaterial, callOfTheWildData).toItemStack(1) : null, callOfTheWildAmount);
            this.customEntityTypeMap.put(entityTypeName, entity);
            this.customEntityClassMap.put(clazz == null ? null : clazz.getName(), entity);
        }
    }
}

