/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.database;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.database.DatabaseManager;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.database.DatabaseType;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;

public final class FlatfileDatabaseManager
implements DatabaseManager {
    private final HashMap<SkillType, List<PlayerStat>> playerStatHash = new HashMap();
    private final List<PlayerStat> powerLevels = new ArrayList<PlayerStat>();
    private long lastUpdate = 0L;
    private final long UPDATE_WAIT_TIME = 600000L;
    private final File usersFile = new File(mcMMO.getUsersFilePath());
    private static final Object fileWritingLock = new Object();

    protected FlatfileDatabaseManager() {
        this.checkStructure();
        this.updateLeaderboards();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgePowerlessUsers() {
        int purgedUsers = 0;
        mcMMO.p.getLogger().info("Purging powerless users...");
        BufferedReader in = null;
        FileWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    Map<SkillType, Integer> skills = this.getSkillMapFromLine(character);
                    boolean powerless = true;
                    for (int skill : skills.values()) {
                        if (skill == 0) continue;
                        powerless = false;
                        break;
                    }
                    if (!powerless) {
                        writer.append(line).append("\r\n");
                        continue;
                    }
                    ++purgedUsers;
                    Misc.profileCleanup(character[0]);
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
                this.tryClose(in);
                this.tryClose(out);
            }
            catch (IOException e) {
                try {
                    mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
                    this.tryClose(in);
                    this.tryClose(out);
                }
                catch (Throwable throwable) {
                    this.tryClose(in);
                    this.tryClose(out);
                    throw throwable;
                }
            }
        }
        mcMMO.p.getLogger().info("Purged " + purgedUsers + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeOldUsers() {
        int removedPlayers = 0;
        long currentTime = System.currentTimeMillis();
        mcMMO.p.getLogger().info("Purging old users...");
        BufferedReader in = null;
        FileWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    Object[] character = line.split(":");
                    String name = character[0];
                    long lastPlayed = 0L;
                    boolean rewrite = false;
                    try {
                        lastPlayed = Long.parseLong(character[37]) * 1000L;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                    if (lastPlayed == 0L) {
                        OfflinePlayer player = mcMMO.p.getServer().getOfflinePlayer(name);
                        lastPlayed = player.getLastPlayed();
                        rewrite = true;
                    }
                    if (currentTime - lastPlayed > PURGE_TIME) {
                        ++removedPlayers;
                        Misc.profileCleanup(name);
                        continue;
                    }
                    if (rewrite) {
                        character[37] = Long.toString(lastPlayed);
                        String newLine = StringUtils.join((Object[])character, (String)":");
                        writer.append(newLine).append("\r\n");
                        continue;
                    }
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
                this.tryClose(in);
                this.tryClose(out);
            }
            catch (IOException e) {
                try {
                    mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
                    this.tryClose(in);
                    this.tryClose(out);
                }
                catch (Throwable throwable) {
                    this.tryClose(in);
                    this.tryClose(out);
                    throw throwable;
                }
            }
        }
        mcMMO.p.getLogger().info("Purged " + removedPlayers + " users from the database.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeUser(String playerName) {
        boolean worked = false;
        BufferedReader in = null;
        FileWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (!worked && line.split(":")[0].equalsIgnoreCase(playerName)) {
                        mcMMO.p.getLogger().info("User found, removing...");
                        worked = true;
                        continue;
                    }
                    writer.append(line).append("\r\n");
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
                this.tryClose(in);
                this.tryClose(out);
            }
            catch (Exception e) {
                try {
                    mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
                    this.tryClose(in);
                    this.tryClose(out);
                }
                catch (Throwable throwable) {
                    this.tryClose(in);
                    this.tryClose(out);
                    throw throwable;
                }
            }
        }
        Misc.profileCleanup(playerName);
        return worked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUser(PlayerProfile profile) {
        String playerName = profile.getPlayerName();
        BufferedReader in = null;
        FileWriter out = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            boolean bl;
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                StringBuilder writer = new StringBuilder();
                while ((line = in.readLine()) != null) {
                    if (!line.split(":")[0].equalsIgnoreCase(playerName)) {
                        writer.append(line).append("\r\n");
                        continue;
                    }
                    writer.append(playerName).append(":");
                    writer.append(profile.getSkillLevel(SkillType.MINING)).append(":");
                    writer.append(":");
                    writer.append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.MINING)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.WOODCUTTING)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.WOODCUTTING)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.REPAIR)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.UNARMED)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.HERBALISM)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.EXCAVATION)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.ARCHERY)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.SWORDS)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.AXES)).append(":");
                    writer.append(profile.getSkillLevel(SkillType.ACROBATICS)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.REPAIR)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.UNARMED)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.HERBALISM)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.EXCAVATION)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.ARCHERY)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.SWORDS)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.AXES)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.ACROBATICS)).append(":");
                    writer.append(":");
                    writer.append(profile.getSkillLevel(SkillType.TAMING)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.TAMING)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.BERSERK)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.GIGA_DRILL_BREAKER)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.TREE_FELLER)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.GREEN_TERRA)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.SERRATED_STRIKES)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.SKULL_SPLITTER)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.SUPER_BREAKER)).append(":");
                    writer.append(":");
                    writer.append(profile.getSkillLevel(SkillType.FISHING)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.FISHING)).append(":");
                    writer.append((int)profile.getAbilityDATS(AbilityType.BLAST_MINING)).append(":");
                    writer.append(System.currentTimeMillis() / 1000L).append(":");
                    MobHealthbarType mobHealthbarType = profile.getMobHealthbarType();
                    writer.append(mobHealthbarType == null ? Config.getInstance().getMobHealthbarDefault().toString() : mobHealthbarType.toString()).append(":");
                    writer.append(profile.getSkillLevel(SkillType.ALCHEMY)).append(":");
                    writer.append(profile.getSkillXpLevel(SkillType.ALCHEMY)).append(":");
                    writer.append("\r\n");
                }
                out = new FileWriter(usersFilePath);
                out.write(writer.toString());
                bl = true;
                this.tryClose(in);
                this.tryClose(out);
            }
            catch (Exception e) {
                boolean bl2;
                try {
                    e.printStackTrace();
                    bl2 = false;
                    this.tryClose(in);
                    this.tryClose(out);
                }
                catch (Throwable throwable) {
                    this.tryClose(in);
                    this.tryClose(out);
                    throw throwable;
                }
                return bl2;
            }
            return bl;
        }
    }

    @Override
    public List<PlayerStat> readLeaderboard(SkillType skill, int pageNumber, int statsPerPage) {
        this.updateLeaderboards();
        List<PlayerStat> statsList = skill == null ? this.powerLevels : this.playerStatHash.get((Object)skill);
        int fromIndex = (Math.max(pageNumber, 1) - 1) * statsPerPage;
        return statsList.subList(Math.min(fromIndex, statsList.size()), Math.min(fromIndex + statsPerPage, statsList.size()));
    }

    @Override
    public Map<SkillType, Integer> readRank(String playerName) {
        this.updateLeaderboards();
        HashMap<SkillType, Integer> skills = new HashMap<SkillType, Integer>();
        for (SkillType skill : SkillType.NON_CHILD_SKILLS) {
            skills.put(skill, this.getPlayerRank(playerName, this.playerStatHash.get((Object)skill)));
        }
        skills.put(null, this.getPlayerRank(playerName, this.powerLevels));
        return skills;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newUser(String playerName) {
        BufferedWriter out = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                out = new BufferedWriter(new FileWriter(mcMMO.getUsersFilePath(), true));
                out.append(playerName).append(":");
                out.append("0:");
                out.append(":");
                out.append(":");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append(":");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append(":");
                out.append("0:");
                out.append("0:");
                out.append("0:");
                out.append(String.valueOf(System.currentTimeMillis() / 1000L)).append(":");
                out.append(Config.getInstance().getMobHealthbarDefault().toString()).append(":");
                out.append("0:");
                out.append("0:");
                out.newLine();
                this.tryClose(out);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.tryClose(out);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PlayerProfile loadPlayerProfile(String playerName, boolean create) {
        BufferedReader in = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    if (!character[0].equalsIgnoreCase(playerName)) continue;
                    PlayerProfile playerProfile = this.loadFromLine(character);
                    return playerProfile;
                }
                if (!create) return new PlayerProfile(playerName);
                this.newUser(playerName);
                PlayerProfile playerProfile = new PlayerProfile(playerName, true);
                return playerProfile;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return new PlayerProfile(playerName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void convertUsers(DatabaseManager destination) {
        BufferedReader in = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        int convertedUsers = 0;
        long startMillis = System.currentTimeMillis();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    try {
                        destination.saveUser(this.loadFromLine(character));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Misc.printProgress(++convertedUsers, 200, startMillis);
                }
                this.tryClose(in);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    this.tryClose(in);
                }
                catch (Throwable throwable) {
                    this.tryClose(in);
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoredUsers() {
        ArrayList<String> users = new ArrayList<String>();
        BufferedReader in = null;
        String usersFilePath = mcMMO.getUsersFilePath();
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                while ((line = in.readLine()) != null) {
                    String[] character = line.split(":");
                    users.add(character[0]);
                }
                this.tryClose(in);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    this.tryClose(in);
                }
                catch (Throwable throwable) {
                    this.tryClose(in);
                    throw throwable;
                }
            }
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLeaderboards() {
        if (System.currentTimeMillis() < this.lastUpdate + 600000L) {
            return;
        }
        String usersFilePath = mcMMO.getUsersFilePath();
        this.lastUpdate = System.currentTimeMillis();
        this.powerLevels.clear();
        ArrayList<PlayerStat> mining = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> woodcutting = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> herbalism = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> excavation = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> acrobatics = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> repair = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> swords = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> axes = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> archery = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> unarmed = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> taming = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> fishing = new ArrayList<PlayerStat>();
        ArrayList<PlayerStat> alchemy = new ArrayList<PlayerStat>();
        BufferedReader in = null;
        String playerName = null;
        Object object = fileWritingLock;
        synchronized (object) {
            try {
                String line;
                in = new BufferedReader(new FileReader(usersFilePath));
                while ((line = in.readLine()) != null) {
                    String[] data = line.split(":");
                    playerName = data[0];
                    int powerLevel = 0;
                    Map<SkillType, Integer> skills = this.getSkillMapFromLine(data);
                    powerLevel += this.putStat(acrobatics, playerName, skills.get((Object)SkillType.ACROBATICS));
                    powerLevel += this.putStat(alchemy, playerName, skills.get((Object)SkillType.ALCHEMY));
                    powerLevel += this.putStat(archery, playerName, skills.get((Object)SkillType.ARCHERY));
                    powerLevel += this.putStat(axes, playerName, skills.get((Object)SkillType.AXES));
                    powerLevel += this.putStat(excavation, playerName, skills.get((Object)SkillType.EXCAVATION));
                    powerLevel += this.putStat(fishing, playerName, skills.get((Object)SkillType.FISHING));
                    powerLevel += this.putStat(herbalism, playerName, skills.get((Object)SkillType.HERBALISM));
                    powerLevel += this.putStat(mining, playerName, skills.get((Object)SkillType.MINING));
                    powerLevel += this.putStat(repair, playerName, skills.get((Object)SkillType.REPAIR));
                    powerLevel += this.putStat(swords, playerName, skills.get((Object)SkillType.SWORDS));
                    powerLevel += this.putStat(taming, playerName, skills.get((Object)SkillType.TAMING));
                    powerLevel += this.putStat(unarmed, playerName, skills.get((Object)SkillType.UNARMED));
                    this.putStat(this.powerLevels, playerName, powerLevel += this.putStat(woodcutting, playerName, skills.get((Object)SkillType.WOODCUTTING)));
                }
                this.tryClose(in);
            }
            catch (Exception e) {
                try {
                    mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " during user " + playerName + " (Are you sure you formatted it correctly?) " + e.toString());
                    this.tryClose(in);
                }
                catch (Throwable throwable) {
                    this.tryClose(in);
                    throw throwable;
                }
            }
        }
        SkillComparator c = new SkillComparator();
        Collections.sort(mining, c);
        Collections.sort(woodcutting, c);
        Collections.sort(repair, c);
        Collections.sort(unarmed, c);
        Collections.sort(herbalism, c);
        Collections.sort(excavation, c);
        Collections.sort(archery, c);
        Collections.sort(swords, c);
        Collections.sort(axes, c);
        Collections.sort(acrobatics, c);
        Collections.sort(taming, c);
        Collections.sort(fishing, c);
        Collections.sort(alchemy, c);
        Collections.sort(this.powerLevels, c);
        this.playerStatHash.put(SkillType.MINING, mining);
        this.playerStatHash.put(SkillType.WOODCUTTING, woodcutting);
        this.playerStatHash.put(SkillType.REPAIR, repair);
        this.playerStatHash.put(SkillType.UNARMED, unarmed);
        this.playerStatHash.put(SkillType.HERBALISM, herbalism);
        this.playerStatHash.put(SkillType.EXCAVATION, excavation);
        this.playerStatHash.put(SkillType.ARCHERY, archery);
        this.playerStatHash.put(SkillType.SWORDS, swords);
        this.playerStatHash.put(SkillType.AXES, axes);
        this.playerStatHash.put(SkillType.ACROBATICS, acrobatics);
        this.playerStatHash.put(SkillType.TAMING, taming);
        this.playerStatHash.put(SkillType.FISHING, fishing);
        this.playerStatHash.put(SkillType.ALCHEMY, alchemy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStructure() {
        if (this.usersFile.exists()) {
            BufferedReader in = null;
            FileWriter out = null;
            String usersFilePath = mcMMO.getUsersFilePath();
            Object object = fileWritingLock;
            synchronized (object) {
                try {
                    String line;
                    in = new BufferedReader(new FileReader(usersFilePath));
                    StringBuilder writer = new StringBuilder();
                    HashSet<String> players = new HashSet<String>();
                    while ((line = in.readLine()) != null) {
                        String[] character;
                        if (line.isEmpty()) continue;
                        if (line.charAt(line.length() - 1) != ':') {
                            line = line.concat(":");
                        }
                        if (!players.add((character = line.split(":"))[0])) continue;
                        if (character.length < 33) {
                            mcMMO.p.getLogger().warning("Dropping malformed or before version 1.0 line from database - " + line);
                            continue;
                        }
                        String oldVersion = null;
                        if (character.length <= 33) {
                            line = line.concat(" :");
                            character = line.split(":");
                            oldVersion = "1.1.06";
                        }
                        if (!character[33].isEmpty()) {
                            line = line.replace(character[33], "");
                            if (oldVersion == null) {
                                oldVersion = "1.4.07";
                            }
                        }
                        if (character.length == 41) {
                            writer.append(line).append("\r\n");
                            continue;
                        }
                        StringBuilder newLine = new StringBuilder(line);
                        if (character.length <= 35) {
                            newLine.append(0).append(":");
                            newLine.append(0).append(":");
                            if (oldVersion == null) {
                                oldVersion = "1.2.00";
                            }
                        }
                        if (character.length <= 36) {
                            newLine.append(0).append(":");
                            if (oldVersion == null) {
                                oldVersion = "1.3.00";
                            }
                        }
                        if (character.length <= 37) {
                            newLine.append("0").append(":");
                            if (oldVersion == null) {
                                oldVersion = "1.4.00";
                            }
                        }
                        if (character.length <= 38) {
                            newLine.append(Config.getInstance().getMobHealthbarDefault().toString()).append(":");
                            if (oldVersion == null) {
                                oldVersion = "1.4.06";
                            }
                        }
                        if (character.length <= 39) {
                            newLine.append("0").append(":");
                            newLine.append("0").append(":");
                            if (oldVersion == null) {
                                oldVersion = "1.4.08";
                            }
                        }
                        Object[] newCharacter = newLine.toString().split(":");
                        boolean corrupted = false;
                        for (int i = 0; i < newCharacter.length; ++i) {
                            if (newCharacter[i].isEmpty() && i != 2 && i != 3 && i != 23 && i != 33) {
                                corrupted = true;
                                if (newCharacter.length != 41) {
                                    newCharacter = (String[])ArrayUtils.remove((Object[])newCharacter, (int)i);
                                } else {
                                    newCharacter[i] = i == 37 ? String.valueOf(System.currentTimeMillis() / 1000L) : (i == 38 ? Config.getInstance().getMobHealthbarDefault().toString() : "0");
                                }
                            }
                            if (com.gmail.nossr50.util.StringUtils.isInt(newCharacter[i]) && i == 38) {
                                corrupted = true;
                                newCharacter[i] = Config.getInstance().getMobHealthbarDefault().toString();
                            }
                            if (com.gmail.nossr50.util.StringUtils.isInt(newCharacter[i]) || i == 0 || i == 2 || i == 3 || i == 23 || i == 33 || i == 38) continue;
                            corrupted = true;
                            newCharacter[i] = "0";
                        }
                        if (corrupted) {
                            mcMMO.p.debug("Updating corrupted database line for player " + newCharacter[0]);
                            newLine = new StringBuilder(StringUtils.join((Object[])newCharacter, (String)":"));
                        }
                        if (oldVersion != null) {
                            mcMMO.p.debug("Updating database line for player " + character[0] + " from before version " + oldVersion);
                        }
                        writer.append((CharSequence)newLine).append("\r\n");
                    }
                    out = new FileWriter(usersFilePath);
                    out.write(writer.toString());
                    this.tryClose(in);
                    this.tryClose(out);
                }
                catch (IOException e) {
                    try {
                        mcMMO.p.getLogger().severe("Exception while reading " + usersFilePath + " (Are you sure you formatted it correctly?)" + e.toString());
                        this.tryClose(in);
                        this.tryClose(out);
                    }
                    catch (Throwable throwable) {
                        this.tryClose(in);
                        this.tryClose(out);
                        throw throwable;
                    }
                }
            }
            return;
        }
        this.usersFile.getParentFile().mkdir();
        try {
            mcMMO.p.debug("Creating mcmmo.users file...");
            new File(mcMMO.getUsersFilePath()).createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void tryClose(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Integer getPlayerRank(String playerName, List<PlayerStat> statsList) {
        if (statsList == null) {
            return null;
        }
        int currentPos = 1;
        for (PlayerStat stat : statsList) {
            if (stat.name.equalsIgnoreCase(playerName)) {
                return currentPos;
            }
            ++currentPos;
        }
        return null;
    }

    private int putStat(List<PlayerStat> statList, String playerName, int statValue) {
        statList.add(new PlayerStat(playerName, statValue));
        return statValue;
    }

    private PlayerProfile loadFromLine(String[] character) {
        MobHealthbarType mobHealthbarType;
        Map<SkillType, Integer> skills = this.getSkillMapFromLine(character);
        HashMap<SkillType, Float> skillsXp = new HashMap<SkillType, Float>();
        HashMap<AbilityType, Integer> skillsDATS = new HashMap<AbilityType, Integer>();
        skillsXp.put(SkillType.TAMING, Float.valueOf(Integer.valueOf(character[25]).intValue()));
        skillsXp.put(SkillType.MINING, Float.valueOf(Integer.valueOf(character[4]).intValue()));
        skillsXp.put(SkillType.REPAIR, Float.valueOf(Integer.valueOf(character[15]).intValue()));
        skillsXp.put(SkillType.WOODCUTTING, Float.valueOf(Integer.valueOf(character[6]).intValue()));
        skillsXp.put(SkillType.UNARMED, Float.valueOf(Integer.valueOf(character[16]).intValue()));
        skillsXp.put(SkillType.HERBALISM, Float.valueOf(Integer.valueOf(character[17]).intValue()));
        skillsXp.put(SkillType.EXCAVATION, Float.valueOf(Integer.valueOf(character[18]).intValue()));
        skillsXp.put(SkillType.ARCHERY, Float.valueOf(Integer.valueOf(character[19]).intValue()));
        skillsXp.put(SkillType.SWORDS, Float.valueOf(Integer.valueOf(character[20]).intValue()));
        skillsXp.put(SkillType.AXES, Float.valueOf(Integer.valueOf(character[21]).intValue()));
        skillsXp.put(SkillType.ACROBATICS, Float.valueOf(Integer.valueOf(character[22]).intValue()));
        skillsXp.put(SkillType.FISHING, Float.valueOf(Integer.valueOf(character[35]).intValue()));
        skillsXp.put(SkillType.ALCHEMY, Float.valueOf(Integer.valueOf(character[40]).intValue()));
        skillsDATS.put(AbilityType.SUPER_BREAKER, Integer.valueOf(character[32]));
        skillsDATS.put(AbilityType.TREE_FELLER, Integer.valueOf(character[28]));
        skillsDATS.put(AbilityType.BERSERK, Integer.valueOf(character[26]));
        skillsDATS.put(AbilityType.GREEN_TERRA, Integer.valueOf(character[29]));
        skillsDATS.put(AbilityType.GIGA_DRILL_BREAKER, Integer.valueOf(character[27]));
        skillsDATS.put(AbilityType.SERRATED_STRIKES, Integer.valueOf(character[30]));
        skillsDATS.put(AbilityType.SKULL_SPLITTER, Integer.valueOf(character[31]));
        skillsDATS.put(AbilityType.BLAST_MINING, Integer.valueOf(character[36]));
        try {
            mobHealthbarType = MobHealthbarType.valueOf(character[38]);
        }
        catch (Exception e) {
            mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        }
        return new PlayerProfile(character[0], skills, skillsXp, skillsDATS, mobHealthbarType);
    }

    private Map<SkillType, Integer> getSkillMapFromLine(String[] character) {
        HashMap<SkillType, Integer> skills = new HashMap<SkillType, Integer>();
        skills.put(SkillType.TAMING, Integer.valueOf(character[24]));
        skills.put(SkillType.MINING, Integer.valueOf(character[1]));
        skills.put(SkillType.REPAIR, Integer.valueOf(character[7]));
        skills.put(SkillType.WOODCUTTING, Integer.valueOf(character[5]));
        skills.put(SkillType.UNARMED, Integer.valueOf(character[8]));
        skills.put(SkillType.HERBALISM, Integer.valueOf(character[9]));
        skills.put(SkillType.EXCAVATION, Integer.valueOf(character[10]));
        skills.put(SkillType.ARCHERY, Integer.valueOf(character[11]));
        skills.put(SkillType.SWORDS, Integer.valueOf(character[12]));
        skills.put(SkillType.AXES, Integer.valueOf(character[13]));
        skills.put(SkillType.ACROBATICS, Integer.valueOf(character[14]));
        skills.put(SkillType.FISHING, Integer.valueOf(character[34]));
        skills.put(SkillType.ALCHEMY, Integer.valueOf(character[39]));
        return skills;
    }

    @Override
    public DatabaseType getDatabaseType() {
        return DatabaseType.FLATFILE;
    }

    private class SkillComparator
    implements Comparator<PlayerStat> {
        private SkillComparator() {
        }

        @Override
        public int compare(PlayerStat o1, PlayerStat o2) {
            return o2.statVal - o1.statVal;
        }
    }
}

