/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.party;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.party.ItemShareType;
import com.gmail.nossr50.datatypes.party.ShareMode;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.util.EventUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Party {
    private final LinkedHashSet<String> members = new LinkedHashSet();
    private String leader;
    private String name;
    private String password;
    private boolean locked;
    private Party ally;
    private int level;
    private float xp;
    private ShareMode xpShareMode = ShareMode.NONE;
    private ShareMode itemShareMode = ShareMode.NONE;
    private boolean shareLootDrops = true;
    private boolean shareMiningDrops = true;
    private boolean shareHerbalismDrops = true;
    private boolean shareWoodcuttingDrops = true;
    private boolean shareMiscDrops = true;

    public Party(String name) {
        this.name = name;
    }

    public Party(String leader, String name) {
        this.leader = leader;
        this.name = name;
        this.locked = true;
        this.level = 0;
    }

    public Party(String leader, String name, String password) {
        this.leader = leader;
        this.name = name;
        this.password = password;
        this.locked = true;
        this.level = 0;
    }

    public Party(String leader, String name, String password, boolean locked) {
        this.leader = leader;
        this.name = name;
        this.password = password;
        this.locked = locked;
        this.level = 0;
    }

    public LinkedHashSet<String> getMembers() {
        return this.members;
    }

    public List<Player> getOnlineMembers() {
        ArrayList<Player> onlineMembers = new ArrayList<Player>();
        for (String memberName : this.members) {
            Player member = mcMMO.p.getServer().getPlayerExact(memberName);
            if (member == null) continue;
            onlineMembers.add(member);
        }
        return onlineMembers;
    }

    public List<String> getOnlinePlayerNames(CommandSender sender) {
        Player player = sender instanceof Player ? (Player)sender : null;
        ArrayList<String> onlinePlayerNames = new ArrayList<String>();
        for (Player onlinePlayer : this.getOnlineMembers()) {
            if (player == null || !player.canSee(onlinePlayer)) continue;
            onlinePlayerNames.add(onlinePlayer.getName());
        }
        return onlinePlayerNames;
    }

    public String getName() {
        return this.name;
    }

    public String getLeader() {
        return this.leader;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public Party getAlly() {
        return this.ally;
    }

    public List<String> getItemShareCategories() {
        ArrayList<String> shareCategories = new ArrayList<String>();
        for (ItemShareType shareType : ItemShareType.values()) {
            if (!this.sharingDrops(shareType)) continue;
            shareCategories.add(shareType.getLocaleString());
        }
        return shareCategories;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLeader(String leader) {
        this.leader = leader;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setAlly(Party ally) {
        this.ally = ally;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public float getXp() {
        return this.xp;
    }

    public void setXp(float xp) {
        this.xp = xp;
    }

    public void addXp(float xp) {
        this.setXp(this.getXp() + xp);
    }

    protected float levelUp() {
        float xpRemoved = this.getXpToLevel();
        this.setLevel(this.getLevel() + 1);
        this.setXp(this.getXp() - xpRemoved);
        return xpRemoved;
    }

    public int getXpToLevel() {
        FormulaType formulaType = ExperienceConfig.getInstance().getFormulaType();
        return mcMMO.getFormulaManager().getCachedXpToLevel(this.level, formulaType) * (this.getOnlineMembers().size() + Config.getInstance().getPartyXpCurveMultiplier());
    }

    public String getXpToLevelPercentage() {
        DecimalFormat percent = new DecimalFormat("##0.00%");
        return percent.format(this.getXp() / (float)this.getXpToLevel());
    }

    public void applyXpGain(float xp) {
        if (!EventUtils.handlePartyXpGainEvent(this, xp)) {
            return;
        }
        if (this.getXp() < (float)this.getXpToLevel()) {
            return;
        }
        int levelsGained = 0;
        float xpRemoved = 0.0f;
        while (this.getXp() >= (float)this.getXpToLevel()) {
            if (this.hasReachedLevelCap()) {
                this.setXp(0.0f);
                return;
            }
            xpRemoved += this.levelUp();
            ++levelsGained;
        }
        if (!EventUtils.handlePartyLevelChangeEvent(this, levelsGained, xpRemoved)) {
            return;
        }
        if (!Config.getInstance().getPartyInformAllMembers()) {
            Player leader = mcMMO.p.getServer().getPlayer(this.leader);
            if (leader != null) {
                leader.sendMessage(LocaleLoader.getString("Party.LevelUp", levelsGained, this.getLevel()));
                if (Config.getInstance().getLevelUpSoundsEnabled()) {
                    leader.playSound(leader.getLocation(), Sound.LEVEL_UP, 0.75f, 0.5f);
                }
            }
            return;
        }
        PartyManager.informPartyMembersLevelUp(this, levelsGained, this.getLevel());
    }

    public boolean hasReachedLevelCap() {
        return Config.getInstance().getPartyLevelCap() < this.getLevel() + 1;
    }

    public void setXpShareMode(ShareMode xpShareMode) {
        this.xpShareMode = xpShareMode;
    }

    public ShareMode getXpShareMode() {
        return this.xpShareMode;
    }

    public void setItemShareMode(ShareMode itemShareMode) {
        this.itemShareMode = itemShareMode;
    }

    public ShareMode getItemShareMode() {
        return this.itemShareMode;
    }

    public boolean sharingDrops(ItemShareType shareType) {
        switch (shareType) {
            case HERBALISM: {
                return this.shareHerbalismDrops;
            }
            case LOOT: {
                return this.shareLootDrops;
            }
            case MINING: {
                return this.shareMiningDrops;
            }
            case MISC: {
                return this.shareMiscDrops;
            }
            case WOODCUTTING: {
                return this.shareWoodcuttingDrops;
            }
        }
        return false;
    }

    public void setSharingDrops(ItemShareType shareType, boolean enabled) {
        switch (shareType) {
            case HERBALISM: {
                this.shareHerbalismDrops = enabled;
                break;
            }
            case LOOT: {
                this.shareLootDrops = enabled;
                break;
            }
            case MINING: {
                this.shareMiningDrops = enabled;
                break;
            }
            case MISC: {
                this.shareMiscDrops = enabled;
                break;
            }
            case WOODCUTTING: {
                this.shareWoodcuttingDrops = enabled;
                break;
            }
            default: {
                return;
            }
        }
    }

    public String createMembersList(String playerName, List<Player> nearMembers) {
        StringBuilder memberList = new StringBuilder();
        for (String memberName : this.getMembers()) {
            Player member = mcMMO.p.getServer().getPlayerExact(memberName);
            if (this.getLeader().equalsIgnoreCase(memberName)) {
                memberList.append(ChatColor.GOLD);
                if (member == null) {
                    memberName = memberName.substring(0, 1) + ChatColor.GRAY + ChatColor.ITALIC + "" + memberName.substring(1);
                }
            } else if (member != null) {
                memberList.append(ChatColor.WHITE);
            } else {
                memberList.append(ChatColor.GRAY);
            }
            if (!nearMembers.contains(member) && !playerName.equalsIgnoreCase(memberName)) {
                memberList.append(ChatColor.ITALIC).append("");
            }
            memberList.append(memberName).append(ChatColor.RESET).append(" ");
        }
        return memberList.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Party)) {
            return false;
        }
        Party other = (Party)obj;
        if (this.getName() == null || other.getName() == null) {
            return false;
        }
        return this.getName().equals(other.getName());
    }
}

