/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.player;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.MobHealthbarType;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.player.UserManager;
import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PlayerProfile {
    private final String playerName;
    private boolean loaded;
    private boolean changed;
    private MobHealthbarType mobHealthbarType;
    private final Map<SkillType, Integer> skills = new HashMap<SkillType, Integer>();
    private final Map<SkillType, Float> skillsXp = new HashMap<SkillType, Float>();
    private final Map<AbilityType, Integer> abilityDATS = new HashMap<AbilityType, Integer>();

    public PlayerProfile(String playerName) {
        this.playerName = playerName;
        this.mobHealthbarType = Config.getInstance().getMobHealthbarDefault();
        for (AbilityType abilityType : AbilityType.values()) {
            this.abilityDATS.put(abilityType, 0);
        }
        for (SkillType skillType : SkillType.NON_CHILD_SKILLS) {
            this.skills.put(skillType, 0);
            this.skillsXp.put(skillType, Float.valueOf(0.0f));
        }
    }

    public PlayerProfile(String playerName, boolean isLoaded) {
        this(playerName);
        this.loaded = isLoaded;
    }

    public PlayerProfile(String playerName, Map<SkillType, Integer> levelData, Map<SkillType, Float> xpData, Map<AbilityType, Integer> cooldownData, MobHealthbarType mobHealthbarType) {
        this.playerName = playerName;
        this.mobHealthbarType = mobHealthbarType;
        this.skills.putAll(levelData);
        this.skillsXp.putAll(xpData);
        this.abilityDATS.putAll(cooldownData);
        this.loaded = true;
    }

    public void save() {
        if (!this.changed || !this.loaded) {
            return;
        }
        boolean bl = this.changed = !mcMMO.getDatabaseManager().saveUser(new PlayerProfile(this.playerName, (Map<SkillType, Integer>)ImmutableMap.copyOf(this.skills), (Map<SkillType, Float>)ImmutableMap.copyOf(this.skillsXp), (Map<AbilityType, Integer>)ImmutableMap.copyOf(this.abilityDATS), this.mobHealthbarType));
        if (this.changed) {
            mcMMO.p.getLogger().warning("PlayerProfile for " + this.playerName + " failed to save");
        }
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public MobHealthbarType getMobHealthbarType() {
        return this.mobHealthbarType;
    }

    public void setMobHealthbarType(MobHealthbarType mobHealthbarType) {
        this.mobHealthbarType = mobHealthbarType;
    }

    public long getAbilityDATS(AbilityType ability) {
        return this.abilityDATS.get((Object)ability).intValue();
    }

    protected void setAbilityDATS(AbilityType ability, long DATS) {
        this.changed = true;
        this.abilityDATS.put(ability, (int)((double)DATS * 0.001));
    }

    protected void resetCooldowns() {
        this.changed = true;
        for (AbilityType ability : this.abilityDATS.keySet()) {
            this.abilityDATS.put(ability, 0);
        }
    }

    public int getSkillLevel(SkillType skill) {
        return skill.isChildSkill() ? this.getChildSkillLevel(skill) : this.skills.get((Object)skill).intValue();
    }

    public float getSkillXpLevelRaw(SkillType skill) {
        return this.skillsXp.get((Object)skill).floatValue();
    }

    public int getSkillXpLevel(SkillType skill) {
        return (int)Math.floor(this.getSkillXpLevelRaw(skill));
    }

    public void setSkillXpLevel(SkillType skill, float xpLevel) {
        if (skill.isChildSkill()) {
            return;
        }
        this.changed = true;
        this.skillsXp.put(skill, Float.valueOf(xpLevel));
    }

    protected float levelUp(SkillType skill) {
        float xpRemoved = this.getXpToLevel(skill);
        this.changed = true;
        this.skills.put(skill, this.skills.get((Object)skill) + 1);
        this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() - xpRemoved));
        return xpRemoved;
    }

    public void removeXp(SkillType skill, int xp) {
        if (skill.isChildSkill()) {
            return;
        }
        this.changed = true;
        this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() - (float)xp));
    }

    public void modifySkill(SkillType skill, int level) {
        if (skill.isChildSkill()) {
            return;
        }
        this.changed = true;
        this.skills.put(skill, level);
        this.skillsXp.put(skill, Float.valueOf(0.0f));
    }

    public void addLevels(SkillType skill, int levels) {
        this.modifySkill(skill, this.skills.get((Object)skill) + levels);
    }

    public void addXp(SkillType skill, float xp) {
        this.changed = true;
        if (skill.isChildSkill()) {
            Set<SkillType> parentSkills = FamilyTree.getParents(skill);
            float dividedXP = xp / (float)parentSkills.size();
            for (SkillType parentSkill : parentSkills) {
                this.skillsXp.put(parentSkill, Float.valueOf(this.skillsXp.get((Object)parentSkill).floatValue() + dividedXP));
            }
        } else {
            this.skillsXp.put(skill, Float.valueOf(this.skillsXp.get((Object)skill).floatValue() + xp));
        }
    }

    public int getXpToLevel(SkillType skillType) {
        int level = ExperienceConfig.getInstance().getCumulativeCurveEnabled() ? UserManager.getPlayer(this.playerName).getPowerLevel() : this.skills.get((Object)skillType).intValue();
        FormulaType formulaType = ExperienceConfig.getInstance().getFormulaType();
        return mcMMO.getFormulaManager().getCachedXpToLevel(level, formulaType);
    }

    private int getChildSkillLevel(SkillType skillType) {
        Set<SkillType> parents = FamilyTree.getParents(skillType);
        int sum = 0;
        for (SkillType parent : parents) {
            sum += Math.min(this.getSkillLevel(parent), 1000);
        }
        return sum / parents.size();
    }
}

