/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.datatypes.skills;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.alchemy.AlchemyManager;
import com.gmail.nossr50.skills.archery.ArcheryManager;
import com.gmail.nossr50.skills.axes.AxesManager;
import com.gmail.nossr50.skills.excavation.ExcavationManager;
import com.gmail.nossr50.skills.fishing.FishingManager;
import com.gmail.nossr50.skills.herbalism.HerbalismManager;
import com.gmail.nossr50.skills.mining.MiningManager;
import com.gmail.nossr50.skills.repair.RepairManager;
import com.gmail.nossr50.skills.smelting.SmeltingManager;
import com.gmail.nossr50.skills.swords.SwordsManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.skills.woodcutting.WoodcuttingManager;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.Color;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.permissions.Permissible;

public enum SkillType {
    ACROBATICS(AcrobaticsManager.class, Color.WHITE, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.DODGE), (Object)((Object)SecondaryAbility.GRACEFUL_ROLL), (Object)((Object)SecondaryAbility.ROLL))),
    ALCHEMY(AlchemyManager.class, Color.FUCHSIA, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.CATALYSIS), (Object)((Object)SecondaryAbility.CONCOCTIONS))),
    ARCHERY(ArcheryManager.class, Color.MAROON, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.DAZE), (Object)((Object)SecondaryAbility.RETRIEVE), (Object)((Object)SecondaryAbility.SKILL_SHOT))),
    AXES(AxesManager.class, Color.AQUA, AbilityType.SKULL_SPLITTER, ToolType.AXE, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.ARMOR_IMPACT), (Object)((Object)SecondaryAbility.AXE_MASTERY), (Object)((Object)SecondaryAbility.CRITICAL_HIT), (Object)((Object)SecondaryAbility.GREATER_IMPACT))),
    EXCAVATION(ExcavationManager.class, Color.fromRGB((int)139, (int)69, (int)19), AbilityType.GIGA_DRILL_BREAKER, ToolType.SHOVEL, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.EXCAVATION_TREASURE_HUNTER))),
    FISHING(FishingManager.class, Color.NAVY, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.FISHERMANS_DIET), (Object)((Object)SecondaryAbility.FISHING_TREASURE_HUNTER), (Object)((Object)SecondaryAbility.ICE_FISHING), (Object)((Object)SecondaryAbility.MAGIC_HUNTER), (Object)((Object)SecondaryAbility.MASTER_ANGLER), (Object)((Object)SecondaryAbility.SHAKE))),
    HERBALISM(HerbalismManager.class, Color.GREEN, AbilityType.GREEN_TERRA, ToolType.HOE, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.FARMERS_DIET), (Object)((Object)SecondaryAbility.GREEN_THUMB_PLANT), (Object)((Object)SecondaryAbility.GREEN_THUMB_BLOCK), (Object)((Object)SecondaryAbility.HERBALISM_DOUBLE_DROPS), (Object)((Object)SecondaryAbility.HYLIAN_LUCK), (Object)((Object)SecondaryAbility.SHROOM_THUMB))),
    MINING(MiningManager.class, Color.GRAY, AbilityType.SUPER_BREAKER, ToolType.PICKAXE, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.MINING_DOUBLE_DROPS))),
    REPAIR(RepairManager.class, Color.SILVER, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.ARCANE_FORGING), (Object)((Object)SecondaryAbility.REPAIR_MASTERY), (Object)((Object)SecondaryAbility.SALVAGE), (Object)((Object)SecondaryAbility.SUPER_REPAIR))),
    SMELTING(SmeltingManager.class, Color.YELLOW, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.FLUX_MINING), (Object)((Object)SecondaryAbility.FUEL_EFFICIENCY), (Object)((Object)SecondaryAbility.SECOND_SMELT))),
    SWORDS(SwordsManager.class, Color.fromRGB((int)178, (int)34, (int)34), AbilityType.SERRATED_STRIKES, ToolType.SWORD, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.BLEED), (Object)((Object)SecondaryAbility.COUNTER))),
    TAMING(TamingManager.class, Color.PURPLE, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.BEAST_LORE), (Object)((Object)SecondaryAbility.CALL_OF_THE_WILD), (Object)((Object)SecondaryAbility.ENVIROMENTALLY_AWARE), (Object)((Object)SecondaryAbility.FAST_FOOD), (Object)((Object)SecondaryAbility.GORE), (Object)((Object)SecondaryAbility.HOLY_HOUND), (Object)((Object)SecondaryAbility.SHARPENED_CLAWS), (Object)((Object)SecondaryAbility.SHOCK_PROOF), (Object)((Object)SecondaryAbility.THICK_FUR))),
    UNARMED(UnarmedManager.class, Color.BLACK, AbilityType.BERSERK, ToolType.FISTS, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.BLOCK_CRACKER), (Object)((Object)SecondaryAbility.DEFLECT), (Object)((Object)SecondaryAbility.DISARM), (Object)((Object)SecondaryAbility.IRON_ARM), (Object)((Object)SecondaryAbility.IRON_GRIP))),
    WOODCUTTING(WoodcuttingManager.class, Color.OLIVE, AbilityType.TREE_FELLER, ToolType.AXE, (List<SecondaryAbility>)ImmutableList.of((Object)((Object)SecondaryAbility.LEAF_BLOWER), (Object)((Object)SecondaryAbility.WOODCUTTING_DOUBLE_DROPS)));

    private Class<? extends SkillManager> managerClass;
    private Color runescapeColor;
    private AbilityType ability;
    private ToolType tool;
    private List<SecondaryAbility> secondaryAbilities;
    public static final List<String> SKILL_NAMES;
    public static final List<SkillType> CHILD_SKILLS;
    public static final List<SkillType> NON_CHILD_SKILLS;
    public static final List<SkillType> COMBAT_SKILLS;
    public static final List<SkillType> GATHERING_SKILLS;
    public static final List<SkillType> MISC_SKILLS;

    private SkillType(Class<? extends SkillManager> managerClass, Color runescapeColor, List<SecondaryAbility> secondaryAbilities) {
        this(managerClass, runescapeColor, null, null, secondaryAbilities);
    }

    private SkillType(Class<? extends SkillManager> managerClass, Color runescapeColor, AbilityType ability, ToolType tool, List<SecondaryAbility> secondaryAbilities) {
        this.managerClass = managerClass;
        this.runescapeColor = runescapeColor;
        this.ability = ability;
        this.tool = tool;
        this.secondaryAbilities = secondaryAbilities;
    }

    public Class<? extends SkillManager> getManagerClass() {
        return this.managerClass;
    }

    public AbilityType getAbility() {
        return this.ability;
    }

    public int getMaxLevel() {
        return Config.getInstance().getLevelCap(this);
    }

    public boolean getPVPEnabled() {
        return Config.getInstance().getPVPEnabled(this);
    }

    public boolean getPVEEnabled() {
        return Config.getInstance().getPVEEnabled(this);
    }

    public boolean getDoubleDropsDisabled() {
        return Config.getInstance().getDoubleDropsDisabled(this);
    }

    public boolean getHardcoreStatLossEnabled() {
        return Config.getInstance().getHardcoreStatLossEnabled(this);
    }

    public void setHardcoreStatLossEnabled(boolean enable) {
        Config.getInstance().setHardcoreStatLossEnabled(this, enable);
    }

    public boolean getHardcoreVampirismEnabled() {
        return Config.getInstance().getHardcoreVampirismEnabled(this);
    }

    public void setHardcoreVampirismEnabled(boolean enable) {
        Config.getInstance().setHardcoreVampirismEnabled(this, enable);
    }

    public ToolType getTool() {
        return this.tool;
    }

    public List<SecondaryAbility> getSkillAbilities() {
        return this.secondaryAbilities;
    }

    public double getXpModifier() {
        return ExperienceConfig.getInstance().getFormulaSkillModifier(this);
    }

    public static SkillType getSkill(String skillName) {
        if (!Config.getInstance().getLocale().equalsIgnoreCase("en_US")) {
            for (SkillType type : SkillType.values()) {
                if (!skillName.equalsIgnoreCase(LocaleLoader.getString(StringUtils.getCapitalized(type.name()) + ".SkillName"))) continue;
                return type;
            }
        }
        for (SkillType type : SkillType.values()) {
            if (!type.name().equalsIgnoreCase(skillName)) continue;
            return type;
        }
        if (!skillName.equalsIgnoreCase("all")) {
            mcMMO.p.getLogger().warning("Invalid mcMMO skill (" + skillName + ")");
        }
        return null;
    }

    public boolean isChildSkill() {
        switch (this) {
            case SMELTING: {
                return true;
            }
        }
        return false;
    }

    public static SkillType bySecondaryAbility(SecondaryAbility skillAbility) {
        for (SkillType type : SkillType.values()) {
            if (!type.getSkillAbilities().contains((Object)skillAbility)) continue;
            return type;
        }
        return null;
    }

    public static SkillType byAbility(AbilityType ability) {
        for (SkillType type : SkillType.values()) {
            if (type.getAbility() != ability) continue;
            return type;
        }
        return null;
    }

    public String getName() {
        return Config.getInstance().getLocale().equalsIgnoreCase("en_US") ? StringUtils.getCapitalized(this.toString()) : StringUtils.getCapitalized(LocaleLoader.getString(StringUtils.getCapitalized(this.toString()) + ".SkillName"));
    }

    public boolean getPermissions(Player player) {
        return Permissions.skillEnabled((Permissible)player, this);
    }

    public void celebrateLevelUp(Player player) {
        ParticleEffectUtils.fireworkParticleShower(player, this.runescapeColor);
    }

    public boolean shouldProcess(Entity target) {
        return target instanceof Player || target instanceof Tameable && ((Tameable)target).isTamed() ? this.getPVPEnabled() : this.getPVEEnabled();
    }

    static {
        COMBAT_SKILLS = ImmutableList.of((Object)((Object)ARCHERY), (Object)((Object)AXES), (Object)((Object)SWORDS), (Object)((Object)TAMING), (Object)((Object)UNARMED));
        GATHERING_SKILLS = ImmutableList.of((Object)((Object)EXCAVATION), (Object)((Object)FISHING), (Object)((Object)HERBALISM), (Object)((Object)MINING), (Object)((Object)WOODCUTTING));
        MISC_SKILLS = ImmutableList.of((Object)((Object)ACROBATICS), (Object)((Object)ALCHEMY), (Object)((Object)REPAIR), (Object)((Object)SMELTING));
        ArrayList<SkillType> childSkills = new ArrayList<SkillType>();
        ArrayList<SkillType> nonChildSkills = new ArrayList<SkillType>();
        ArrayList<String> names = new ArrayList<String>();
        for (SkillType skill : SkillType.values()) {
            if (skill.isChildSkill()) {
                childSkills.add(skill);
            } else {
                nonChildSkills.add(skill);
            }
            names.add(skill.getName());
        }
        Collections.sort(names);
        SKILL_NAMES = ImmutableList.copyOf(names);
        CHILD_SKILLS = ImmutableList.copyOf(childSkills);
        NON_CHILD_SKILLS = ImmutableList.copyOf(nonChildSkills);
    }
}

