/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats;

import com.avaje.ebean.EbeanServer;
import com.gmail.nossr50.metrics.mcstats.EMetrics;
import com.gmail.nossr50.metrics.mcstats.GraphType;
import com.gmail.nossr50.metrics.mcstats.TrackerType;
import com.gmail.nossr50.metrics.mcstats.graph.DonutGraph;
import com.gmail.nossr50.metrics.mcstats.graph.PieGraph;
import com.gmail.nossr50.metrics.mcstats.tracker.MaxTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.MinTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.RangeTracker;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginBase;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;

public class EMetricsPlugin
extends PluginBase {
    private Plugin plugin;
    private PluginDescriptionFile file = new PluginDescriptionFile("EMetrics", "0.0.4", "com.gmail.nossr50.metrics.mcstats.EMetrics");
    PieGraph<TrackerType> trackersUsed = new PieGraph("Trackers Used");
    PieGraph<GraphType> graphsUsed = new PieGraph("Graphs Used");
    MaxTracker maxPOST = new MaxTracker("POST Time", "Maximum");
    MinTracker minPOST = new MinTracker("POST Time", "Minimum");
    RangeTracker rngPOST = new RangeTracker("POST Time", "Range");
    DonutGraph<Plugin> owningPlugin;

    EMetricsPlugin(Plugin plugin) {
        if (plugin == null) {
            throw new IllegalArgumentException("Plugin cannot be null!");
        }
        this.plugin = plugin;
        this.owningPlugin = new DonutGraph("Plugin");
        this.owningPlugin.addSlice(plugin, plugin.getName(), plugin.getDescription().getVersion());
        for (TrackerType trackerType : TrackerType.values()) {
            this.trackersUsed.addSlice(trackerType, this.capitalFirst(trackerType.name()));
        }
        for (Enum enum_ : GraphType.values()) {
            this.graphsUsed.addSlice((GraphType)enum_, this.capitalFirst(enum_.name()));
        }
    }

    String capitalFirst(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    void setupMetrics(EMetrics metrics) {
        metrics.addGraph(this.trackersUsed);
        metrics.addGraph(this.graphsUsed);
        metrics.addGraph(this.owningPlugin);
        metrics.startMetrics();
    }

    public String getRealPluginName() {
        return this.plugin.getName();
    }

    public File getDataFolder() {
        return this.plugin.getDataFolder();
    }

    public PluginDescriptionFile getDescription() {
        return this.file;
    }

    public FileConfiguration getConfig() {
        return this.plugin.getConfig();
    }

    public InputStream getResource(String filename) {
        return this.plugin.getResource(filename);
    }

    public void saveConfig() {
        this.plugin.saveConfig();
    }

    public void saveDefaultConfig() {
        this.plugin.saveDefaultConfig();
    }

    public void saveResource(String resourcePath, boolean replace) {
        this.plugin.saveResource(resourcePath, replace);
    }

    public void reloadConfig() {
        this.plugin.reloadConfig();
    }

    public PluginLoader getPluginLoader() {
        return this.plugin.getPluginLoader();
    }

    public Server getServer() {
        return this.plugin.getServer();
    }

    public boolean isEnabled() {
        return true;
    }

    public void onDisable() {
    }

    public void onLoad() {
    }

    public void onEnable() {
    }

    public boolean isNaggable() {
        return this.plugin.isNaggable();
    }

    public void setNaggable(boolean canNag) {
        this.plugin.setNaggable(canNag);
    }

    public EbeanServer getDatabase() {
        return this.plugin.getDatabase();
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        return this.plugin.getDefaultWorldGenerator(worldName, id);
    }

    public Logger getLogger() {
        return Logger.getLogger("emetrics.turt2live");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return this.plugin.onTabComplete(sender, command, alias, args);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.plugin.onCommand(sender, command, label, args);
    }
}

