/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats.data;

public class DataEvent
implements Cloneable {
    private DataType type = DataType.UNKNOWN;
    private int valueSent = 0;
    private Exception exception = null;
    private String graphName = null;
    private String trackerName = null;

    public DataEvent(DataType type, String graphName, String trackerName) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        this.type = type;
        this.graphName = graphName;
        this.trackerName = trackerName;
    }

    public DataEvent(DataType type, int sent, String graphName, String trackerName) {
        this(type, graphName, trackerName);
        this.valueSent = sent;
    }

    public DataEvent(DataType type, Exception exception, String graphName, String trackerName) {
        this(type, graphName, trackerName);
        this.exception = exception;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public String getTrackerName() {
        return this.trackerName;
    }

    public boolean hasGraphName() {
        return this.graphName != null;
    }

    public boolean hasTrackerName() {
        return this.trackerName != null;
    }

    public boolean isInformational() {
        return this.type == DataType.FLUSH_DATA || this.type == DataType.RESET_DATA;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public int getValueSent() {
        return this.valueSent;
    }

    public DataType getType() {
        return this.type;
    }

    public DataEvent clone() {
        DataEvent event = new DataEvent(this.type, this.graphName, this.trackerName);
        event.exception = this.exception;
        event.valueSent = this.valueSent;
        return event;
    }

    public static enum DataType {
        SEND_DATA,
        RESET_DATA,
        ERROR,
        FLUSH_DATA,
        UNKNOWN;

    }
}

