/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats.graph;

import com.gmail.nossr50.metrics.mcstats.Metrics;
import com.gmail.nossr50.metrics.mcstats.tracker.BasicTracker;
import com.gmail.nossr50.metrics.mcstats.tracker.Tracker;
import java.util.HashMap;
import java.util.Map;

public class PieGraph<T>
extends Metrics.Graph {
    private Map<T, PieSlice<T>> slices = new HashMap<T, PieSlice<T>>();

    public PieGraph(String name) {
        super(name);
    }

    protected final void updateSlice(Tracker oldTracker, Tracker newTracker, PieSlice<T> slice) {
        if (!this.slices.containsKey(((PieSlice)slice).object)) {
            throw new IllegalArgumentException("Attempted to update an invalid slice");
        }
        this.removePlotter(oldTracker);
        this.addPlotter(newTracker);
    }

    public PieSlice<T> addSlice(T object, String name) {
        if (object == null || name == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        PieSlice<T> slice = new PieSlice<T>(object, name, this);
        this.slices.put(object, slice);
        this.addPlotter(((PieSlice)slice).tracker);
        return slice;
    }

    public void removeSlice(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        PieSlice<T> last = this.slices.remove(object);
        this.removePlotter(((PieSlice)last).tracker);
    }

    public void removeSlice(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        for (T object : this.slices.keySet()) {
            PieSlice<T> slice = this.slices.get(object);
            if (!((PieSlice)slice).name.equalsIgnoreCase(name)) continue;
            PieSlice<T> last = this.slices.remove(object);
            this.removePlotter(((PieSlice)last).tracker);
            return;
        }
    }

    public PieSlice<T> getSlice(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        for (T object : this.slices.keySet()) {
            PieSlice<T> slice = this.slices.get(object);
            if (slice == null) {
                throw new IllegalArgumentException("Null slice found. Did you add the type?");
            }
            if (!((PieSlice)slice).name.equalsIgnoreCase(name)) continue;
            return slice;
        }
        return null;
    }

    public PieSlice<T> getSlice(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        return this.slices.get(object);
    }

    public void increment(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        PieSlice<String> slice = this.getSlice((T)name);
        if (slice == null) {
            throw new IllegalArgumentException("Null slice found. Did you add the type?");
        }
        ((PieSlice)slice).tracker.increment();
    }

    public void increment(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Null arguments are not allowed");
        }
        PieSlice<T> slice = this.getSlice(object);
        if (slice == null) {
            throw new IllegalArgumentException("Null slice found. Did you add the type?");
        }
        ((PieSlice)slice).tracker.increment();
    }

    public static class PieSlice<T> {
        private Tracker tracker;
        private T object;
        private PieGraph<T> pie;
        private String name;

        PieSlice(T object, String name, PieGraph<T> graph) {
            this.tracker = new BasicTracker("", name);
            this.object = object;
            this.pie = graph;
            this.name = name;
        }

        public String getOriginalName() {
            return this.name;
        }

        public void convertTracker(Tracker tracker) {
            if (tracker == null) {
                throw new IllegalArgumentException("Null trackers cannot be converted");
            }
            this.pie.updateSlice(this.tracker, tracker, this);
            tracker.setValue(this.tracker.getValue());
            this.tracker = tracker;
        }

        public void replaceTracker(Tracker tracker) {
            if (tracker == null) {
                throw new IllegalArgumentException("Null trackers cannot be converted");
            }
            this.pie.updateSlice(this.tracker, tracker, this);
            this.tracker = tracker;
        }

        public T getObject() {
            return this.object;
        }
    }
}

