/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.metrics.mcstats.tracker;

import com.gmail.nossr50.metrics.mcstats.tracker.FixedTracker;

public class EnabledTracker
extends FixedTracker {
    private boolean enabled = false;
    private boolean disableOnReset = true;

    public EnabledTracker(String graphName, String valueName) {
        super(graphName, valueName);
    }

    public EnabledTracker(String valueName) {
        super(valueName);
    }

    @Override
    public void increment(int amount) {
        if (!this.enabled) {
            this.enabled = true;
        }
    }

    @Override
    public void increment() {
        if (!this.enabled) {
            this.enabled = true;
        }
    }

    @Override
    public void setValue(int value) {
        if (!this.enabled) {
            this.enabled = true;
        }
    }

    @Override
    public int getValue() {
        return this.enabled ? 1 : 0;
    }

    @Override
    public void reset() {
        if (this.disableOnReset) {
            this.enabled = false;
        }
    }

    public boolean isDisablingOnReset() {
        return this.disableOnReset;
    }

    public void setDisableOnReset(boolean disableOnReset) {
        this.disableOnReset = disableOnReset;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

