/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.backups;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.mcMMO;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.scheduler.BukkitRunnable;

public class CleanBackupsTask
extends BukkitRunnable {
    private static final String BACKUP_DIRECTORY = mcMMO.getMainDirectory() + "backup" + File.separator;
    private static final File BACKUP_DIR = new File(BACKUP_DIRECTORY);

    public void run() {
        ArrayList<Integer> savedDays = new ArrayList<Integer>();
        HashMap savedYearsWeeks = new HashMap();
        ArrayList<File> toDelete = new ArrayList<File>();
        int amountTotal = 0;
        int amountDeleted = 0;
        if (BACKUP_DIR.listFiles() == null) {
            return;
        }
        for (File file : BACKUP_DIR.listFiles()) {
            if (!file.isFile() || file.isDirectory()) continue;
            ++amountTotal;
            String fileName = file.getName();
            Date date = this.getDate(fileName.split("[.]")[0]);
            if (!fileName.contains(".zip") || date == null) {
                mcMMO.p.debug("Could not determine date for file: " + fileName);
                continue;
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int dayOfWeek = cal.get(7);
            int weekOfYear = cal.get(3);
            int year = cal.get(1);
            if (this.isPast24Hours(date) && Config.getInstance().getKeepLast24Hours()) continue;
            if (this.isLastWeek(date) && !savedDays.contains(dayOfWeek) && Config.getInstance().getKeepDailyLastWeek()) {
                savedDays.add(dayOfWeek);
                continue;
            }
            ArrayList<Integer> savedWeeks = (ArrayList<Integer>)savedYearsWeeks.get(year);
            if (savedWeeks == null) {
                savedWeeks = new ArrayList<Integer>();
                savedYearsWeeks.put(year, savedWeeks);
            }
            if (!savedWeeks.contains(weekOfYear) && Config.getInstance().getKeepWeeklyPastMonth()) {
                savedWeeks.add(weekOfYear);
                continue;
            }
            ++amountDeleted;
            toDelete.add(file);
        }
        if (toDelete.isEmpty()) {
            return;
        }
        mcMMO.p.getLogger().info("Cleaned backup files. Deleted " + amountDeleted + " of " + amountTotal + " files.");
        for (File file : toDelete) {
            if (!file.delete()) continue;
            mcMMO.p.debug("Deleted: " + file.getName());
        }
    }

    private boolean isPast24Hours(Date date) {
        Date modifiedDate = new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(24L, TimeUnit.HOURS));
        return date.after(modifiedDate);
    }

    private boolean isLastWeek(Date date) {
        Date modifiedDate = new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(7L, TimeUnit.DAYS));
        return date.after(modifiedDate);
    }

    private Date getDate(String fileName) {
        Date date;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        try {
            date = dateFormat.parse(fileName);
        }
        catch (ParseException e) {
            return null;
        }
        return date;
    }
}

