/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.AbilityCooldownTask;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.skills.ParticleEffectUtils;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AbilityDisableTask
extends BukkitRunnable {
    private McMMOPlayer mcMMOPlayer;
    private AbilityType ability;

    public AbilityDisableTask(McMMOPlayer mcMMOPlayer, AbilityType ability) {
        this.mcMMOPlayer = mcMMOPlayer;
        this.ability = ability;
    }

    public void run() {
        if (!this.mcMMOPlayer.getAbilityMode(this.ability)) {
            return;
        }
        Player player = this.mcMMOPlayer.getPlayer();
        switch (this.ability) {
            case SUPER_BREAKER: 
            case GIGA_DRILL_BREAKER: {
                SkillUtils.handleAbilitySpeedDecrease(player);
            }
            case BERSERK: {
                if (!HiddenConfig.getInstance().resendChunksAfterBlockAbility()) break;
                this.resendChunkRadiusAt(player, 1);
            }
        }
        EventUtils.callAbilityDeactivateEvent(player, this.ability);
        this.mcMMOPlayer.setAbilityMode(this.ability, false);
        this.mcMMOPlayer.setAbilityInformed(this.ability, false);
        ParticleEffectUtils.playAbilityDisabledEffect(player);
        if (this.mcMMOPlayer.useChatNotifications()) {
            player.sendMessage(this.ability.getAbilityOff());
        }
        SkillUtils.sendSkillMessage(player, this.ability.getAbilityPlayerOff(player));
        new AbilityCooldownTask(this.mcMMOPlayer, this.ability).runTaskLaterAsynchronously((Plugin)mcMMO.p, PerksUtils.handleCooldownPerks(player, this.ability.getCooldown()) * 20);
    }

    private void resendChunkRadiusAt(Player player, int radius) {
        Chunk chunk = player.getLocation().getChunk();
        World world = player.getWorld();
        int chunkX = chunk.getX();
        int chunkZ = chunk.getZ();
        for (int x = chunkX - radius; x < chunkX + radius; ++x) {
            for (int z = chunkZ - radius; z < chunkZ + radius; ++z) {
                world.refreshChunk(x, z);
            }
        }
    }
}

