/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.runnables.skills;

import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.events.skills.alchemy.McMMOPlayerBrewEvent;
import com.gmail.nossr50.events.skills.alchemy.McMMOPlayerCatalysisEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.alchemy.Alchemy;
import com.gmail.nossr50.skills.alchemy.AlchemyPotionBrewer;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrewingStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AlchemyBrewTask
extends BukkitRunnable {
    private static double DEFAULT_BREW_SPEED = 1.0;
    private static int DEFAULT_BREW_TICKS = 400;
    private BlockState brewingStand;
    private Location location;
    private double brewSpeed;
    private double brewTimer;
    private Player player;

    public AlchemyBrewTask(BlockState brewingStand, Player player) {
        this.brewingStand = brewingStand;
        this.location = brewingStand.getLocation();
        this.player = player;
        this.brewSpeed = DEFAULT_BREW_SPEED;
        this.brewTimer = DEFAULT_BREW_TICKS;
        if (player != null && !Misc.isNPCEntity((Entity)player) && Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.CATALYSIS)) {
            double catalysis = UserManager.getPlayer(player).getAlchemyManager().calculateBrewSpeed(Permissions.lucky((Permissible)player, SkillType.ALCHEMY));
            McMMOPlayerCatalysisEvent event = new McMMOPlayerCatalysisEvent(player, catalysis);
            mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
            if (!event.isCancelled()) {
                this.brewSpeed = catalysis;
            }
        }
        if (Alchemy.brewingStandMap.containsKey(this.location)) {
            Alchemy.brewingStandMap.get(this.location).cancel();
        }
        Alchemy.brewingStandMap.put(this.location, this);
        this.runTaskTimer((Plugin)mcMMO.p, 1L, 1L);
    }

    public void run() {
        if (this.player == null || !this.player.isValid() || this.brewingStand == null || this.brewingStand.getType() != Material.BREWING_STAND) {
            if (Alchemy.brewingStandMap.containsKey(this.location)) {
                Alchemy.brewingStandMap.remove(this.location);
            }
            this.cancel();
            return;
        }
        this.brewTimer -= this.brewSpeed;
        if (this.brewTimer < Math.max(this.brewSpeed, 2.0)) {
            this.cancel();
            this.finish();
        } else {
            ((BrewingStand)this.brewingStand).setBrewingTime((int)this.brewTimer);
        }
    }

    private void finish() {
        McMMOPlayerBrewEvent event = new McMMOPlayerBrewEvent(this.player, this.brewingStand);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            AlchemyPotionBrewer.finishBrewing(this.brewingStand, this.player, false);
        }
        Alchemy.brewingStandMap.remove(this.location);
    }

    public void finishImmediately() {
        this.cancel();
        AlchemyPotionBrewer.finishBrewing(this.brewingStand, this.player, true);
        Alchemy.brewingStandMap.remove(this.location);
    }

    public void cancelBrew() {
        this.cancel();
        ((BrewingStand)this.brewingStand).setBrewingTime(-1);
        Alchemy.brewingStandMap.remove(this.location);
    }
}

