/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.herbalism;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.config.treasure.TreasureConfig;
import com.gmail.nossr50.datatypes.mods.CustomBlock;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.AbilityType;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.datatypes.skills.ToolType;
import com.gmail.nossr50.datatypes.treasure.HylianTreasure;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.runnables.skills.HerbalismBlockUpdaterTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.herbalism.Herbalism;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.Collection;
import java.util.List;
import org.bukkit.CropState;
import org.bukkit.Material;
import org.bukkit.NetherWartsState;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.material.CocoaPlant;
import org.bukkit.material.Crops;
import org.bukkit.material.NetherWarts;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class HerbalismManager
extends SkillManager {
    public HerbalismManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.HERBALISM);
    }

    public boolean canBlockCheck() {
        return !Config.getInstance().getHerbalismPreventAFK() || !this.getPlayer().isInsideVehicle();
    }

    public boolean canGreenThumbBlock(BlockState blockState) {
        Player player = this.getPlayer();
        return player.getItemInHand().getType() == Material.SEEDS && BlockUtils.canMakeMossy(blockState) && Permissions.greenThumbBlock((Permissible)player, blockState.getType());
    }

    public boolean canUseShroomThumb(BlockState blockState) {
        Player player = this.getPlayer();
        Material itemType = player.getItemInHand().getType();
        return (itemType == Material.RED_MUSHROOM || itemType == Material.BROWN_MUSHROOM) && BlockUtils.canMakeShroomy(blockState) && Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.SHROOM_THUMB);
    }

    public boolean canUseHylianLuck() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.HYLIAN_LUCK);
    }

    public boolean canGreenTerraBlock(BlockState blockState) {
        return this.mcMMOPlayer.getAbilityMode(AbilityType.GREEN_TERRA) && BlockUtils.canMakeMossy(blockState);
    }

    public boolean canActivateAbility() {
        return this.mcMMOPlayer.getToolPreparationMode(ToolType.HOE) && Permissions.greenTerra((Permissible)this.getPlayer());
    }

    public boolean canGreenTerraPlant() {
        return this.mcMMOPlayer.getAbilityMode(AbilityType.GREEN_TERRA);
    }

    public int farmersDiet(int rankChange, int eventFoodLevel) {
        return SkillUtils.handleFoodSkills(this.getPlayer(), this.skill, eventFoodLevel, Herbalism.farmersDietRankLevel1, Herbalism.farmersDietMaxLevel, rankChange);
    }

    public boolean processGreenTerra(BlockState blockState) {
        ItemStack seed;
        Player player = this.getPlayer();
        if (!Permissions.greenThumbBlock((Permissible)player, blockState.getType())) {
            return false;
        }
        PlayerInventory playerInventory = player.getInventory();
        if (!playerInventory.containsAtLeast(seed = new ItemStack(Material.SEEDS), 1)) {
            player.sendMessage(LocaleLoader.getString("Herbalism.Ability.GTe.NeedMore"));
            return false;
        }
        playerInventory.removeItem(new ItemStack[]{seed});
        player.updateInventory();
        return Herbalism.convertGreenTerraBlocks(blockState);
    }

    public void herbalismBlockCheck(BlockState blockState) {
        int i;
        int xp;
        boolean oneBlockPlant;
        Player player = this.getPlayer();
        Material material = blockState.getType();
        boolean bl = oneBlockPlant = material != Material.CACTUS && material != Material.SUGAR_CANE_BLOCK;
        if (oneBlockPlant && mcMMO.getPlaceStore().isTrue(blockState)) {
            return;
        }
        if (!this.canBlockCheck()) {
            return;
        }
        Collection drops = null;
        int amount = 1;
        boolean greenTerra = this.mcMMOPlayer.getAbilityMode(this.skill.getAbility());
        if (mcMMO.getModManager().isCustomHerbalismBlock(blockState)) {
            CustomBlock customBlock = mcMMO.getModManager().getBlock(blockState);
            xp = customBlock.getXpGain();
            if (Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.HERBALISM_DOUBLE_DROPS) && customBlock.isDoubleDropEnabled()) {
                drops = blockState.getBlock().getDrops();
            }
        } else {
            if (Permissions.greenThumbPlant((Permissible)player, material)) {
                this.processGreenThumbPlants(blockState, greenTerra);
            }
            xp = material == Material.DOUBLE_PLANT || material == Material.RED_ROSE || material == Material.LONG_GRASS ? ExperienceConfig.getInstance().getFlowerAndGrassXp(blockState.getData()) : ExperienceConfig.getInstance().getXp(this.skill, material);
            if (Config.getInstance().getDoubleDropsEnabled(this.skill, material) && Permissions.secondaryAbilityEnabled((Permissible)player, SecondaryAbility.HERBALISM_DOUBLE_DROPS)) {
                drops = blockState.getBlock().getDrops();
            }
            if (!oneBlockPlant) {
                amount = Herbalism.calculateCatciAndSugarDrops(blockState);
                xp *= amount;
            }
        }
        this.applyXpGain(xp);
        if (drops == null) {
            return;
        }
        int n = i = greenTerra ? 2 : 1;
        while (i != 0) {
            if (SkillUtils.activationSuccessful(SecondaryAbility.HERBALISM_DOUBLE_DROPS, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
                for (ItemStack item : drops) {
                    Misc.dropItems(blockState.getLocation(), item, amount);
                }
            }
            --i;
        }
    }

    public boolean processGreenThumbBlocks(BlockState blockState) {
        if (!SkillUtils.activationSuccessful(SecondaryAbility.GREEN_THUMB_BLOCK, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            this.getPlayer().sendMessage(LocaleLoader.getString("Herbalism.Ability.GTh.Fail"));
            return false;
        }
        return Herbalism.convertGreenTerraBlocks(blockState);
    }

    public boolean processHylianLuck(BlockState blockState) {
        List<HylianTreasure> treasures;
        if (!SkillUtils.activationSuccessful(SecondaryAbility.HYLIAN_LUCK, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            return false;
        }
        switch (blockState.getType()) {
            case DEAD_BUSH: 
            case LONG_GRASS: 
            case SAPLING: {
                treasures = TreasureConfig.getInstance().hylianFromBushes;
                break;
            }
            case RED_ROSE: 
            case YELLOW_FLOWER: {
                if (mcMMO.getPlaceStore().isTrue(blockState)) {
                    mcMMO.getPlaceStore().setFalse(blockState);
                    return false;
                }
                treasures = TreasureConfig.getInstance().hylianFromFlowers;
                break;
            }
            case FLOWER_POT: {
                treasures = TreasureConfig.getInstance().hylianFromPots;
                break;
            }
            default: {
                return false;
            }
        }
        Player player = this.getPlayer();
        if (treasures.isEmpty() || !EventUtils.simulateBlockBreak(blockState.getBlock(), player, false)) {
            return false;
        }
        blockState.setType(Material.AIR);
        Misc.dropItem(blockState.getLocation(), treasures.get(Misc.getRandom().nextInt(treasures.size())).getDrop());
        player.sendMessage(LocaleLoader.getString("Herbalism.HylianLuck"));
        return true;
    }

    public boolean processShroomThumb(BlockState blockState) {
        Player player = this.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        if (!playerInventory.contains(Material.BROWN_MUSHROOM)) {
            player.sendMessage(LocaleLoader.getString("Skills.NeedMore", StringUtils.getPrettyItemString(Material.BROWN_MUSHROOM)));
            return false;
        }
        if (!playerInventory.contains(Material.RED_MUSHROOM)) {
            player.sendMessage(LocaleLoader.getString("Skills.NeedMore", StringUtils.getPrettyItemString(Material.RED_MUSHROOM)));
            return false;
        }
        playerInventory.removeItem(new ItemStack[]{new ItemStack(Material.BROWN_MUSHROOM)});
        playerInventory.removeItem(new ItemStack[]{new ItemStack(Material.RED_MUSHROOM)});
        player.updateInventory();
        if (!SkillUtils.activationSuccessful(SecondaryAbility.SHROOM_THUMB, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            player.sendMessage(LocaleLoader.getString("Herbalism.Ability.ShroomThumb.Fail"));
            return false;
        }
        return Herbalism.convertShroomThumb(blockState);
    }

    private void processGreenThumbPlants(BlockState blockState, boolean greenTerra) {
        Player player = this.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        ItemStack seed = null;
        switch (blockState.getType()) {
            case CARROT: {
                seed = new ItemStack(Material.CARROT_ITEM);
                break;
            }
            case CROPS: {
                seed = new ItemStack(Material.SEEDS);
                break;
            }
            case NETHER_WARTS: {
                seed = new ItemStack(Material.NETHER_STALK);
                break;
            }
            case POTATO: {
                seed = new ItemStack(Material.POTATO_ITEM);
                break;
            }
        }
        if (!playerInventory.containsAtLeast(seed, 1)) {
            return;
        }
        if (!greenTerra && !SkillUtils.activationSuccessful(SecondaryAbility.GREEN_THUMB_PLANT, this.getPlayer(), this.getSkillLevel(), this.activationChance)) {
            return;
        }
        if (!this.handleBlockState(blockState, greenTerra)) {
            return;
        }
        playerInventory.removeItem(new ItemStack[]{seed});
        player.updateInventory();
        new HerbalismBlockUpdaterTask(blockState).runTaskLater((Plugin)mcMMO.p, 0L);
    }

    private boolean handleBlockState(BlockState blockState, boolean greenTerra) {
        byte greenThumbStage = this.getGreenThumbStage();
        switch (blockState.getType()) {
            case CROPS: {
                Crops crops = (Crops)blockState.getData();
                if (greenTerra) {
                    crops.setState(CropState.MEDIUM);
                } else {
                    switch (greenThumbStage) {
                        case 4: {
                            crops.setState(CropState.SMALL);
                            break;
                        }
                        case 3: {
                            crops.setState(CropState.VERY_SMALL);
                            break;
                        }
                        case 2: {
                            crops.setState(CropState.GERMINATED);
                            break;
                        }
                        default: {
                            crops.setState(CropState.SEEDED);
                        }
                    }
                }
                return true;
            }
            case CARROT: 
            case POTATO: {
                if (greenTerra) {
                    blockState.setRawData(CropState.MEDIUM.getData());
                } else {
                    blockState.setRawData(greenThumbStage);
                }
                return true;
            }
            case NETHER_WARTS: {
                NetherWarts warts = (NetherWarts)blockState.getData();
                if (greenTerra || greenThumbStage > 2) {
                    warts.setState(NetherWartsState.STAGE_TWO);
                } else if (greenThumbStage == 2) {
                    warts.setState(NetherWartsState.STAGE_ONE);
                } else {
                    warts.setState(NetherWartsState.SEEDED);
                }
                return true;
            }
            case COCOA: {
                CocoaPlant plant = (CocoaPlant)blockState.getData();
                if (greenTerra || this.getGreenThumbStage() > 1) {
                    plant.setSize(CocoaPlant.CocoaPlantSize.MEDIUM);
                } else {
                    plant.setSize(CocoaPlant.CocoaPlantSize.SMALL);
                }
                return true;
            }
        }
        return false;
    }

    private byte getGreenThumbStage() {
        return (byte)Math.min(Math.min(this.getSkillLevel(), Herbalism.greenThumbStageMaxLevel) / Herbalism.greenThumbStageChangeLevel, 4);
    }
}

