/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.repair;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.ItemUtils;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.material.MaterialData;

public class Repair {
    public static int repairMasteryMaxBonusLevel = AdvancedConfig.getInstance().getRepairMasteryMaxLevel();
    public static double repairMasteryMaxBonus = AdvancedConfig.getInstance().getRepairMasteryMaxBonus();
    public static int salvageUnlockLevel = AdvancedConfig.getInstance().getSalvageUnlockLevel();
    public static Material salvageAnvilMaterial = Config.getInstance().getSalvageAnvilMaterial();
    public static Material repairAnvilMaterial = Config.getInstance().getRepairAnvilMaterial();
    public static boolean anvilMessagesEnabled = Config.getInstance().getRepairAnvilMessagesEnabled();

    public static boolean isSalvageable(ItemStack item) {
        return Config.getInstance().getSalvageTools() && ItemUtils.isMinecraftTool(item) || Config.getInstance().getSalvageArmor() && !ItemUtils.isChainmailArmor(item) && ItemUtils.isMinecraftArmor(item);
    }

    public static String getAnvilMessage(Material type) {
        if (type == repairAnvilMaterial) {
            return LocaleLoader.getString("Repair.Listener.Anvil");
        }
        if (type == salvageAnvilMaterial) {
            return LocaleLoader.getString("Repair.Listener.Anvil2");
        }
        return "";
    }

    protected static Material getRepairAndSalvageItem(ItemStack inHand) {
        if (ItemUtils.isDiamondTool(inHand) || ItemUtils.isDiamondArmor(inHand)) {
            return Material.DIAMOND;
        }
        if (ItemUtils.isGoldTool(inHand) || ItemUtils.isGoldArmor(inHand)) {
            return Material.GOLD_INGOT;
        }
        if (ItemUtils.isIronTool(inHand) || ItemUtils.isIronArmor(inHand)) {
            return Material.IRON_INGOT;
        }
        if (ItemUtils.isStoneTool(inHand)) {
            return Material.COBBLESTONE;
        }
        if (ItemUtils.isWoodTool(inHand)) {
            return Material.WOOD;
        }
        if (ItemUtils.isLeatherArmor(inHand)) {
            return Material.LEATHER;
        }
        if (ItemUtils.isStringTool(inHand)) {
            return Material.STRING;
        }
        return null;
    }

    public static int getRepairAndSalvageQuantities(ItemStack item) {
        return Repair.getRepairAndSalvageQuantities(item, Repair.getRepairAndSalvageItem(item), (byte)-1);
    }

    public static int getRepairAndSalvageQuantities(ItemStack item, Material repairMaterial, byte repairMetadata) {
        int quantity;
        block2: {
            Recipe recipe;
            MaterialData repairData;
            block3: {
                quantity = 0;
                repairData = repairMaterial != null ? new MaterialData(repairMaterial, repairMetadata) : null;
                List recipes = mcMMO.p.getServer().getRecipesFor(item);
                if (recipes.isEmpty()) break block2;
                recipe = (Recipe)recipes.get(0);
                if (!(recipe instanceof ShapelessRecipe)) break block3;
                for (ItemStack ingredient : ((ShapelessRecipe)recipe).getIngredientList()) {
                    if (ingredient == null || repairMaterial != null && ingredient.getType() != repairMaterial || repairMetadata != -1 && !ingredient.getData().equals((Object)repairData)) continue;
                    quantity += ingredient.getAmount();
                }
                break block2;
            }
            if (!(recipe instanceof ShapedRecipe)) break block2;
            for (ItemStack ingredient : ((ShapedRecipe)recipe).getIngredientMap().values()) {
                if (ingredient == null || repairMaterial != null && ingredient.getType() != repairMaterial || repairMetadata != -1 && !ingredient.getData().equals((Object)repairData)) continue;
                quantity += ingredient.getAmount();
            }
        }
        return quantity;
    }
}

