/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.smelting;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.SecondaryAbility;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.events.skills.secondaryabilities.SecondaryAbilityWeightedActivationCheckEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.smelting.Smelting;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.skills.SkillUtils;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.Permissible;

public class SmeltingManager
extends SkillManager {
    public SmeltingManager(McMMOPlayer mcMMOPlayer) {
        super(mcMMOPlayer, SkillType.SMELTING);
    }

    public boolean canUseFluxMining(BlockState blockState) {
        return this.getSkillLevel() >= Smelting.fluxMiningUnlockLevel && BlockUtils.affectedByFluxMining(blockState) && Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.FLUX_MINING) && !mcMMO.getPlaceStore().isTrue(blockState);
    }

    public boolean isSecondSmeltSuccessful() {
        return Permissions.secondaryAbilityEnabled((Permissible)this.getPlayer(), SecondaryAbility.SECOND_SMELT) && SkillUtils.activationSuccessful(SecondaryAbility.SECOND_SMELT, this.getPlayer(), this.getSkillLevel(), this.activationChance);
    }

    public boolean processFluxMining(BlockState blockState) {
        Player player = this.getPlayer();
        SecondaryAbilityWeightedActivationCheckEvent event = new SecondaryAbilityWeightedActivationCheckEvent(this.getPlayer(), SecondaryAbility.FLUX_MINING, Smelting.fluxMiningChance / (double)this.activationChance);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)event);
        if (event.getChance() * (double)this.activationChance > (double)Misc.getRandom().nextInt(this.activationChance)) {
            ItemStack item = null;
            switch (blockState.getType()) {
                case IRON_ORE: {
                    item = new ItemStack(Material.IRON_INGOT);
                    break;
                }
                case GOLD_ORE: {
                    item = new ItemStack(Material.GOLD_INGOT);
                    break;
                }
            }
            if (item == null) {
                return false;
            }
            Misc.dropItems(blockState.getLocation(), item, this.isSecondSmeltSuccessful() ? 2 : 1);
            blockState.setType(Material.AIR);
            player.sendMessage(LocaleLoader.getString("Smelting.FluxMining.Success"));
            return true;
        }
        return false;
    }

    public int fuelEfficiency(int burnTime) {
        double burnModifier = 1.0 + (double)this.getSkillLevel() / (double)Smelting.burnModifierMaxLevel * Smelting.burnTimeMultiplier;
        return (int)((double)burnTime * burnModifier);
    }

    public ItemStack smeltProcessing(ItemStack smelting, ItemStack result) {
        this.applyXpGain(Smelting.getResourceXp(smelting));
        if (this.isSecondSmeltSuccessful()) {
            ItemStack newResult = result.clone();
            newResult.setAmount(result.getAmount() + 1);
            return newResult;
        }
        return result;
    }

    public int vanillaXPBoost(int experience) {
        return experience * this.getVanillaXpMultiplier();
    }

    public int getVanillaXpMultiplier() {
        int skillLevel = this.getSkillLevel();
        for (Smelting.Tier tier : Smelting.Tier.values()) {
            if (skillLevel < tier.getLevel()) continue;
            return tier.getVanillaXPBoostModifier();
        }
        return 1;
    }
}

