/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.skills.woodcutting;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.BlockUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.skills.SkillUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.TreeSpecies;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.Tree;

public final class Woodcutting {
    public static int leafBlowerUnlockLevel = AdvancedConfig.getInstance().getLeafBlowUnlockLevel();
    public static int treeFellerThreshold = Config.getInstance().getTreeFellerThreshold();
    protected static boolean treeFellerReachedThreshold = false;
    private static final int[][] directions = new int[][]{{-2, -1}, {-2, 0}, {-2, 1}, {-1, -2}, {-1, -1}, {-1, 0}, {-1, 1}, {-1, 2}, {0, -2}, {0, -1}, {0, 1}, {0, 2}, {1, -2}, {1, -1}, {1, 0}, {1, 1}, {1, 2}, {2, -1}, {2, 0}, {2, 1}};

    private Woodcutting() {
    }

    protected static int getExperienceFromLog(BlockState blockState, ExperienceGainMethod experienceGainMethod) {
        switch (blockState.getType()) {
            case HUGE_MUSHROOM_1: {
                return ExperienceConfig.getInstance().getWoodcuttingXPHugeBrownMushroom();
            }
            case HUGE_MUSHROOM_2: {
                return ExperienceConfig.getInstance().getWoodcuttingXPHugeRedMushroom();
            }
        }
        if (mcMMO.getModManager().isCustomLog(blockState)) {
            return mcMMO.getModManager().getBlock(blockState).getXpGain();
        }
        TreeSpecies species = TreeSpecies.GENERIC;
        if (blockState.getData() instanceof Tree) {
            species = ((Tree)blockState.getData()).getSpecies();
        }
        int xp = ExperienceConfig.getInstance().getWoodcuttingTreeXP(species);
        if (species == TreeSpecies.JUNGLE && experienceGainMethod == ExperienceGainMethod.TREE_FELLER) {
            xp = (int)((double)xp * 0.5);
        }
        return xp;
    }

    protected static void checkForDoubleDrop(BlockState blockState) {
        if (mcMMO.getModManager().isCustomLog(blockState) && mcMMO.getModManager().getBlock(blockState).isDoubleDropEnabled()) {
            Misc.dropItems(blockState.getLocation(), blockState.getBlock().getDrops());
        } else {
            TreeSpecies species = TreeSpecies.GENERIC;
            if (blockState.getData() instanceof Tree) {
                species = ((Tree)blockState.getData()).getSpecies();
            }
            if (Config.getInstance().getWoodcuttingDoubleDropsEnabled(species)) {
                Misc.dropItems(blockState.getLocation(), blockState.getBlock().getDrops());
            }
        }
    }

    protected static void processTree(BlockState blockState, Set<BlockState> treeFellerBlocks) {
        ArrayList<BlockState> futureCenterBlocks = new ArrayList<BlockState>();
        if (Woodcutting.handleBlock(blockState.getBlock().getRelative(BlockFace.UP).getState(), futureCenterBlocks, treeFellerBlocks)) {
            for (int[] dir : directions) {
                Woodcutting.handleBlock(blockState.getBlock().getRelative(dir[0], 0, dir[1]).getState(), futureCenterBlocks, treeFellerBlocks);
                if (!treeFellerReachedThreshold) continue;
                return;
            }
        } else {
            Woodcutting.handleBlock(blockState.getBlock().getRelative(BlockFace.DOWN).getState(), futureCenterBlocks, treeFellerBlocks);
            for (int y = -1; y <= 1; ++y) {
                for (int[] dir : directions) {
                    Woodcutting.handleBlock(blockState.getBlock().getRelative(dir[0], y, dir[1]).getState(), futureCenterBlocks, treeFellerBlocks);
                    if (!treeFellerReachedThreshold) continue;
                    return;
                }
            }
        }
        for (BlockState futureCenterBlock : futureCenterBlocks) {
            if (treeFellerReachedThreshold) {
                return;
            }
            Woodcutting.processTree(futureCenterBlock, treeFellerBlocks);
        }
    }

    protected static boolean handleDurabilityLoss(Set<BlockState> treeFellerBlocks, ItemStack inHand) {
        int durabilityLoss = 0;
        Material type = inHand.getType();
        for (BlockState blockState : treeFellerBlocks) {
            if (!BlockUtils.isLog(blockState)) continue;
            durabilityLoss = (short)(durabilityLoss + Config.getInstance().getAbilityToolDamage());
        }
        SkillUtils.handleDurabilityChange(inHand, durabilityLoss);
        return inHand.getDurability() < (mcMMO.getRepairableManager().isRepairable(type) ? mcMMO.getRepairableManager().getRepairable(type).getMaximumDurability() : type.getMaxDurability());
    }

    private static boolean handleBlock(BlockState blockState, List<BlockState> futureCenterBlocks, Set<BlockState> treeFellerBlocks) {
        if (treeFellerBlocks.contains(blockState) || mcMMO.getPlaceStore().isTrue(blockState)) {
            return false;
        }
        if (treeFellerBlocks.size() > treeFellerThreshold) {
            treeFellerReachedThreshold = true;
        }
        if (BlockUtils.isLog(blockState)) {
            treeFellerBlocks.add(blockState);
            futureCenterBlocks.add(blockState);
            return true;
        }
        if (BlockUtils.isLeaves(blockState)) {
            treeFellerBlocks.add(blockState);
            return false;
        }
        return false;
    }

    protected static enum ExperienceGainMethod {
        DEFAULT,
        TREE_FELLER;

    }
}

