/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.party.ItemWeightConfig;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.MaterialUtils;
import org.bukkit.ChatColor;
import org.bukkit.CoalType;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.Coal;
import org.bukkit.material.Dye;

public final class ItemUtils {
    private ItemUtils() {
    }

    public static boolean isBow(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case BOW: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomBow(type);
    }

    public static boolean isSword(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_SWORD: 
            case GOLD_SWORD: 
            case IRON_SWORD: 
            case STONE_SWORD: 
            case WOOD_SWORD: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomSword(type);
    }

    public static boolean isHoe(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_HOE: 
            case GOLD_HOE: 
            case IRON_HOE: 
            case STONE_HOE: 
            case WOOD_HOE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomHoe(type);
    }

    public static boolean isShovel(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_SPADE: 
            case GOLD_SPADE: 
            case IRON_SPADE: 
            case STONE_SPADE: 
            case WOOD_SPADE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomShovel(type);
    }

    public static boolean isAxe(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_AXE: 
            case GOLD_AXE: 
            case IRON_AXE: 
            case STONE_AXE: 
            case WOOD_AXE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomAxe(type);
    }

    public static boolean isPickaxe(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_PICKAXE: 
            case GOLD_PICKAXE: 
            case IRON_PICKAXE: 
            case STONE_PICKAXE: 
            case WOOD_PICKAXE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomPickaxe(type);
    }

    public static boolean isHelmet(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_HELMET: 
            case GOLD_HELMET: 
            case IRON_HELMET: 
            case CHAINMAIL_HELMET: 
            case LEATHER_HELMET: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomHelmet(type);
    }

    public static boolean isChestplate(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_CHESTPLATE: 
            case GOLD_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case CHAINMAIL_CHESTPLATE: 
            case LEATHER_CHESTPLATE: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomChestplate(type);
    }

    public static boolean isLeggings(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_LEGGINGS: 
            case GOLD_LEGGINGS: 
            case IRON_LEGGINGS: 
            case CHAINMAIL_LEGGINGS: 
            case LEATHER_LEGGINGS: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomLeggings(type);
    }

    public static boolean isBoots(ItemStack item) {
        Material type = item.getType();
        switch (type) {
            case DIAMOND_BOOTS: 
            case GOLD_BOOTS: 
            case IRON_BOOTS: 
            case CHAINMAIL_BOOTS: 
            case LEATHER_BOOTS: {
                return true;
            }
        }
        return mcMMO.getModManager().isCustomBoots(type);
    }

    public static boolean isArmor(ItemStack item) {
        return ItemUtils.isHelmet(item) || ItemUtils.isChestplate(item) || ItemUtils.isLeggings(item) || ItemUtils.isBoots(item);
    }

    public static boolean isMinecraftArmor(ItemStack item) {
        return ItemUtils.isLeatherArmor(item) || ItemUtils.isGoldArmor(item) || ItemUtils.isIronArmor(item) || ItemUtils.isDiamondArmor(item) || ItemUtils.isChainmailArmor(item);
    }

    public static boolean isLeatherArmor(ItemStack item) {
        switch (item.getType()) {
            case LEATHER_HELMET: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: 
            case LEATHER_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGoldArmor(ItemStack item) {
        switch (item.getType()) {
            case GOLD_HELMET: 
            case GOLD_CHESTPLATE: 
            case GOLD_LEGGINGS: 
            case GOLD_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIronArmor(ItemStack item) {
        switch (item.getType()) {
            case IRON_HELMET: 
            case IRON_CHESTPLATE: 
            case IRON_LEGGINGS: 
            case IRON_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDiamondArmor(ItemStack item) {
        switch (item.getType()) {
            case DIAMOND_HELMET: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_LEGGINGS: 
            case DIAMOND_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isChainmailArmor(ItemStack item) {
        switch (item.getType()) {
            case CHAINMAIL_HELMET: 
            case CHAINMAIL_CHESTPLATE: 
            case CHAINMAIL_LEGGINGS: 
            case CHAINMAIL_BOOTS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMinecraftTool(ItemStack item) {
        return ItemUtils.isStoneTool(item) || ItemUtils.isWoodTool(item) || ItemUtils.isGoldTool(item) || ItemUtils.isIronTool(item) || ItemUtils.isDiamondTool(item) || ItemUtils.isStringTool(item);
    }

    public static boolean isStoneTool(ItemStack item) {
        switch (item.getType()) {
            case STONE_SWORD: 
            case STONE_HOE: 
            case STONE_SPADE: 
            case STONE_AXE: 
            case STONE_PICKAXE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWoodTool(ItemStack item) {
        switch (item.getType()) {
            case WOOD_SWORD: 
            case WOOD_HOE: 
            case WOOD_SPADE: 
            case WOOD_AXE: 
            case WOOD_PICKAXE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isStringTool(ItemStack item) {
        switch (item.getType()) {
            case BOW: 
            case CARROT_STICK: 
            case FISHING_ROD: {
                return true;
            }
        }
        return false;
    }

    public static boolean isGoldTool(ItemStack item) {
        switch (item.getType()) {
            case GOLD_SWORD: 
            case GOLD_HOE: 
            case GOLD_SPADE: 
            case GOLD_AXE: 
            case GOLD_PICKAXE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isIronTool(ItemStack item) {
        switch (item.getType()) {
            case IRON_SWORD: 
            case IRON_HOE: 
            case IRON_SPADE: 
            case IRON_AXE: 
            case IRON_PICKAXE: 
            case BUCKET: 
            case FLINT_AND_STEEL: 
            case SHEARS: {
                return true;
            }
        }
        return false;
    }

    public static boolean isDiamondTool(ItemStack item) {
        switch (item.getType()) {
            case DIAMOND_SWORD: 
            case DIAMOND_HOE: 
            case DIAMOND_SPADE: 
            case DIAMOND_AXE: 
            case DIAMOND_PICKAXE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isEnchantable(ItemStack item) {
        switch (item.getType()) {
            case CARROT_STICK: 
            case FISHING_ROD: 
            case FLINT_AND_STEEL: 
            case SHEARS: {
                return true;
            }
        }
        return ItemUtils.isArmor(item) || ItemUtils.isSword(item) || ItemUtils.isAxe(item) || ItemUtils.isShovel(item) || ItemUtils.isPickaxe(item) || ItemUtils.isBow(item);
    }

    public static boolean isSmeltable(ItemStack item) {
        return item != null && MaterialUtils.isOre(item.getData());
    }

    public static boolean isSmelted(ItemStack item) {
        if (item == null) {
            return false;
        }
        for (Recipe recipe : mcMMO.p.getServer().getRecipesFor(item)) {
            if (!(recipe instanceof FurnaceRecipe)) continue;
            return MaterialUtils.isOre(((FurnaceRecipe)recipe).getInput().getData());
        }
        return false;
    }

    public static boolean isSharable(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return ItemUtils.isMiningDrop(item) || ItemUtils.isWoodcuttingDrop(item) || ItemUtils.isMobDrop(item) || ItemUtils.isHerbalismDrop(item) || ItemUtils.isMiscDrop(item);
    }

    public static boolean isMiningDrop(ItemStack item) {
        switch (item.getType()) {
            case COAL: 
            case COAL_ORE: 
            case DIAMOND: 
            case DIAMOND_ORE: 
            case EMERALD: 
            case EMERALD_ORE: 
            case GOLD_ORE: 
            case IRON_ORE: 
            case LAPIS_ORE: 
            case REDSTONE_ORE: 
            case REDSTONE: 
            case GLOWSTONE_DUST: 
            case QUARTZ: 
            case QUARTZ_ORE: {
                return true;
            }
            case INK_SACK: {
                return ((Dye)item.getData()).getColor() == DyeColor.BLUE;
            }
        }
        return false;
    }

    public static boolean isHerbalismDrop(ItemStack item) {
        switch (item.getType()) {
            case WHEAT: 
            case SEEDS: 
            case CARROT_ITEM: 
            case POTATO_ITEM: 
            case NETHER_WARTS: 
            case BROWN_MUSHROOM: 
            case RED_MUSHROOM: 
            case RED_ROSE: 
            case YELLOW_FLOWER: 
            case CACTUS: 
            case SUGAR_CANE: 
            case MELON: 
            case MELON_SEEDS: 
            case PUMPKIN: 
            case PUMPKIN_SEEDS: 
            case WATER_LILY: 
            case VINE: 
            case LONG_GRASS: 
            case DOUBLE_PLANT: {
                return true;
            }
            case INK_SACK: {
                return ((Dye)item.getData()).getColor() == DyeColor.BROWN;
            }
        }
        return false;
    }

    public static boolean isMobDrop(ItemStack item) {
        switch (item.getType()) {
            case STRING: 
            case FEATHER: 
            case RAW_CHICKEN: 
            case COOKED_CHICKEN: 
            case LEATHER: 
            case RAW_BEEF: 
            case COOKED_BEEF: 
            case PORK: 
            case GRILLED_PORK: 
            case WOOL: 
            case IRON_INGOT: 
            case SNOW_BALL: 
            case BLAZE_ROD: 
            case SPIDER_EYE: 
            case SULPHUR: 
            case ENDER_PEARL: 
            case GHAST_TEAR: 
            case MAGMA_CREAM: 
            case BONE: 
            case ARROW: 
            case SLIME_BALL: 
            case NETHER_STAR: 
            case ROTTEN_FLESH: 
            case GOLD_NUGGET: 
            case EGG: {
                return true;
            }
            case COAL: {
                return ((Coal)item.getData()).getType() == CoalType.COAL;
            }
            case RED_ROSE: {
                return item.getData().getData() == 0;
            }
        }
        return false;
    }

    public static boolean isWoodcuttingDrop(ItemStack item) {
        switch (item.getType()) {
            case LOG: 
            case LOG_2: 
            case LEAVES: 
            case LEAVES_2: 
            case SAPLING: 
            case APPLE: {
                return true;
            }
        }
        return false;
    }

    public static boolean isMiscDrop(ItemStack item) {
        return ItemWeightConfig.getInstance().getMiscItems().contains(item.getType());
    }

    public static boolean isMcMMOItem(ItemStack item) {
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta.hasLore() && itemMeta.getLore().contains("mcMMO Item");
    }

    public static boolean isChimaeraWing(ItemStack item) {
        if (!ItemUtils.isMcMMOItem(item)) {
            return false;
        }
        ItemMeta itemMeta = item.getItemMeta();
        return itemMeta.hasDisplayName() && itemMeta.getDisplayName().equals(ChatColor.GOLD + LocaleLoader.getString("Item.ChimaeraWing.Name"));
    }
}

