/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.mods.CustomArmorConfig;
import com.gmail.nossr50.config.mods.CustomBlockConfig;
import com.gmail.nossr50.config.mods.CustomEntityConfig;
import com.gmail.nossr50.config.mods.CustomToolConfig;
import com.gmail.nossr50.datatypes.mods.CustomBlock;
import com.gmail.nossr50.datatypes.mods.CustomEntity;
import com.gmail.nossr50.datatypes.mods.CustomTool;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.repair.repairables.Repairable;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class ModManager {
    private List<Repairable> repairables = new ArrayList<Repairable>();
    private List<Material> customBoots = new ArrayList<Material>();
    private List<Material> customChestplates = new ArrayList<Material>();
    private List<Material> customHelmets = new ArrayList<Material>();
    private List<Material> customLeggings = new ArrayList<Material>();
    private List<MaterialData> customExcavationBlocks = new ArrayList<MaterialData>();
    private List<MaterialData> customHerbalismBlocks = new ArrayList<MaterialData>();
    private List<MaterialData> customMiningBlocks = new ArrayList<MaterialData>();
    private List<MaterialData> customOres = new ArrayList<MaterialData>();
    private List<MaterialData> customLogs = new ArrayList<MaterialData>();
    private List<MaterialData> customLeaves = new ArrayList<MaterialData>();
    private List<MaterialData> customAbilityBlocks = new ArrayList<MaterialData>();
    private HashMap<MaterialData, CustomBlock> customBlockMap = new HashMap();
    private HashMap<String, CustomEntity> customEntityClassMap = new HashMap();
    private HashMap<String, CustomEntity> customEntityTypeMap = new HashMap();
    private List<Material> customAxes = new ArrayList<Material>();
    private List<Material> customBows = new ArrayList<Material>();
    private List<Material> customHoes = new ArrayList<Material>();
    private List<Material> customPickaxes = new ArrayList<Material>();
    private List<Material> customShovels = new ArrayList<Material>();
    private List<Material> customSwords = new ArrayList<Material>();
    private HashMap<Material, CustomTool> customToolMap = new HashMap();

    public void registerCustomArmor(CustomArmorConfig config) {
        this.customBoots.addAll(config.customBoots);
        this.customChestplates.addAll(config.customChestplates);
        this.customHelmets.addAll(config.customHelmets);
        this.customLeggings.addAll(config.customLeggings);
        this.repairables.addAll(config.repairables);
    }

    public void registerCustomBlocks(CustomBlockConfig config) {
        this.customExcavationBlocks.addAll(config.customExcavationBlocks);
        this.customHerbalismBlocks.addAll(config.customHerbalismBlocks);
        this.customMiningBlocks.addAll(config.customMiningBlocks);
        this.customOres.addAll(config.customOres);
        this.customLogs.addAll(config.customLogs);
        this.customLeaves.addAll(config.customLeaves);
        this.customAbilityBlocks.addAll(config.customAbilityBlocks);
        this.customBlockMap.putAll(config.customBlockMap);
    }

    public void registerCustomEntities(CustomEntityConfig config) {
        this.customEntityClassMap.putAll(config.customEntityClassMap);
        this.customEntityTypeMap.putAll(config.customEntityTypeMap);
    }

    public void registerCustomTools(CustomToolConfig config) {
        this.customAxes.addAll(config.customAxes);
        this.customBows.addAll(config.customBows);
        this.customHoes.addAll(config.customHoes);
        this.customPickaxes.addAll(config.customPickaxes);
        this.customShovels.addAll(config.customShovels);
        this.customSwords.addAll(config.customSwords);
        this.customToolMap.putAll(config.customToolMap);
        this.repairables.addAll(config.repairables);
    }

    public boolean isCustomBoots(Material material) {
        return Config.getInstance().getArmorModsEnabled() && this.customBoots.contains(material);
    }

    public boolean isCustomChestplate(Material material) {
        return Config.getInstance().getArmorModsEnabled() && this.customChestplates.contains(material);
    }

    public boolean isCustomHelmet(Material material) {
        return Config.getInstance().getArmorModsEnabled() && this.customHelmets.contains(material);
    }

    public boolean isCustomLeggings(Material material) {
        return Config.getInstance().getArmorModsEnabled() && this.customLeggings.contains(material);
    }

    public boolean isCustomAxe(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customAxes.contains(material);
    }

    public boolean isCustomBow(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customBows.contains(material);
    }

    public boolean isCustomHoe(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customHoes.contains(material);
    }

    public boolean isCustomPickaxe(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customPickaxes.contains(material);
    }

    public boolean isCustomShovel(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customShovels.contains(material);
    }

    public boolean isCustomSword(Material material) {
        return Config.getInstance().getToolModsEnabled() && this.customSwords.contains(material);
    }

    public boolean isCustomOre(MaterialData data) {
        return Config.getInstance().getBlockModsEnabled() && this.customOres.contains(data);
    }

    public boolean isCustomLog(BlockState state) {
        return Config.getInstance().getBlockModsEnabled() && this.customLogs.contains(state.getData());
    }

    public boolean isCustomLeaf(BlockState state) {
        return Config.getInstance().getBlockModsEnabled() && this.customLeaves.contains(state.getData());
    }

    public boolean isCustomAbilityBlock(BlockState state) {
        return Config.getInstance().getBlockModsEnabled() && this.customAbilityBlocks.contains(state.getData());
    }

    public boolean isCustomExcavationBlock(BlockState state) {
        return Config.getInstance().getBlockModsEnabled() && this.customExcavationBlocks.contains(state.getData());
    }

    public boolean isCustomHerbalismBlock(BlockState state) {
        return Config.getInstance().getBlockModsEnabled() && this.customHerbalismBlocks.contains(state.getData());
    }

    public boolean isCustomMiningBlock(BlockState state) {
        return Config.getInstance().getBlockModsEnabled() && this.customMiningBlocks.contains(state.getData());
    }

    public CustomBlock getBlock(BlockState state) {
        return this.customBlockMap.get(state.getData());
    }

    public CustomBlock getBlock(MaterialData data) {
        return this.customBlockMap.get(data);
    }

    public boolean isCustomTool(ItemStack item) {
        return Config.getInstance().getToolModsEnabled() && item != null && this.customToolMap.containsKey(item.getType());
    }

    public CustomTool getTool(ItemStack item) {
        return item == null ? null : this.customToolMap.get(item.getType());
    }

    public List<Repairable> getLoadedRepairables() {
        return this.repairables;
    }

    public boolean isCustomEntity(Entity entity) {
        if (!Config.getInstance().getEntityModsEnabled()) {
            return false;
        }
        if (this.customEntityTypeMap.containsKey(entity.getType().toString())) {
            return true;
        }
        try {
            return this.customEntityClassMap.containsKey(((Class)entity.getClass().getDeclaredField("entityClass").get(entity)).getName());
        }
        catch (Exception e) {
            if (e instanceof NoSuchFieldException || e instanceof IllegalArgumentException || e instanceof IllegalAccessException) {
                return this.customEntityClassMap.containsKey(entity.getClass().getName());
            }
            e.printStackTrace();
            return false;
        }
    }

    public CustomEntity getEntity(Entity entity) {
        CustomEntity customEntity = this.customEntityTypeMap.get(entity.getType().toString());
        if (customEntity == null) {
            try {
                customEntity = this.customEntityClassMap.get(((Class)entity.getClass().getDeclaredField("entityClass").get(entity)).getName());
            }
            catch (Exception e) {
                if (e instanceof NoSuchFieldException || e instanceof IllegalArgumentException || e instanceof IllegalAccessException) {
                    customEntity = this.customEntityClassMap.get(entity.getClass().getName());
                }
                e.printStackTrace();
            }
        }
        return customEntity;
    }

    public void addCustomEntity(Entity entity) {
        if (!Config.getInstance().getEntityModsEnabled()) {
            return;
        }
        File entityFile = new File(mcMMO.p.getDataFolder(), "mods" + File.separator + "entities.default.yml");
        YamlConfiguration entitiesFile = YamlConfiguration.loadConfiguration((File)entityFile);
        String entityName = entity.getType().toString();
        String sanitizedEntityName = entityName.replace(".", "_");
        if (entitiesFile.getKeys(false).contains(sanitizedEntityName)) {
            return;
        }
        entitiesFile.set(sanitizedEntityName + ".XP_Multiplier", (Object)1.0);
        entitiesFile.set(sanitizedEntityName + ".Tameable", (Object)false);
        entitiesFile.set(sanitizedEntityName + ".Taming_XP", (Object)0);
        entitiesFile.set(sanitizedEntityName + ".CanBeSummoned", (Object)false);
        entitiesFile.set(sanitizedEntityName + ".COTW_Material", (Object)"");
        entitiesFile.set(sanitizedEntityName + ".COTW_Material_Data", (Object)0);
        entitiesFile.set(sanitizedEntityName + ".COTW_Material_Amount", (Object)0);
        String className = "";
        try {
            className = ((Class)entity.getClass().getDeclaredField("entityClass").get(entity)).getName();
        }
        catch (Exception e) {
            if (e instanceof NoSuchFieldException || e instanceof IllegalArgumentException || e instanceof IllegalAccessException) {
                className = entity.getClass().getName();
            }
            e.printStackTrace();
        }
        CustomEntity customEntity = new CustomEntity(1.0, false, 0, false, null, 0);
        this.customEntityTypeMap.put(entityName, customEntity);
        this.customEntityClassMap.put(className, customEntity);
        try {
            entitiesFile.save(entityFile);
            mcMMO.p.debug(entity.getType().toString() + " was added to the custom entities file!");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

