/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.skills.SkillType;
import com.gmail.nossr50.util.Permissions;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public final class PerksUtils {
    private static final int LUCKY_SKILL_ACTIVATION_CHANCE = 75;
    private static final int NORMAL_SKILL_ACTIVATION_CHANCE = 100;

    private PerksUtils() {
    }

    public static int handleCooldownPerks(Player player, int cooldown) {
        if (Permissions.halvedCooldowns((Permissible)player)) {
            cooldown = (int)((double)cooldown * 0.5);
        } else if (Permissions.thirdedCooldowns((Permissible)player)) {
            cooldown = (int)((double)cooldown * 0.6666666666666666);
        } else if (Permissions.quarteredCooldowns((Permissible)player)) {
            cooldown = (int)((double)cooldown * 0.75);
        }
        return cooldown;
    }

    public static int handleActivationPerks(Player player, int ticks, int maxTicks) {
        if (maxTicks != 0) {
            ticks = Math.min(ticks, maxTicks);
        }
        if (Permissions.twelveSecondActivationBoost((Permissible)player)) {
            ticks += 12;
        } else if (Permissions.eightSecondActivationBoost((Permissible)player)) {
            ticks += 8;
        } else if (Permissions.fourSecondActivationBoost((Permissible)player)) {
            ticks += 4;
        }
        return ticks;
    }

    public static float handleXpPerks(Player player, float xp, SkillType skill) {
        if (Permissions.quadrupleXp((Permissible)player, skill)) {
            xp *= 4.0f;
        } else if (Permissions.tripleXp((Permissible)player, skill)) {
            xp *= 3.0f;
        } else if (Permissions.doubleAndOneHalfXp((Permissible)player, skill)) {
            xp = (float)((double)xp * 2.5);
        } else if (Permissions.doubleXp((Permissible)player, skill)) {
            xp *= 2.0f;
        } else if (Permissions.oneAndOneHalfXp((Permissible)player, skill)) {
            xp = (float)((double)xp * 1.5);
        } else if (Permissions.oneAndOneTenthXp((Permissible)player, skill)) {
            xp = (float)((double)xp * 1.1);
        } else if (Permissions.customXpBoost((Permissible)player, skill)) {
            xp = (float)((double)xp * ExperienceConfig.getInstance().getCustomXpPerkBoost());
        }
        return xp;
    }

    public static int handleLuckyPerks(Player player, SkillType skill) {
        if (Permissions.lucky((Permissible)player, skill)) {
            return 75;
        }
        return 100;
    }
}

