/*
 * Decompiled with CFR 0.152.
 */
package info.varden.chatlog;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import info.varden.chatlog.ChatReceivedHandler;
import info.varden.chatlog.Command;
import info.varden.chatlog.ConfigManager;
import info.varden.chatlog.HtmlConverter;
import info.varden.chatlog.Logs;
import info.varden.chatlog.Themes;
import info.varden.chatlog.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import org.apache.logging.log4j.Logger;

@Mod(modid="info.varden.chatlog", name="ChatLog", version="2.0.1.27 for Forge 1.7.2")
public class ChatLog {
    public Themes themes;
    public HtmlConverter htmlConverter;
    public ConfigManager configManager;
    public Logs logs;
    public Minecraft mc;
    public Util util;
    private Logger logger;
    @Mod.Instance(value="info.varden.chatlog")
    public static ChatLog instance;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        this.mc = Minecraft.func_71410_x();
        this.logInfo("Initializing ChatLog...");
        this.util = new Util(this);
        this.themes = new Themes(this);
        this.themes.initThemes();
        this.htmlConverter = new HtmlConverter(this);
        this.configManager = new ConfigManager(this);
        this.logs = new Logs(this);
        this.configManager.readPropertiesFile();
        this.logInfo("Initialized.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.logInfo("Registering chat handler to Forge event bus...");
        MinecraftForge.EVENT_BUS.register((Object)new ChatReceivedHandler(this));
        this.logInfo("Chat handler registered.");
        this.logInfo("Registering control command to client command registry...");
        ClientCommandHandler.instance.func_71560_a((ICommand)new Command(this));
        this.logInfo("Control command registered.");
    }

    public void logInfo(String message) {
        this.logger.info(message);
    }

    public void logWarning(String message) {
        this.logger.warn(message);
    }

    public void logSevere(String message) {
        this.logger.error(message);
    }

    public void postToChat(String message) {
        ChatComponentText cp = new ChatComponentText("\u00c2\u00a78[\u00c2\u00a7cChatLog\u00c2\u00a78] " + message);
        this.mc.field_71439_g.func_146105_b((IChatComponent)cp);
    }

    public void postSimple(String message) {
        ChatComponentText cp = new ChatComponentText(message);
        this.mc.field_71439_g.func_146105_b((IChatComponent)cp);
    }
}

