/*
 * Decompiled with CFR 0.152.
 */
package info.varden.chatlog;

import info.varden.chatlog.ChatLog;
import info.varden.chatlog.LogFilenameFilter;
import info.varden.chatlog.Util;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;

public class Logs {
    private ChatLog cl;

    public Logs(ChatLog cl) {
        this.cl = cl;
    }

    public static File[] find(String dirName) {
        File dir = new File(dirName);
        return dir.listFiles(new LogFilenameFilter());
    }

    public void prune(int maxCount) {
        File[] storedLogs = Logs.find(Util.getChatLogFolderPath());
        if (storedLogs.length > maxCount) {
            ArrayList<File> toBeDeleted = new ArrayList<File>(0);
            ArrayList<File> allLists = new ArrayList<File>(Arrays.asList(storedLogs));
            for (int filesStoreAfter = storedLogs.length; filesStoreAfter > maxCount; --filesStoreAfter) {
                toBeDeleted.add(allLists.get(0));
                allLists.remove(0);
            }
            for (File f : toBeDeleted) {
                f.delete();
            }
        }
    }

    public void write(String message, String flags) {
        try {
            File fLoc = new File(Util.getChatLogFolderPath());
            fLoc.mkdir();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String curDate = df.format(new Date());
            String filename = curDate + ".htm";
            String fileLocation = new File(Util.getChatLogFolderPath(), filename).getAbsolutePath();
            FileWriter fw = new FileWriter(fileLocation, true);
            String msg = this.cl.htmlConverter.convert(message, flags);
            fw.write(msg);
            fw.close();
        }
        catch (IOException e) {
            this.cl.logSevere("FAILED TO WRITE TO CHAT LOG: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

