/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.helpers.tileentity.TileEntityHelper;
import bspkrs.helpers.world.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class Coord {
    public int x;
    public int y;
    public int z;

    public Coord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Coord clone() {
        return new Coord(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Coord)) {
            return false;
        }
        Coord o = (Coord)obj;
        return this.x == o.x && this.y == o.y && this.z == o.z;
    }

    public int hashCode() {
        return this.x + this.z << 8 + this.y << 16;
    }

    public Coord add(Coord pos) {
        return new Coord(this.x + pos.x, this.y + pos.y, this.z + pos.z);
    }

    public Coord add(int[] ai) {
        return new Coord(this.x + ai[0], this.y + ai[1], this.z + ai[2]);
    }

    public Coord substract(Coord pos) {
        return new Coord(this.x - pos.x, this.y - pos.y, this.z - pos.z);
    }

    public Coord substract(int[] ai) {
        return new Coord(this.x - ai[0], this.y - ai[1], this.z - ai[2]);
    }

    public Coord getAdjacentCoord(ForgeDirection fd) {
        return this.getOffsetCoord(fd, 1);
    }

    public Coord getOffsetCoord(ForgeDirection fd, int distance) {
        return new Coord(this.x + fd.offsetX * distance, this.y + fd.offsetY * distance, this.z + fd.offsetZ * distance);
    }

    public Coord[] getDirectlyAdjacentCoords() {
        return this.getDirectlyAdjacentCoords(true);
    }

    public Coord[] getDirectlyAdjacentCoords(boolean includeBelow) {
        Coord[] adjacents = includeBelow ? new Coord[6] : new Coord[]{this.getAdjacentCoord(ForgeDirection.UP), this.getAdjacentCoord(ForgeDirection.NORTH), this.getAdjacentCoord(ForgeDirection.EAST), this.getAdjacentCoord(ForgeDirection.SOUTH), this.getAdjacentCoord(ForgeDirection.WEST)};
        if (includeBelow) {
            adjacents[5] = this.getAdjacentCoord(ForgeDirection.DOWN);
        }
        return adjacents;
    }

    public Coord[] getAdjacentCoords() {
        return this.getAdjacentCoords(true, true);
    }

    public Coord[] getAdjacentCoords(boolean includeBelow, boolean includeDiagonal) {
        if (!includeDiagonal) {
            return this.getDirectlyAdjacentCoords(includeBelow);
        }
        Coord[] adjacents = new Coord[includeBelow ? 26 : 17];
        int index = 0;
        for (int xl = -1; xl < 1; ++xl) {
            for (int zl = -1; zl < 1; ++zl) {
                int yl;
                int n = yl = includeBelow ? -1 : 0;
                while (yl < 1) {
                    if (xl != 0 || zl != 0 || yl != 0) {
                        adjacents[index++] = new Coord(this.x + xl, this.y + yl, this.z + zl);
                    }
                    ++yl;
                }
            }
        }
        return adjacents;
    }

    public boolean isAbove(Coord pos) {
        return pos != null ? this.y > pos.y : false;
    }

    public boolean isBelow(Coord pos) {
        return pos != null ? this.y < pos.y : false;
    }

    public boolean isNorthOf(Coord pos) {
        return pos != null ? this.z < pos.z : false;
    }

    public boolean isSouthOf(Coord pos) {
        return pos != null ? this.z > pos.z : false;
    }

    public boolean isEastOf(Coord pos) {
        return pos != null ? this.x > pos.x : false;
    }

    public boolean isWestOf(Coord pos) {
        return pos != null ? this.x < pos.x : false;
    }

    public boolean isXAligned(Coord pos) {
        return pos != null ? this.x == pos.x : false;
    }

    public boolean isYAligned(Coord pos) {
        return pos != null ? this.y == pos.y : false;
    }

    public boolean isZAligned(Coord pos) {
        return pos != null ? this.z == pos.z : false;
    }

    public boolean isAirBlock(World world) {
        return WorldHelper.isAirBlock(world, this.x, this.y, this.z);
    }

    public boolean chunkExists(World world) {
        return world.func_72904_c(this.x, this.y, this.z, this.x, this.y, this.z);
    }

    public boolean isBlockNormalCube(World world) {
        return WorldHelper.isBlockNormalCube(world, this.x, this.y, this.z, false);
    }

    public boolean isBlockOpaqueCube(World world) {
        return WorldHelper.isBlockOpaqueCube(world, this.x, this.y, this.z);
    }

    public boolean isWood(World world) {
        return WorldHelper.getBlock(world, this.x, this.y, this.z).isWood((IBlockAccess)world, this.x, this.y, this.z);
    }

    public boolean isLeaves(World world) {
        return WorldHelper.getBlock(world, this.x, this.y, this.z).isLeaves((IBlockAccess)world, this.x, this.y, this.z);
    }

    public Block getBlock(World world) {
        return WorldHelper.getBlock(world, this.x, this.y, this.z);
    }

    public int getBlockMetadata(World world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public BiomeGenBase getBiomeGenBase(World world) {
        return world.func_72807_a(this.x, this.z);
    }

    public static boolean moveBlock(World world, Coord src, Coord tgt, boolean allowBlockReplacement) {
        return Coord.moveBlock(world, src, tgt, allowBlockReplacement, 3);
    }

    public static boolean moveBlock(World world, Coord src, Coord tgt, boolean allowBlockReplacement, int notifyFlag) {
        if (!world.field_72995_K && !src.isAirBlock(world) && (tgt.isAirBlock(world) || allowBlockReplacement)) {
            Block blockID = src.getBlock(world);
            int metadata = src.getBlockMetadata(world);
            WorldHelper.setBlock(world, tgt.x, tgt.y, tgt.z, blockID, metadata, notifyFlag);
            TileEntity te = WorldHelper.getBlockTileEntity(world, src.x, src.y, src.z);
            if (te != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                TileEntityHelper.writeToNBT(te, nbt);
                nbt.func_74768_a("x", tgt.x);
                nbt.func_74768_a("y", tgt.y);
                nbt.func_74768_a("z", tgt.z);
                te = WorldHelper.getBlockTileEntity(world, tgt.x, tgt.y, tgt.z);
                if (te != null) {
                    TileEntityHelper.readFromNBT(te, nbt);
                }
            }
            world.func_147468_f(src.x, src.y, src.z);
            return true;
        }
        return false;
    }

    public boolean moveBlockToHereFrom(World world, Coord src, boolean allowBlockReplacement) {
        return Coord.moveBlock(world, src, this, allowBlockReplacement);
    }

    public boolean moveBlockFromHereTo(World world, Coord tgt, boolean allowBlockReplacement) {
        return Coord.moveBlock(world, this, tgt, allowBlockReplacement);
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.z;
    }
}

