/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.bspkrscore.fml.bspkrsCoreMod;
import bspkrs.util.BSLog;
import bspkrs.util.CommonUtils;
import bspkrs.util.config.ConfigCategory;
import bspkrs.util.config.Configuration;
import com.google.common.collect.Ordering;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.StatCollector;

public class ModVersionChecker {
    private static final Map<String, ModVersionChecker> versionCheckerMap = new HashMap<String, ModVersionChecker>();
    private URL versionURL;
    private final String modID;
    private String newVersion;
    private final String currentVersion;
    private String updateURL;
    private String[] loadMsg;
    private String[] inGameMsg;
    private File trackerFile;
    private File trackerDir;
    private static Configuration versionCheckTracker;
    private final String lastNewVersionFound;
    private final String CHECK_ERROR = "check_error";
    private final boolean errorDetected;

    public ModVersionChecker(String modID, String curVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg) {
        this(modID, curVer, versionURL, updateURL, loadMsg, inGameMsg, bspkrsCoreMod.instance.updateTimeoutMilliseconds);
    }

    public ModVersionChecker(String modID, String curVer, String versionURL, String updateURL, String[] loadMsg, String[] inGameMsg, int timeoutMS) {
        this.modID = modID;
        this.currentVersion = curVer;
        this.updateURL = updateURL;
        this.loadMsg = loadMsg;
        this.inGameMsg = inGameMsg;
        try {
            this.versionURL = new URL(versionURL);
            BSLog.info("Initializing ModVersionChecker for mod %s", modID);
        }
        catch (Throwable e) {
            BSLog.warning("Error initializing ModVersionChecker for mod %s: %s", modID, e.getMessage());
        }
        String[] versionLines = CommonUtils.loadTextFromURL(this.versionURL, BSLog.INSTANCE.getLogger(), new String[]{"check_error"}, timeoutMS);
        this.newVersion = versionLines[0].trim();
        if (this.trackerDir == null) {
            this.trackerDir = new File(CommonUtils.getConfigDir() + "/bspkrsCore/");
            if (this.trackerDir.exists()) {
                this.trackerFile = new File(this.trackerDir, "ModVersionCheckerTracking.txt");
                this.trackerFile.delete();
                this.trackerDir.delete();
            }
            this.trackerDir = new File(CommonUtils.getConfigDir());
            this.trackerFile = new File(this.trackerDir, "bspkrs_ModVersionCheckerTracking.txt");
        }
        if (versionCheckTracker == null) {
            versionCheckTracker = new Configuration(this.trackerFile);
        }
        versionCheckTracker.load();
        ConfigCategory cc = versionCheckTracker.getCategory("version_check_tracker");
        if (!cc.containsKey(modID)) {
            versionCheckTracker.get("version_check_tracker", modID, curVer);
        }
        this.lastNewVersionFound = !this.newVersion.equals("check_error") && ModVersionChecker.isCurrentVersion(curVer, this.newVersion) ? this.newVersion : cc.get(modID).getString();
        if (!this.newVersion.equals("check_error")) {
            cc.get(modID).set(this.newVersion);
            this.errorDetected = false;
        } else {
            this.newVersion = this.lastNewVersionFound;
            this.errorDetected = true;
        }
        versionCheckTracker.save();
        if (versionLines.length > 1 && versionLines[1].trim().length() != 0) {
            this.updateURL = versionLines[1];
        }
        this.setLoadMessage(loadMsg);
        this.setInGameMessage(inGameMsg);
        versionCheckerMap.put(modID.toLowerCase(), this);
    }

    public ModVersionChecker(String modName, String oldVer, String versionURL, String updateURL) {
        this(modName, oldVer, versionURL, updateURL, new String[]{"{modID} {oldVer} is out of date! Visit {updateURL} to download the latest release ({newVer})."}, new String[]{"\u00a7c{modID} {newVer} \u00a7ris out! Download the latest from \u00a7a{updateURL}\u00a7r"});
    }

    public void checkVersionWithLogging() {
        if (!ModVersionChecker.isCurrentVersion(this.currentVersion, this.newVersion)) {
            for (String msg : this.loadMsg) {
                BSLog.info(msg, new Object[0]);
            }
        }
    }

    public void setLoadMessage(String[] loadMsg) {
        this.loadMsg = loadMsg;
        for (int i = 0; i < this.loadMsg.length; ++i) {
            this.loadMsg[i] = this.replaceAllTags(this.loadMsg[i]);
        }
    }

    public void setInGameMessage(String[] inGameMsg) {
        this.inGameMsg = inGameMsg;
        for (int i = 0; i < this.inGameMsg.length; ++i) {
            this.inGameMsg[i] = this.replaceAllTags(this.inGameMsg[i]);
        }
    }

    public String[] getLoadMessage() {
        return this.loadMsg;
    }

    public String[] getInGameMessage() {
        return this.inGameMsg;
    }

    public URL getVersionURL() {
        return this.versionURL;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public String getUpdateURL() {
        return this.updateURL;
    }

    public static Map<String, ModVersionChecker> getVersionCheckerMap() {
        return versionCheckerMap;
    }

    public boolean isCurrentVersion() {
        return ModVersionChecker.isCurrentVersion(this.lastNewVersionFound, this.newVersion);
    }

    public static boolean isCurrentVersion(String oldVer, String newVer) {
        return Ordering.natural().compare((Object)oldVer, (Object)newVer) >= 0;
    }

    private String replaceAllTags(String s) {
        return s.replace("{oldVer}", this.currentVersion).replace("{newVer}", this.newVersion).replace("{modID}", this.modID).replace("{updateURL}", this.updateURL);
    }

    public static String[] checkVersionForMod(String modID) {
        String[] r = new String[]{""};
        if (versionCheckerMap.containsKey(modID.toLowerCase())) {
            ModVersionChecker versionChecker = versionCheckerMap.get(modID.toLowerCase());
            r = !versionChecker.errorDetected ? (!ModVersionChecker.isCurrentVersion(versionChecker.currentVersion, versionChecker.newVersion) ? versionChecker.getInGameMessage() : new String[]{StatCollector.func_74837_a((String)"bspkrs.modversionchecker.uptodate", (Object[])new Object[]{versionChecker.modID})}) : new String[]{StatCollector.func_74837_a((String)"bspkrs.modversionchecker.error", (Object[])new Object[]{versionChecker.modID})};
        } else {
            r = new String[]{StatCollector.func_74838_a((String)"bspkrs.modversionchecker.invalidmodid")};
        }
        return r;
    }
}

