/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util.config;

import java.util.ArrayList;
import java.util.regex.Pattern;

public class Property {
    private String name;
    private String value;
    private String defaultValue;
    public String comment;
    private String[] values;
    private String[] defaultValues;
    private String[] validValues;
    private String langKey;
    private String minValue;
    private String maxValue;
    private Pattern stringPattern;
    private final boolean wasRead;
    private final boolean isList;
    private final Type type;
    private boolean changed = false;

    public Property(String name, String value, Type type) {
        this(name, value, type, false, new String[0], name);
    }

    public Property(String name, String value, Type type, boolean read) {
        this(name, value, type, read, new String[0], name);
    }

    public Property(String name, String value, Type type, String[] validValues) {
        this(name, value, type, false, validValues, name);
    }

    public Property(String name, String value, Type type, String langKey) {
        this(name, value, type, false, new String[0], langKey);
    }

    public Property(String name, String value, Type type, boolean read, String langKey) {
        this(name, value, type, read, new String[0], langKey);
    }

    public Property(String name, String value, Type type, String[] validValues, String langKey) {
        this(name, value, type, false, validValues, langKey);
    }

    Property(String name, String value, Type type, boolean read, String[] validValues, String langKey) {
        this.setName(name);
        this.value = value;
        this.values = new String[0];
        this.defaultValue = value;
        this.defaultValues = new String[0];
        this.validValues = validValues;
        this.type = type;
        this.wasRead = read;
        this.isList = false;
        this.minValue = String.valueOf(Integer.MIN_VALUE);
        this.maxValue = String.valueOf(Integer.MAX_VALUE);
        this.langKey = langKey;
        this.comment = "";
    }

    public Property(String name, String[] values, Type type) {
        this(name, values, type, false);
    }

    Property(String name, String[] values, Type type, boolean read) {
        this(name, values, type, read, new String[0], name);
    }

    public Property(String name, String[] values, Type type, String langKey) {
        this(name, values, type, false, langKey);
    }

    Property(String name, String[] values, Type type, boolean read, String langKey) {
        this(name, values, type, read, new String[0], langKey);
    }

    Property(String name, String[] values, Type type, boolean read, String[] validValues, String langKey) {
        this.setName(name);
        this.type = type;
        this.value = "";
        this.values = values;
        this.defaultValue = "";
        this.defaultValues = values;
        this.validValues = validValues;
        this.wasRead = read;
        this.isList = true;
        this.minValue = String.valueOf(Integer.MIN_VALUE);
        this.maxValue = String.valueOf(Integer.MAX_VALUE);
        this.langKey = langKey;
        this.comment = "";
    }

    public boolean isDefault() {
        if (this.isBooleanList()) {
            if (this.values.length == this.defaultValues.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (Boolean.parseBoolean(this.values[i]) == Boolean.parseBoolean(this.defaultValues[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.isIntList()) {
            if (this.values.length == this.defaultValues.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (Integer.parseInt(this.values[i]) == Integer.parseInt(this.defaultValues[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.isDoubleList()) {
            if (this.values.length == this.defaultValues.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (Double.parseDouble(this.values[i]) == Double.parseDouble(this.defaultValues[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.isList()) {
            if (this.values.length == this.defaultValues.length) {
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i].equals(this.defaultValues[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.type.equals((Object)Type.BOOLEAN) && this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value) == Boolean.parseBoolean(this.defaultValue);
        }
        if (this.type.equals((Object)Type.INTEGER) && this.isIntValue()) {
            return Integer.parseInt(this.value) == Integer.parseInt(this.defaultValue);
        }
        if (this.type.equals((Object)Type.DOUBLE) && this.isDoubleValue()) {
            return Double.parseDouble(this.value) == Double.parseDouble(this.defaultValue);
        }
        return this.value.equals(this.defaultValue);
    }

    public void setToDefault() {
        this.value = this.defaultValue;
        this.values = (String[])this.defaultValues.clone();
    }

    public String getDefault() {
        return this.defaultValue;
    }

    public String[] getDefaults() {
        return this.defaultValues;
    }

    public void setValidStringPattern(Pattern pattern) {
        this.stringPattern = pattern;
    }

    public Pattern getValidStringPattern() {
        return this.stringPattern;
    }

    public void setLanguageKey(String value) {
        this.langKey = value;
    }

    public String getLanguageKey() {
        return this.langKey;
    }

    protected void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    protected void setDefaultValue(String[] values) {
        this.defaultValues = values;
    }

    protected void setMinValue(String minValue) {
        this.minValue = minValue;
    }

    protected void setMaxValue(String maxValue) {
        this.maxValue = maxValue;
    }

    public int getMinIntValue() {
        return Integer.parseInt(this.minValue);
    }

    public int getMaxIntValue() {
        return Integer.parseInt(this.maxValue);
    }

    public double getMinDoubleValue() {
        return Double.parseDouble(this.minValue);
    }

    public double getMaxDoubleValue() {
        return Double.parseDouble(this.maxValue);
    }

    public String getString() {
        return this.value;
    }

    protected void setValidValues(String[] validValues) {
        this.validValues = validValues;
    }

    public String[] getValidValues() {
        return this.validValues;
    }

    public int getInt() {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(this.defaultValue);
        }
    }

    public int getInt(int _default) {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return _default;
        }
    }

    public boolean isIntValue() {
        try {
            Integer.parseInt(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean getBoolean(boolean _default) {
        if (this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value);
        }
        return _default;
    }

    public boolean getBoolean() {
        if (this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value);
        }
        return Boolean.parseBoolean(this.defaultValue);
    }

    public boolean isBooleanValue() {
        return "true".equals(this.value.toLowerCase()) || "false".equals(this.value.toLowerCase());
    }

    public boolean isDoubleValue() {
        try {
            Double.parseDouble(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public double getDouble(double _default) {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return _default;
        }
    }

    public double getDouble() {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return Double.parseDouble(this.defaultValue);
        }
    }

    public String[] getStringList() {
        return this.values;
    }

    public int[] getIntList() {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        for (String value : this.values) {
            try {
                nums.add(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int[] primitives = new int[nums.size()];
        for (int i = 0; i < nums.size(); ++i) {
            primitives[i] = (Integer)nums.get(i);
        }
        return primitives;
    }

    public boolean isIntList() {
        if (this.isList && this.type.equals((Object)Type.INTEGER)) {
            for (String value : this.values) {
                try {
                    Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return this.isList;
    }

    public boolean[] getBooleanList() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (String value : this.values) {
            try {
                tmp.add(Boolean.parseBoolean(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        boolean[] primitives = new boolean[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            primitives[i] = (Boolean)tmp.get(i);
        }
        return primitives;
    }

    public boolean isBooleanList() {
        if (this.isList && this.type.equals((Object)Type.BOOLEAN)) {
            for (String value : this.values) {
                if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) continue;
                return false;
            }
        }
        return this.isList;
    }

    public double[] getDoubleList() {
        ArrayList<Double> tmp = new ArrayList<Double>();
        for (String value : this.values) {
            try {
                tmp.add(Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        double[] primitives = new double[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            primitives[i] = (Double)tmp.get(i);
        }
        return primitives;
    }

    public boolean isDoubleList() {
        if (this.isList && this.type.equals((Object)Type.DOUBLE)) {
            for (String value : this.values) {
                try {
                    Double.parseDouble(value);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return this.isList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean wasRead() {
        return this.wasRead;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    void resetChangedState() {
        this.changed = false;
    }

    public void set(String value) {
        this.value = value;
        this.changed = true;
    }

    public void set(String[] values) {
        this.values = values;
        this.changed = true;
    }

    public void set(int value) {
        this.set(Integer.toString(value));
    }

    public void set(boolean value) {
        this.set(Boolean.toString(value));
    }

    public void set(double value) {
        this.set(Double.toString(value));
    }

    public static enum Type {
        STRING,
        INTEGER,
        BOOLEAN,
        DOUBLE,
        COLOR,
        ENTITY_LIST('M'),
        BLOCK_LIST('T'),
        ITEMSTACK_LIST('O'),
        DIMENSION_LIST('W'),
        BIOME_LIST('R');

        private char id;
        private static Type[] values;

        private Type() {
            this.id = this.name().charAt(0);
        }

        private Type(char id) {
            this.id = id;
        }

        public static Type tryParse(char id) {
            for (int x = 0; x < values.length; ++x) {
                if (values[x].getID() != id) continue;
                return values[x];
            }
            return STRING;
        }

        public char getID() {
            return this.id;
        }

        static {
            values = new Type[]{STRING, INTEGER, BOOLEAN, DOUBLE, COLOR, ENTITY_LIST, BLOCK_LIST, ITEMSTACK_LIST, DIMENSION_LIST, BIOME_LIST};
        }
    }
}

