/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util;

import bspkrs.helpers.block.BlockHelper;
import bspkrs.helpers.world.WorldHelper;
import bspkrs.util.CommonUtils;
import bspkrs.util.HashCodeUtil;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class BlockID {
    public final String id;
    public final int metadata;

    public BlockID(String id, int metadata) {
        this.id = id;
        this.metadata = metadata;
    }

    public BlockID(String block) {
        this(block, -1);
    }

    public BlockID(Block block, int metadata) {
        this(BlockHelper.getUniqueID(block), metadata);
    }

    public BlockID(Block block) {
        this(BlockHelper.getUniqueID(block), -1);
    }

    public BlockID(String format, String delimiter) {
        String[] parts = format.split(delimiter);
        if (parts.length > 1) {
            this.id = parts[0].trim();
            this.metadata = CommonUtils.parseInt(parts[1], -1);
        } else {
            this.id = parts[0].trim();
            this.metadata = -1;
        }
    }

    public BlockID(World world, int x, int y, int z) {
        this(world, x, y, z, world.func_72805_g(x, y, z));
    }

    public BlockID(World world, int x, int y, int z, int metadata) {
        this(WorldHelper.getBlock(world, x, y, z), metadata);
    }

    public boolean isValid() {
        return this.getBlock() != null;
    }

    public Block getBlock() {
        return BlockHelper.getBlock(this.id);
    }

    public BlockID clone() {
        return new BlockID(this.id, this.metadata);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockID)) {
            return false;
        }
        BlockID o = (BlockID)obj;
        if (o.metadata == -1 || this.metadata == -1) {
            return this.id.equals(o.id);
        }
        return this.id.equals(o.id) && this.metadata == o.metadata;
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash(result, this.id);
        result = HashCodeUtil.hash(result, this.metadata);
        return result;
    }

    public String toString() {
        return this.metadata == -1 ? this.id + "" : this.id + ", " + this.metadata;
    }
}

