/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util.config;

import bspkrs.util.config.ConfigCategory;
import bspkrs.util.config.Property;
import bspkrs.util.config.gui.ConfigGuiType;
import bspkrs.util.config.gui.IConfigProperty;
import java.util.Iterator;
import java.util.regex.Pattern;

public class ConfigProperty
implements IConfigProperty {
    private Property prop;
    private Property.Type type;
    private boolean isProperty;
    private ConfigCategory ctgy;

    public ConfigProperty(ConfigCategory ctgy) {
        this.ctgy = ctgy;
        this.isProperty = false;
    }

    public ConfigProperty(Property prop) {
        this(prop, prop.getType());
    }

    public ConfigProperty(Property prop, Property.Type type) {
        this.prop = prop;
        this.type = type;
        this.isProperty = true;
    }

    @Override
    public IConfigProperty[] getConfigProperties() {
        if (!this.isProperty) {
            IConfigProperty[] props = new ConfigProperty[this.ctgy.getValues().size() + this.ctgy.getChildren().size()];
            Iterator<ConfigCategory> ccI = this.ctgy.getChildren().iterator();
            Iterator<Property> pI = this.ctgy.getValues().values().iterator();
            int index = 0;
            while (ccI.hasNext()) {
                props[index++] = new ConfigProperty(ccI.next());
            }
            while (pI.hasNext()) {
                props[index++] = new ConfigProperty(pI.next());
            }
            return props;
        }
        return new IConfigProperty[0];
    }

    @Override
    public String getName() {
        if (this.isProperty) {
            return this.prop.getName();
        }
        return this.ctgy.getName();
    }

    @Override
    public boolean isProperty() {
        return this.isProperty;
    }

    @Override
    public String getQualifiedName() {
        if (this.isProperty) {
            return this.prop.getName();
        }
        return this.ctgy.getQualifiedName();
    }

    @Override
    public ConfigGuiType getType() {
        if (this.isProperty) {
            if (this.type.equals((Object)Property.Type.BOOLEAN)) {
                return ConfigGuiType.BOOLEAN;
            }
            if (this.type.equals((Object)Property.Type.DOUBLE)) {
                return ConfigGuiType.DOUBLE;
            }
            if (this.type.equals((Object)Property.Type.INTEGER)) {
                return ConfigGuiType.INTEGER;
            }
            if (this.type.equals((Object)Property.Type.COLOR)) {
                return ConfigGuiType.COLOR;
            }
            if (this.type.equals((Object)Property.Type.BLOCK_LIST)) {
                return ConfigGuiType.BLOCK_LIST;
            }
            if (this.type.equals((Object)Property.Type.ITEMSTACK_LIST)) {
                return ConfigGuiType.ITEMSTACK_LIST;
            }
            if (this.type.equals((Object)Property.Type.ENTITY_LIST)) {
                return ConfigGuiType.ENTITY_LIST;
            }
            if (this.type.equals((Object)Property.Type.BIOME_LIST)) {
                return ConfigGuiType.BIOME_LIST;
            }
            if (this.type.equals((Object)Property.Type.DIMENSION_LIST)) {
                return ConfigGuiType.DIMENSION_LIST;
            }
            return ConfigGuiType.STRING;
        }
        return ConfigGuiType.CONFIG_CATEGORY;
    }

    @Override
    public String getComment() {
        if (this.isProperty) {
            return this.prop.comment;
        }
        return this.ctgy.getComment();
    }

    @Override
    public boolean isDefault() {
        if (this.isProperty) {
            return this.prop.isDefault();
        }
        return true;
    }

    @Override
    public void setToDefault() {
        if (this.isProperty) {
            this.prop.setToDefault();
        }
    }

    @Override
    public boolean getBoolean() {
        if (this.isProperty) {
            return this.prop.getBoolean();
        }
        return false;
    }

    @Override
    public int getInt() {
        if (this.isProperty) {
            return this.prop.getInt();
        }
        return 0;
    }

    @Override
    public String getString() {
        if (this.isProperty) {
            return this.prop.getString();
        }
        return this.ctgy.getQualifiedName();
    }

    @Override
    public double getDouble() {
        if (this.isProperty) {
            return this.prop.getDouble();
        }
        return 0.0;
    }

    @Override
    public void set(boolean bol) {
        if (this.isProperty) {
            this.prop.set(bol);
        }
    }

    @Override
    public void set(int i) {
        if (this.isProperty) {
            this.prop.set(i);
        }
    }

    @Override
    public void set(String s) {
        if (this.isProperty) {
            this.prop.set(s);
        }
    }

    @Override
    public void set(double d) {
        if (this.isProperty) {
            this.prop.set(d);
        }
    }

    @Override
    public String[] getValidValues() {
        if (this.isProperty) {
            return this.prop.getValidValues();
        }
        return new String[0];
    }

    @Override
    public String getLanguageKey() {
        if (this.isProperty) {
            return this.prop.getLanguageKey();
        }
        return this.ctgy.getLanguagekey();
    }

    @Override
    public String getDefault() {
        if (this.isProperty) {
            return this.prop.getDefault();
        }
        return "";
    }

    @Override
    public int getMinIntValue() {
        if (this.isProperty) {
            return this.prop.getMinIntValue();
        }
        return 0;
    }

    @Override
    public int getMaxIntValue() {
        if (this.isProperty) {
            return this.prop.getMaxIntValue();
        }
        return 0;
    }

    @Override
    public double getMinDoubleValue() {
        if (this.isProperty) {
            return this.prop.getMinDoubleValue();
        }
        return 0.0;
    }

    @Override
    public double getMaxDoubleValue() {
        if (this.isProperty) {
            return this.prop.getMaxDoubleValue();
        }
        return 0.0;
    }

    @Override
    public Pattern getValidStringPattern() {
        return this.prop.getValidStringPattern();
    }
}

