/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.util.config.gui;

import bspkrs.util.CommonUtils;
import bspkrs.util.config.gui.ConfigGuiType;
import bspkrs.util.config.gui.GuiConfig;
import bspkrs.util.config.gui.IConfigProperty;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;

@SideOnly(value=Side.CLIENT)
public class GuiPropertyList
extends GuiListExtended {
    private final GuiConfig parentGuiConfig;
    private final Minecraft mc;
    private final IGuiConfigListEntry[] listEntries;
    private int maxLabelTextWidth = 0;
    private final int labelX;
    private final int controlX;
    private final int controlWidth;
    private final int resetX;
    private final int scrollBarX;

    public GuiPropertyList(GuiConfig parent, Minecraft mc) {
        super(mc, parent.field_146294_l, parent.field_146295_m, parent.titleSuffix != null ? 33 : 23, parent.field_146295_m - 32, 20);
        this.parentGuiConfig = parent;
        this.func_148130_a(false);
        this.mc = mc;
        this.listEntries = new IGuiConfigListEntry[parent.properties.length];
        int i = 0;
        Object s = null;
        for (IConfigProperty prop : parent.properties) {
            int l;
            if (prop == null) continue;
            if (prop.isProperty() && (l = mc.field_71466_p.func_78256_a(I18n.func_135052_a((String)prop.getLanguageKey(), (Object[])new Object[0]))) > this.maxLabelTextWidth) {
                this.maxLabelTextWidth = l;
            }
            if (prop.getType().equals((Object)ConfigGuiType.BOOLEAN)) {
                this.listEntries[i++] = new BooleanPropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.INTEGER)) {
                this.listEntries[i++] = new IntegerPropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.DOUBLE)) {
                this.listEntries[i++] = new DoublePropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.COLOR)) {
                if (prop.getValidValues().length > 0) {
                    this.listEntries[i++] = new ColorPropEntry(prop);
                    continue;
                }
                this.listEntries[i++] = new StringPropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.BLOCK_LIST)) {
                this.listEntries[i++] = new StringPropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.ITEMSTACK_LIST)) {
                this.listEntries[i++] = new StringPropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.ENTITY_LIST)) {
                this.listEntries[i++] = new StringPropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.BIOME_LIST)) {
                this.listEntries[i++] = new StringPropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.DIMENSION_LIST)) {
                this.listEntries[i++] = new StringPropEntry(prop);
                continue;
            }
            if (prop.getType().equals((Object)ConfigGuiType.STRING)) {
                if (prop.getValidValues().length > 0) {
                    this.listEntries[i++] = new SelectStringPropEntry(prop);
                    continue;
                }
                this.listEntries[i++] = new StringPropEntry(prop);
                continue;
            }
            if (!prop.getType().equals((Object)ConfigGuiType.CONFIG_CATEGORY)) continue;
            this.listEntries[i++] = new GuiConfigCategoryListEntry(prop);
        }
        int viewWidth = this.maxLabelTextWidth + 8 + this.field_148155_a / 2;
        this.labelX = this.field_148155_a / 2 - viewWidth / 2;
        this.controlX = this.labelX + this.maxLabelTextWidth + 8;
        this.resetX = this.field_148155_a / 2 + viewWidth / 2 - 45;
        this.controlWidth = this.resetX - this.controlX - 5;
        this.scrollBarX = this.resetX + 45;
    }

    protected int func_148127_b() {
        return this.listEntries.length;
    }

    public IGuiConfigListEntry getListEntry(int index) {
        return this.listEntries[index];
    }

    protected int func_148137_d() {
        return this.scrollBarX;
    }

    public int func_148139_c() {
        return this.parentGuiConfig.field_146294_l;
    }

    protected void keyTyped(char eventChar, int eventKey) {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            this.listEntries[i].keyTyped(eventChar, eventKey);
        }
    }

    protected void mouseClicked(int x, int y, int mouseEvent) {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            this.listEntries[i].mouseClicked(x, y, mouseEvent);
        }
    }

    protected void saveProperties() {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            this.listEntries[i].saveProperty();
        }
    }

    protected boolean areAllPropsDefault() {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            if (this.listEntries[i].isDefault()) continue;
            return false;
        }
        return true;
    }

    protected void setAllPropsDefault() {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            this.listEntries[i].setToDefault();
        }
    }

    protected void drawScreenPost(int mouseX, int mouseY, float f) {
        for (int i = 0; i < this.func_148127_b(); ++i) {
            this.listEntries[i].drawToolTip(mouseX, mouseY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static interface IGuiConfigListEntry
    extends GuiListExtended.IGuiListEntry {
        public void keyTyped(char var1, int var2);

        public void updateCursorCounter();

        public void mouseClicked(int var1, int var2, int var3);

        public boolean isDefault();

        public void setToDefault();

        public void saveProperty();

        public void drawToolTip(int var1, int var2);
    }

    @SideOnly(value=Side.CLIENT)
    public class GuiConfigCategoryListEntry
    implements IGuiConfigListEntry {
        protected final IConfigProperty prop;
        protected final String propName;
        protected final GuiButton btnSelectCategory;
        private long hoverStart = -1L;
        private List toolTip;
        private int x;
        private int y;
        private int listWidth;
        private int slotHeight;

        public GuiConfigCategoryListEntry(IConfigProperty prop) {
            this.prop = prop;
            this.propName = I18n.func_135052_a((String)prop.getLanguageKey(), (Object[])new Object[0]).equals(prop.getLanguageKey()) ? I18n.func_135052_a((String)prop.getName(), (Object[])new Object[0]) : I18n.func_135052_a((String)prop.getLanguageKey(), (Object[])new Object[0]);
            this.btnSelectCategory = new GuiButton(0, 0, 0, 200, 18, I18n.func_135052_a((String)this.propName, (Object[])new Object[0]));
            String comment = I18n.func_135052_a((String)(prop.getLanguageKey() + ".tooltip"), (Object[])new Object[0]);
            this.toolTip = !comment.equals(prop.getLanguageKey() + ".tooltip") ? ((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.YELLOW + comment, 300) : (prop.getComment() != null && !prop.getComment().trim().isEmpty() ? ((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.YELLOW + prop.getComment(), 300) : ((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.RED + "No tooltip defined.", 300));
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            this.btnSelectCategory.field_146128_h = listWidth / 2 - 100;
            this.btnSelectCategory.field_146129_i = y;
            this.btnSelectCategory.func_146112_a(GuiPropertyList.this.mc, mouseX, mouseY);
            this.x = listWidth / 2 - 150;
            this.y = y;
            this.listWidth = listWidth;
            this.slotHeight = slotHeight;
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            if (this.toolTip != null) {
                int bottom = this.y + this.slotHeight;
                int right = this.listWidth / 2 + 150;
                if (this.hoverStart == -1L && mouseY >= this.y && mouseY <= bottom && mouseX >= this.x && mouseX <= right && mouseY < GuiPropertyList.this.field_148154_c && mouseY > GuiPropertyList.this.field_148153_b) {
                    this.hoverStart = System.currentTimeMillis();
                } else if (mouseY < this.y || mouseY > bottom || mouseX < this.x || mouseX > right) {
                    this.hoverStart = -1L;
                }
                if (this.hoverStart != -1L && System.currentTimeMillis() - this.hoverStart >= 800L) {
                    GuiPropertyList.this.parentGuiConfig.drawToolTip(this.toolTip, mouseX, mouseY);
                }
            }
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnSelectCategory.func_146116_c(GuiPropertyList.this.mc, x, y)) {
                GuiConfig subCatGui = new GuiConfig(GuiPropertyList.this.parentGuiConfig, this.prop.getConfigProperties(), null, ((GuiPropertyList)GuiPropertyList.this).parentGuiConfig.configObject, null, null, this.prop.getQualifiedName());
                Minecraft.func_71410_x().func_147108_a((GuiScreen)subCatGui);
                return true;
            }
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnSelectCategory.func_146118_a(x, y);
        }

        @Override
        public boolean isDefault() {
            return this.prop.isDefault();
        }

        @Override
        public void setToDefault() {
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public void saveProperty() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract class GuiConfigListEntry
    implements IGuiConfigListEntry {
        protected final IConfigProperty prop;
        protected final String propName;
        protected final GuiButton btnDefault;
        private long hoverStart = -1L;
        private List toolTip;
        private int x;
        private int y;
        private int listWidth;
        private int slotHeight;
        protected boolean isValidValue = true;

        public GuiConfigListEntry(IConfigProperty prop) {
            this.prop = prop;
            this.propName = I18n.func_135052_a((String)prop.getLanguageKey(), (Object[])new Object[0]);
            this.btnDefault = new GuiButton(0, 0, 0, 40, 18, I18n.func_135052_a((String)"controls.reset", (Object[])new Object[0]));
            String comment = prop.getType().equals(Integer.TYPE) ? I18n.func_135052_a((String)(prop.getLanguageKey() + ".tooltip"), (Object[])new Object[]{"\n" + EnumChatFormatting.AQUA, prop.getDefault(), prop.getMinIntValue(), prop.getMaxIntValue()}) : I18n.func_135052_a((String)(prop.getLanguageKey() + ".tooltip"), (Object[])new Object[]{"\n" + EnumChatFormatting.AQUA, prop.getDefault(), prop.getMinDoubleValue(), prop.getMaxDoubleValue()});
            this.toolTip = !comment.equals(prop.getLanguageKey() + ".tooltip") ? ((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.YELLOW + comment, 300) : (prop.getComment() != null && !prop.getComment().trim().isEmpty() ? ((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.YELLOW + prop.getComment(), 300) : ((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p.func_78271_c(EnumChatFormatting.GREEN + this.propName + "\n" + EnumChatFormatting.RED + "No tooltip defined.", 300));
        }

        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            ((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p.func_78276_b(this.isValidValue ? this.propName : EnumChatFormatting.RED + this.propName, GuiPropertyList.this.labelX, y + slotHeight / 2 - ((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p.field_78288_b / 2, 0xFFFFFF);
            this.btnDefault.field_146128_h = GuiPropertyList.this.resetX;
            this.btnDefault.field_146129_i = y;
            this.btnDefault.field_146124_l = !this.isDefault();
            this.btnDefault.func_146112_a(GuiPropertyList.this.mc, mouseX, mouseY);
            this.x = x;
            this.y = y;
            this.listWidth = listWidth;
            this.slotHeight = slotHeight;
        }

        @Override
        public void drawToolTip(int mouseX, int mouseY) {
            if (this.toolTip != null) {
                int bottom = this.y + this.slotHeight;
                int right = GuiPropertyList.this.controlX - 8;
                if (this.hoverStart == -1L && mouseY >= this.y && mouseY <= bottom && mouseX >= this.x && mouseX <= right && mouseY < GuiPropertyList.this.field_148154_c && mouseY > GuiPropertyList.this.field_148153_b) {
                    this.hoverStart = System.currentTimeMillis();
                } else if (mouseY < this.y || mouseY > bottom || mouseX < this.x || mouseX > right || mouseY >= GuiPropertyList.this.field_148154_c || mouseY <= GuiPropertyList.this.field_148153_b) {
                    this.hoverStart = -1L;
                }
                if (this.hoverStart != -1L && System.currentTimeMillis() - this.hoverStart >= 800L) {
                    GuiPropertyList.this.parentGuiConfig.drawToolTip(this.toolTip, mouseX, mouseY);
                }
            }
        }

        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnDefault.func_146116_c(GuiPropertyList.this.mc, x, y)) {
                this.setToDefault();
                return true;
            }
            return false;
        }

        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            this.btnDefault.func_146118_a(x, y);
        }

        @Override
        public boolean isDefault() {
            return this.prop.isDefault();
        }

        @Override
        public void setToDefault() {
            this.prop.setToDefault();
        }

        @Override
        public abstract void keyTyped(char var1, int var2);

        @Override
        public abstract void updateCursorCounter();

        @Override
        public abstract void mouseClicked(int var1, int var2, int var3);

        @Override
        public abstract void saveProperty();
    }

    @SideOnly(value=Side.CLIENT)
    public class StringPropEntry
    extends GuiConfigListEntry {
        protected final GuiTextField textFieldValue;

        private StringPropEntry(IConfigProperty prop) {
            super(prop);
            int listWidth = GuiPropertyList.this.func_148139_c();
            this.textFieldValue = new GuiTextField(((GuiPropertyList)GuiPropertyList.this).mc.field_71466_p, 0, 0, 196, 16);
            this.textFieldValue.func_146203_f(10000);
            this.textFieldValue.func_146180_a(prop.getString());
        }

        @Override
        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            super.func_148279_a(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected);
            try {
                Field controlWidth;
                Field yPos;
                Field xPos;
                if (CommonUtils.isObfuscatedEnv()) {
                    xPos = GuiTextField.class.getDeclaredField("field_146209_f");
                    yPos = GuiTextField.class.getDeclaredField("field_146210_g");
                    controlWidth = GuiTextField.class.getDeclaredField("field_146218_h");
                } else {
                    xPos = GuiTextField.class.getDeclaredField("xPosition");
                    yPos = GuiTextField.class.getDeclaredField("yPosition");
                    controlWidth = GuiTextField.class.getDeclaredField("width");
                }
                xPos.setAccessible(true);
                xPos.setInt(this.textFieldValue, GuiPropertyList.this.controlX + 1);
                yPos.setAccessible(true);
                yPos.setInt(this.textFieldValue, y + 1);
                controlWidth.setAccessible(true);
                controlWidth.setInt(this.textFieldValue, GuiPropertyList.this.controlWidth - 3);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.textFieldValue.func_146194_f();
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            this.textFieldValue.func_146201_a(eventChar, eventKey);
            if (this.prop.getValidStringPattern() != null) {
                this.isValidValue = this.prop.getValidStringPattern().matcher(this.textFieldValue.func_146179_b().trim()).matches();
            }
        }

        @Override
        public void updateCursorCounter() {
            this.textFieldValue.func_146178_a();
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
            this.textFieldValue.func_146192_a(x, y, mouseEvent);
        }

        @Override
        public boolean isDefault() {
            return this.prop.getDefault().trim().equals(this.textFieldValue.func_146179_b().trim());
        }

        @Override
        public void setToDefault() {
            this.textFieldValue.func_146180_a(this.prop.getDefault());
            this.keyTyped('\u0000', 207);
        }

        @Override
        public void saveProperty() {
            if (this.textFieldValue.func_146179_b().trim().length() > 0) {
                this.prop.set(this.textFieldValue.func_146179_b().trim());
            } else {
                this.prop.setToDefault();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class DoublePropEntry
    extends StringPropEntry {
        private DoublePropEntry(IConfigProperty prop) {
            super(prop);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block6: {
                String validChars = "0123456789";
                String before = this.textFieldValue.func_146179_b();
                if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || !before.contains(".") && eventChar == '.' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    this.textFieldValue.func_146201_a(eventChar, eventKey);
                }
                if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                    try {
                        double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                        if (value < this.prop.getMinDoubleValue() || value > this.prop.getMaxDoubleValue()) {
                            this.isValidValue = false;
                            break block6;
                        }
                        this.isValidValue = true;
                    }
                    catch (Throwable e) {
                        this.isValidValue = false;
                    }
                } else {
                    this.isValidValue = false;
                }
            }
        }

        @Override
        public void saveProperty() {
            try {
                double value = Double.parseDouble(this.textFieldValue.func_146179_b().trim());
                if (value >= this.prop.getMinDoubleValue() && value <= this.prop.getMaxDoubleValue()) {
                    this.prop.set(value);
                } else {
                    this.prop.setToDefault();
                }
            }
            catch (Throwable e) {
                this.prop.setToDefault();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class IntegerPropEntry
    extends StringPropEntry {
        private IntegerPropEntry(IConfigProperty prop) {
            super(prop);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
            block6: {
                String validChars = "0123456789";
                String before = this.textFieldValue.func_146179_b();
                if (validChars.contains(String.valueOf(eventChar)) || !before.startsWith("-") && this.textFieldValue.func_146198_h() == 0 && eventChar == '-' || eventKey == 14 || eventKey == 211 || eventKey == 203 || eventKey == 205 || eventKey == 199 || eventKey == 207) {
                    this.textFieldValue.func_146201_a(eventChar, eventKey);
                }
                if (!this.textFieldValue.func_146179_b().trim().isEmpty() && !this.textFieldValue.func_146179_b().trim().equals("-")) {
                    try {
                        long value = Long.parseLong(this.textFieldValue.func_146179_b().trim());
                        if (value < (long)this.prop.getMinIntValue() || value > (long)this.prop.getMaxIntValue()) {
                            this.isValidValue = false;
                            break block6;
                        }
                        this.isValidValue = true;
                    }
                    catch (Throwable e) {
                        this.isValidValue = false;
                    }
                } else {
                    this.isValidValue = false;
                }
            }
        }

        @Override
        public void saveProperty() {
            try {
                int value = Integer.parseInt(this.textFieldValue.func_146179_b().trim());
                if (value >= this.prop.getMinIntValue() && value <= this.prop.getMaxIntValue()) {
                    this.prop.set(value);
                } else {
                    this.prop.setToDefault();
                }
            }
            catch (Throwable e) {
                this.prop.setToDefault();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public abstract class ButtonPropEntry
    extends GuiConfigListEntry {
        protected final GuiButton btnValue;

        private ButtonPropEntry(IConfigProperty prop) {
            super(prop);
            int listWidth = GuiPropertyList.this.func_148139_c();
            this.btnValue = new GuiButton(0, 0, 0, 160, 18, I18n.func_135052_a((String)prop.getString(), (Object[])new Object[0]));
        }

        public abstract void updateValueButtonText();

        public abstract void valueButtonPressed();

        @Override
        public void func_148279_a(int slotIndex, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean isSelected) {
            super.func_148279_a(slotIndex, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, isSelected);
            try {
                Field buttonWidth = CommonUtils.isObfuscatedEnv() ? GuiButton.class.getDeclaredField("field_146120_f") : GuiButton.class.getDeclaredField("width");
                buttonWidth.setAccessible(true);
                buttonWidth.setInt(this.btnValue, GuiPropertyList.this.controlWidth);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.btnValue.field_146128_h = GuiPropertyList.this.controlX;
            this.btnValue.field_146129_i = y;
            this.updateValueButtonText();
            this.btnValue.func_146112_a(GuiPropertyList.this.mc, mouseX, mouseY);
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.btnValue.func_146116_c(GuiPropertyList.this.mc, x, y)) {
                this.valueButtonPressed();
                return true;
            }
            return super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY);
        }

        @Override
        public void func_148277_b(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            super.func_148277_b(index, x, y, mouseEvent, relativeX, relativeY);
            this.btnValue.func_146118_a(x, y);
        }

        @Override
        public void keyTyped(char eventChar, int eventKey) {
        }

        @Override
        public void updateCursorCounter() {
        }

        @Override
        public void mouseClicked(int x, int y, int mouseEvent) {
        }

        @Override
        public void saveProperty() {
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ColorPropEntry
    extends SelectStringPropEntry {
        ColorPropEntry(IConfigProperty prop) {
            super(prop);
        }

        @Override
        public void func_148279_a(int p_148279_1_, int x, int y, int listWidth, int slotHeight, Tessellator tessellator, int mouseX, int mouseY, boolean p_148279_9_) {
            this.btnValue.packedFGColour = CommonUtils.getColorCode(this.prop.getString().charAt(0), true);
            super.func_148279_a(p_148279_1_, x, y, listWidth, slotHeight, tessellator, mouseX, mouseY, p_148279_9_);
        }

        @Override
        public void updateValueButtonText() {
            String trans = I18n.func_135052_a((String)String.valueOf(this.prop.getString()), (Object[])new Object[0]);
            this.btnValue.field_146126_j = !trans.equals(this.prop.getString()) ? trans + " - Sample Text" : this.prop.getString() + " - Sample Text";
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class SelectStringPropEntry
    extends ButtonPropEntry {
        private int index;

        private SelectStringPropEntry(IConfigProperty prop) {
            super(prop);
            this.resetIndex();
        }

        private void resetIndex() {
            for (int i = 0; i < this.prop.getValidValues().length; ++i) {
                if (!this.prop.getValidValues()[i].equalsIgnoreCase(this.prop.getString())) continue;
                this.index = i;
                break;
            }
        }

        @Override
        public boolean func_148278_a(int index, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (super.func_148278_a(index, x, y, mouseEvent, relativeX, relativeY)) {
                this.resetIndex();
                return true;
            }
            return false;
        }

        @Override
        public void updateValueButtonText() {
            String trans = I18n.func_135052_a((String)String.valueOf(this.prop.getString()), (Object[])new Object[0]);
            this.btnValue.field_146126_j = !trans.equals(this.prop.getString()) ? trans : this.prop.getString();
        }

        @Override
        public void valueButtonPressed() {
            if (++this.index >= this.prop.getValidValues().length) {
                this.index = 0;
            }
            this.prop.set(this.prop.getValidValues()[this.index]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class BooleanPropEntry
    extends ButtonPropEntry {
        private BooleanPropEntry(IConfigProperty prop) {
            super(prop);
        }

        @Override
        public void updateValueButtonText() {
            String trans = I18n.func_135052_a((String)String.valueOf(this.prop.getString()), (Object[])new Object[0]);
            this.btnValue.field_146126_j = !trans.equals(this.prop.getString()) ? trans : this.prop.getString();
            this.btnValue.packedFGColour = this.prop.getBoolean() ? CommonUtils.getColorCode('2', true) : CommonUtils.getColorCode('4', true);
        }

        @Override
        public void valueButtonPressed() {
            this.prop.set(!this.prop.getBoolean());
        }
    }
}

