/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.BlockTree;
import bspkrs.treecapitator.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public final class TreeCapitator {
    public static final String VERSION_NUMBER = "1.5.2.r01";
    public static final String LOGS = "logs";
    public static final String LEAVES = "leaves";
    public static final String MOD_ID = "modID";
    public static final String CONFIG_PATH = "configPath";
    public static final String BLOCK_VALUES = "blockValues";
    public static final String ITEM_VALUES = "itemValues";
    public static final String SHIFT_INDEX = "useShiftedItemID";
    public static final String IDR_MOD_ID = "idResolverModID";
    public static final String remoteTreeConfigURLDesc = "Incomplete - do not use";
    public static String remoteTreeConfigURL = "http://bspk.rs/Minecraft/1.5.1/treeCapitatorTreeConfig.txt";
    public static final String remoteBlockIDConfigDesc = "Incomplete - do not use";
    public static String remoteBlockIDConfig = "";
    public static final String localBlockIDListDesc = "Automatically generated:";
    public static String localBlockIDList = "";
    public static final String useRemoteTreeConfigDesc = "Incomplete - do not use";
    public static boolean useRemoteTreeConfig = false;
    public static final String allowGetRemoteTreeConfigDesc = "Incomplete - do not use";
    public static boolean allowGetRemoteTreeConfig = false;
    public static final String enableEnchantmentModeDesc = "Toggle for whether or not to use the Treecapitating enchantment instead of only requiring an item to be in the axeIDList to chop a tree.";
    public static boolean enableEnchantmentMode = false;
    public static final String requireItemInAxeListForEnchantDesc = "Whether or not to check axeIDList for an item when determining if a given item can be imbued with the Treecapitating enchantment.\nNOTE: when set to false, any ItemTool type item (pickaxes, shovels, etc) with a high enough enchantability level can get the enchantment, not just axes.";
    public static boolean requireItemInAxeListForEnchant = false;
    public static final String axeIDListDesc = "IDs of items that can chop down trees. Use ',' to split item id from metadata and ';' to split items.";
    public static String axeIDList = wk.v.cp + "; " + wk.z.cp + "; " + wk.i.cp + "; " + wk.K.cp + "; " + wk.D.cp;
    public static final String needItemDesc = "Whether you need an item from the axeIDList to chop down a tree. Disabling will let you chop trees with any item.";
    public static boolean needItem = true;
    public static final String onlyDestroyUpwardsDesc = "Setting this to false will allow the chopping to move downward as well as upward (and blocks below the one you break will be chopped)";
    public static boolean onlyDestroyUpwards = true;
    public static final String destroyLeavesDesc = "Enabling this will make leaves be destroyed when trees are chopped.";
    public static boolean destroyLeaves = true;
    public static final String requireLeafDecayCheckDesc = "When true TreeCapitator will only instantly decay leaves that have actually been marked for decay.\nSet to false if you want leaves to be destroyed regardless of their decay status (hint: or for \"leaf\" blocks that are not really leaves).";
    public static boolean requireLeafDecayCheck = true;
    public static final String shearLeavesDesc = "Enabling this will cause destroyed leaves to be sheared when a shearing item is in the hotbar (ignored if destroyLeaves is false).";
    public static boolean shearLeaves = false;
    public static final String shearVinesDesc = "Enabling this will shear /some/ of the vines on a tree when a shearing item is in the hotbar (ignored if destroyLeaves is false).";
    public static boolean shearVines = false;
    public static final String shearIDListDesc = "IDs of items that when placed in the hotbar will allow leaves to be sheared when shearLeaves is true.\nUse ',' to split item id from metadata and ';' to split items.";
    public static String shearIDList = wk.bf.cp + "";
    public static final String logHardnessNormalDesc = "The hardness of logs for when you are using items that won't chop down the trees.";
    public static float logHardnessNormal = 2.0f;
    public static final String logHardnessModifiedDesc = "The hardness of logs for when you are using items that can chop down trees.";
    public static float logHardnessModified = 4.0f;
    public static final String disableInCreativeDesc = "Flag to disable tree chopping in Creative mode";
    public static boolean disableInCreative = false;
    public static final String disableCreativeDropsDesc = "Flag to disable drops in Creative mode";
    public static boolean disableCreativeDrops = false;
    public static final String allowItemDamageDesc = "Enable to cause item damage based on number of blocks destroyed";
    public static boolean allowItemDamage = true;
    public static final String allowMoreBlocksThanDamageDesc = "Enable to allow chopping down the entire tree even if your item does not have enough damage remaining to cover the number of blocks.";
    public static boolean allowMoreBlocksThanDamage = false;
    public static final String damageMultiplierDesc = "Axes and shears will take damage this many times for each log broken.\nRemaining damage is rounded and applied to tools when a tree is finished.";
    public static float damageMultiplier = 1.0f;
    public static final String useIncreasingItemDamageDesc = "Set to true to have the per-block item damage amount increase after every increaseDamageEveryXBlocks blocks are broken.";
    public static boolean useIncreasingItemDamage = false;
    public static final String increaseDamageEveryXBlocksDesc = "When useIncreasingItemDamage=true the damage applied per block broken will increase each time this many blocks are broken in a tree.";
    public static int increaseDamageEveryXBlocks = 15;
    public static final String damageIncreaseAmountDesc = "When useIncreasingItemDamage=true the damage applied per block broken will increase by this amount every increaseDamageEveryXBlocks blocks broken in a tree.";
    public static float damageIncreaseAmount = 1.0f;
    public static final String sneakActionDesc = "Set sneakAction = \"disable\" to disable tree chopping while sneaking,\nset sneakAction = \"enable\" to only enable tree chopping while sneaking,\nset sneakAction = \"none\" to have tree chopping enabled regardless of sneaking.";
    public static String sneakAction = "disable";
    public static final String maxBreakDistanceDesc = "The maximum horizontal distance that the log breaking effect will travel (use -1 for no limit).";
    public static int maxBreakDistance = 16;
    public static final String allowSmartTreeDetectionDesc = "Set to false to disable TreeCapitator Smart Tree Detection.\nSmart Tree Detection counts the number of leaf blocks that are adjacent to the\ntop-most connected log block at the x, z location of a log you've broken. If\nthere are at least minLeavesToID leaf blocks within maxLeafIDDist blocks then\nTreeCapitator considers it a tree and allows chopping.\nWARNING: Disabling Smart Tree Detection will remove the only safeguard against\naccidentally destroying a log structure.  Make sure you know what you're doing!";
    public static boolean allowSmartTreeDetection = true;
    public static final String maxLeafIDDistDesc = "If a tree's top log is not close enough to leaf blocks, the tree will not be chopped.\nIncreasing this value will search further.  I would try to keep it below 3.";
    public static int maxLeafIDDist = 1;
    public static final String maxLeafBreakDistDesc = "The maximum distance to instantly decay leaves from any log block that is removed by TreeCapitator.";
    public static int maxLeafBreakDist = 4;
    public static final String minLeavesToIDDesc = "The minimum number of leaves within maxLeafIDDist of the top log block required to identify a tree.";
    public static int minLeavesToID = 3;
    public static final String useStrictBlockPairingDesc = "Set to true if you want only the leaf blocks listed with each log in blockIDList\nto break when that log type is chopped.  When set to false it will break\nany leaf type within range of the tree, not just the type for that tree.";
    public static boolean useStrictBlockPairing = false;
    public static final String allowDebugOutputDesc = "Set to true if you want TreeCapitator to tell you what kind of block you have clicked when sneaking, false to disable.";
    public static boolean allowDebugOutput = false;
    public static final String allowDebugLoggingDesc = "Set to true if you want TreeCapitator to log info about what it's doing, false to disable";
    public static boolean allowDebugLogging = false;
    public static boolean isForge = false;
    public static apa wood;
    public static ArrayList logIDList;
    public static ArrayList leafIDList;
    public static Map logToLeafListMap;
    public static Map logToLogListMap;
    public static Map configBlockList;
    public static Map thirdPartyConfig;
    public static Map tagMap;
    public static ArrayList blocksBeingChopped;
    public static final String configBlockIDDesc = "Add the log and leaf block IDs for all trees you want to be able to chop down.\nEach section below represents a type of tree.  Each list may contain block IDs\nand/or third-party config replacement tags. You can change it to be more or\nless granular as long as all sections follow the basic structure.  Do not use\nspaces or periods in your section names.  Otherwise you can call them anything\nyou like.\n\nEACH LOG ID MAY ONLY APPEAR IN EXACTLY ONE SECTION.\n\nNOTE: Some mod trees use vanilla log blocks as well as custom blocks.  If a tree\ncontains more than 1 type of log, all logs must be included in the same section.\nExamples of this are the default entries for vanilla_ebxl_oaks and vanilla_ebxl_spruces.\n\nSimple Example (all logs and leaves are grouped in one section, no metadata is specified):\n    trees {\n        S:leaves=18; <Forestry.leaves>; <ExtrabiomesXL.autumnleaves.id>; <ExtrabiomesXL.greenleaves.id>\n        S:logs=17; <Forestry.log1>; <Forestry.log2>; <Forestry.log3>; <Forestry.log4>; <ExtrabiomesXL.customlog.id>; <ExtrabiomesXL.quarterlog0.id>; <ExtrabiomesXL.quarterlog1.id>; <ExtrabiomesXL.quarterlog2.id>;<ExtrabiomesXL.quarterlog3.id>\n    }\n\nAdvanced Example (each mod tree has its own section, metadata is included):\n    vanilla_ebxl_oaks {\n        S:leaves=18,0\n        S:logs=17,0; 17,4; 17,8; <ExtrabiomesXL.quarterlog0.id>,2; <ExtrabiomesXL.quarterlog1.id>,2; <ExtrabiomesXL.quarterlog2.id>,2;<ExtrabiomesXL.quarterlog3.id>,2;\n    }\n\n    birches {\n        S:leaves=18,2\n        S:logs=17,2; 17,6; 17,10\n    }\n\n    vanilla_ebxl_spruces {\n        S:leaves=18,1; <ExtrabiomesXL.autumnleaves.id>\n        S:logs=17,1; 17,5; 17,9\n    }\n\n    jungle_trees {\n        S:leaves=18,3\n        S:logs=17,3; 17,7; 17,11\n    }\n\n    ic2_rubber {\n        S:leaves=<IC2.blockRubLeaves>\n        S:logs=<IC2.blockRubWood>\n    }\n\n    ebxl_acacia {\n        S:leaves=<ExtrabiomesXL.greenleaves.id>,2\n        S:logs=<ExtrabiomesXL.customlog.id>,1\n    }\n\n    ebxl_firs {\n        S:leaves=<ExtrabiomesXL.greenleaves.id>,0\n        S:logs=<ExtrabiomesXL.customlog.id>,0; <ExtrabiomesXL.quarterlog0.id>,1; <ExtrabiomesXL.quarterlog1.id>,1; <ExtrabiomesXL.quarterlog2.id>,1; <ExtrabiomesXL.quarterlog3.id>,1\n    }\n\n    ebxl_redwoods {\n        S:leaves=<ExtrabiomesXL.greenleaves.id>,1\n        S:logs=<ExtrabiomesXL.quarterlog0.id>,0; <ExtrabiomesXL.quarterlog1.id>,0; <ExtrabiomesXL.quarterlog2.id>,0; <ExtrabiomesXL.quarterlog3.id>,0\n    }";
    public static final String thirdPartyConfigDesc = "Third-Party config entries tell TreeCapitator how to find the block IDs from\nother mods' config files.  These values are case-sensitive!\n\nFormat:\n    <section_name> {\n        S:modID=<modID from mcmod.info>\n        S:configPath=<path to config file relative to .minecraft/config/>\n        S:blockValues=<block config section>:<config property name>; <mod config section>:<config property name>\n        S:itemValues=<item config section>:<property name>; <item config section>:<property name>\n        B:useShiftedItemID=<whether or not to use the +256 shifted item ID> (true/false)\n    }\n\nExample:\n    extrabiomesxl {\n        S:modID=ExtrabiomesXL\n        S:configPath=extrabiomes/extrabiomes.cfg\n        S:blockValues=block:customlog.id; block:quarterlog0.id; block:quarterlog1.id; block:quarterlog2.id; block:quarterlog3.id; block:autumnleaves.id; block:greenleaves.id\n        S:itemValues=items.world:axeRuby.id; items.world:axeGreenSapphire.id; items.world:axeSapphire.id\n        B:useShiftedItemID=true\n    }\n\nOnce your third-party config entries are setup, you can use replacement\ntags in your tree, axe, and shears ID configs.  Replacement tags are structured like this:\n<ModName.ConfigPropName>";

    public static void debugString(String msg, Object ... args) {
        if (allowDebugLogging) {
            TCLog.info("[DEBUG] " + msg, args);
        }
    }

    public static String replaceThirdPartyBlockTags(String input) {
        for (String tag : tagMap.keySet()) {
            input = input.replace(tag, (CharSequence)tagMap.get(tag));
        }
        return input;
    }

    public static String getRemoteConfig() {
        if (isForge && allowGetRemoteTreeConfig) {
            try {
                return CommonUtils.loadTextFromURL((URL)new URL(remoteTreeConfigURL), (Logger)TCLog.INSTANCE.getLogger(), (String)remoteBlockIDConfig)[0];
            }
            catch (Throwable e) {
                TCLog.warning("Error retrieving remote tree config! Defaulting to cached copy if available or local config.", new Object[0]);
            }
        }
        return remoteBlockIDConfig;
    }

    public static void init() {
        TreeCapitator.init(false);
    }

    public static void init(boolean isForgeVersion) {
        isForge = isForgeVersion;
        if (!isForge) {
            apa.r[apa.N.cz] = null;
            apa.r[TreeCapitator.wood.cz] = wood = new BlockTree(apa.N.cz);
            wk.f[TreeCapitator.wood.cz] = null;
            wk.f[TreeCapitator.wood.cz] = new wt(TreeCapitator.wood.cz - 256, wood, apk.a).b("log");
            logIDList.add(new BlockID(TreeCapitator.wood.cz));
        }
    }

    public static boolean isLogBlock(BlockID blockID) {
        return logIDList.contains(blockID);
    }

    public static boolean isAxeItem(wm itemStack) {
        return itemStack != null && itemStack.a > 0 && CommonUtils.isItemInList((int)itemStack.c, (int)itemStack.k(), (String)axeIDList);
    }

    public static String getStringFromConfigBlockList() {
        String list = "";
        for (HashMap group : configBlockList.values()) {
            list = list + " ! " + (String)group.get(LOGS) + (group.containsKey(LEAVES) ? "|" + (String)group.get(LEAVES) : "");
        }
        return TreeCapitator.replaceThirdPartyBlockTags(list.replaceFirst(" ! ", ""));
    }

    public static String getStringFromParsedLists() {
        String list = "";
        ArrayList processed = new ArrayList();
        for (BlockID key : logIDList) {
            String logPart = "";
            if (processed.contains(logToLogListMap.get(key))) continue;
            processed.add(logToLogListMap.get(key));
            for (BlockID logID : (ArrayList)logToLogListMap.get(key)) {
                logPart = logPart + "; " + logID.id + (logID.metadata != -1 ? "," + logID.metadata : "");
            }
            if ((logPart = logPart.replaceFirst("; ", "")).trim().length() <= 0) continue;
            String leafPart = "";
            for (BlockID leafID : (ArrayList)logToLeafListMap.get(key)) {
                leafPart = leafPart + "; " + leafID.id + (leafID.metadata != -1 ? "," + leafID.metadata : "");
            }
            leafPart = leafPart.replaceFirst("; ", "");
            list = list + " ! " + logPart + " | " + leafPart;
        }
        return list.replaceFirst(" ! ", "");
    }

    public static void parseConfigBlockList(String list) {
        logIDList = new ArrayList();
        leafIDList = new ArrayList();
        logToLogListMap = new HashMap();
        logToLeafListMap = new HashMap();
        TreeCapitator.debugString("Parsing Tree Block Config string: %s", list);
        if (list.trim().length() > 0) {
            String[] entries;
            for (String entry : entries = list.trim().split("!")) {
                if (entry.trim().length() <= 0) continue;
                TreeCapitator.debugString("  Parsing Tree entry: %s", entry);
                if (entry.trim().length() <= 0) continue;
                String[] blockTypes = entry.trim().split("\\|");
                ArrayList<BlockID> logIDs = new ArrayList<BlockID>();
                String[] logBlocks = blockTypes[0].trim().split(";");
                TreeCapitator.debugString("    Found log ID list: %s", blockTypes[0].trim());
                for (String logBlockStr : logBlocks) {
                    String[] logBlock = logBlockStr.trim().split(",");
                    TreeCapitator.debugString("    Found log ID: %s", logBlockStr);
                    int blockID = CommonUtils.parseInt((String)logBlock[0].trim(), (int)-1);
                    if (blockID != -1) {
                        int metadata = -1;
                        if (logBlock.length > 1) {
                            metadata = CommonUtils.parseInt((String)logBlock[1].trim(), (int)-1);
                        }
                        TreeCapitator.debugString("    ++Configured log: %s, %s", blockID, metadata);
                        BlockID logID = new BlockID(blockID, metadata);
                        if (logIDList.contains(logID)) continue;
                        logIDList.add(logID);
                        logIDs.add(logID);
                        continue;
                    }
                    TreeCapitator.debugString("Block ID %s could not be parsed as an integer.  Ignoring entry.", logBlock[0].trim());
                }
                for (BlockID logID : logIDs) {
                    logToLogListMap.put(logID, logIDs);
                }
                ArrayList<BlockID> pairedLeaves = new ArrayList<BlockID>();
                if (blockTypes.length > 1) {
                    String[] leafBlocks = blockTypes[1].trim().split(";");
                    TreeCapitator.debugString("    Found leaf ID list: %s", blockTypes[1].trim());
                    for (String block : leafBlocks) {
                        if (block.trim().length() <= 0) continue;
                        TreeCapitator.debugString("    Found leaf ID: %s", block.trim());
                        String[] leafBlock = block.trim().split(",");
                        int blockID = CommonUtils.parseInt((String)leafBlock[0].trim(), (int)-1);
                        if (blockID != -1) {
                            int metadata = -1;
                            if (leafBlock.length > 1) {
                                metadata = CommonUtils.parseInt((String)leafBlock[1].trim(), (int)-1);
                            }
                            TreeCapitator.debugString("    ++Configured leaf: %s, %s", blockID, metadata);
                            BlockID leafID = new BlockID(blockID, metadata);
                            if (!leafIDList.contains(leafID)) {
                                leafIDList.add(leafID);
                            }
                            if (pairedLeaves.contains(leafID)) continue;
                            pairedLeaves.add(leafID);
                            continue;
                        }
                        TreeCapitator.debugString("Block ID %s could not be parsed as an integer.  Ignoring entry.", leafBlock[0].trim());
                    }
                }
                for (BlockID logID : logIDs) {
                    if (logToLeafListMap.containsKey(logID)) continue;
                    logToLeafListMap.put(logID, pairedLeaves);
                }
            }
        }
        TCLog.info("Block ID list parsing complete.", new Object[0]);
    }

    static {
        logIDList = new ArrayList();
        leafIDList = new ArrayList();
        logToLeafListMap = new HashMap();
        logToLogListMap = new HashMap();
        configBlockList = new HashMap();
        thirdPartyConfig = new HashMap();
        tagMap = new HashMap();
        blocksBeingChopped = new ArrayList();
        HashMap<String, String> biomesoplenty = new HashMap<String, String>();
        biomesoplenty.put(MOD_ID, "BiomesOPlenty");
        biomesoplenty.put(CONFIG_PATH, "BiomesOPlenty.cfg");
        biomesoplenty.put(BLOCK_VALUES, "block:Acacia Leaves ID; block:Acacia Log ID; block:Apple Leaves ID; block:Fruitless Apple Leaves ID; block:Bamboo ID; block:Bamboo Leaves ID; block:Cherry Log ID; block:Dark Leaves ID; block:Dark Log ID; block:Dying Leaves ID; block:Dead Log ID; block:Fir Leaves ID; block:Fir Log ID; block:Magic Log ID; block:Magic Leaves ID; block:Mangrove Leaves ID; block:Mangrove Log ID; block:Maple Leaves ID; block:Orange Autumn Leaves ID; block:Origin Leaves ID; block:Palm Leaves ID; block:Palm Log ID; block:Pink Cherry Leaves ID; block:Redwood Leaves ID; block:Redwood Log ID; block:White Cherry Leaves ID; block:Willow Leaves ID; block:Willow Log ID; block:Yellow Autumn Leaves ID");
        biomesoplenty.put(ITEM_VALUES, "item:Muddy Axe ID");
        biomesoplenty.put(SHIFT_INDEX, "true");
        thirdPartyConfig.put("biomesoplenty", biomesoplenty);
        HashMap<String, String> divinerpg = new HashMap<String, String>();
        divinerpg.put(MOD_ID, "DivineRPG");
        divinerpg.put(CONFIG_PATH, "DivineRPG.cfg");
        divinerpg.put(BLOCK_VALUES, "block:eucalyptus");
        divinerpg.put(ITEM_VALUES, "item:Bedrock Axe; item:Crystal Axe; item:Realmite Axe; item:azuriteaxe; item:corruptedaxe; item:denseaxe; item:divineaxe; item:donatoraxe; item:energyaxe; item:mythrilaxe; item:plasmaaxe; item:serenityaxe; item:twilightaxe");
        divinerpg.put(SHIFT_INDEX, "true");
        thirdPartyConfig.put("divinerpg", divinerpg);
        HashMap<String, String> extrabiomesxl = new HashMap<String, String>();
        extrabiomesxl.put(MOD_ID, "ExtrabiomesXL");
        extrabiomesxl.put(CONFIG_PATH, "extrabiomes/extrabiomes.cfg");
        extrabiomesxl.put(BLOCK_VALUES, "block:customlog.id; block:quarterlog0.id; block:quarterlog1.id; block:quarterlog2.id; block:quarterlog3.id; block:autumnleaves.id; block:greenleaves.id");
        thirdPartyConfig.put("extrabiomesxl", extrabiomesxl);
        HashMap<String, String> forestry = new HashMap<String, String>();
        forestry.put(MOD_ID, "Forestry");
        forestry.put(CONFIG_PATH, "forestry/base.conf");
        forestry.put(BLOCK_VALUES, "block:log1; block:log2; block:log3; block:log4; block:leaves");
        thirdPartyConfig.put("forestry", forestry);
        HashMap<String, String> ic2 = new HashMap<String, String>();
        ic2.put(MOD_ID, "IC2");
        ic2.put(CONFIG_PATH, "IC2.cfg");
        ic2.put(BLOCK_VALUES, "block:blockRubWood; block:blockRubLeaves");
        ic2.put(ITEM_VALUES, "item:itemToolBronzeAxe; item:itemToolChainsaw");
        ic2.put(SHIFT_INDEX, "true");
        thirdPartyConfig.put("ic2", ic2);
        HashMap<String, String> inficraft = new HashMap<String, String>();
        inficraft.put(MOD_ID, "Flora Trees");
        inficraft.put(CONFIG_PATH, "InfiCraft/FloraSoma.txt");
        inficraft.put(BLOCK_VALUES, "block:Bloodwood Block; block:Flora Leaves; block:Redwood Block; block:Sakura Leaves; block:Wood Block");
        thirdPartyConfig.put("inficraft", inficraft);
        HashMap<String, String> mfreloaded = new HashMap<String, String>();
        mfreloaded.put(MOD_ID, "MFReloaded");
        mfreloaded.put(CONFIG_PATH, "MFReloaded.cfg");
        mfreloaded.put(BLOCK_VALUES, "block:ID.RubberWood; block:ID.RubberLeaves; block:ID.RubberSapling");
        thirdPartyConfig.put("mfreloaded", mfreloaded);
        HashMap<String, String> redpower = new HashMap<String, String>();
        redpower.put(MOD_ID, "RedPowerWorld");
        redpower.put(CONFIG_PATH, "redpower/redpower.cfg");
        redpower.put(BLOCK_VALUES, "blocks.world:log.id; blocks.world:leaves.id");
        redpower.put(ITEM_VALUES, "items.world:axeRuby.id; items.world:axeGreenSapphire.id; items.world:axeSapphire.id");
        redpower.put(SHIFT_INDEX, "true");
        thirdPartyConfig.put("redpower", redpower);
        HashMap<String, String> thaumcraft = new HashMap<String, String>();
        thaumcraft.put(MOD_ID, "Thaumcraft");
        thaumcraft.put(CONFIG_PATH, "Thaumcraft.cfg");
        thaumcraft.put(BLOCK_VALUES, "block:BlockMagicalLog; block:BlockMagicalLeaves");
        thaumcraft.put(ITEM_VALUES, "item:Thaumaxe");
        thaumcraft.put(SHIFT_INDEX, "true");
        thirdPartyConfig.put("thaumcraft", thaumcraft);
        HashMap<String, String> twilightforest = new HashMap<String, String>();
        twilightforest.put(MOD_ID, "TwilightForest");
        twilightforest.put(CONFIG_PATH, "TwilightForest.cfg");
        twilightforest.put(BLOCK_VALUES, "block:Log; block:MagicLog; block:MagicLogSpecial; block:Leaves; block:MagicLeaves; block:Hedge");
        twilightforest.put(ITEM_VALUES, "item:IronwoodAxe; item:SteeleafAxe; item:MinotaurAxe");
        twilightforest.put(SHIFT_INDEX, "true");
        thirdPartyConfig.put("twilightforest", twilightforest);
        HashMap<String, String> zapapples = new HashMap<String, String>();
        zapapples.put(MOD_ID, "ZapApples");
        zapapples.put(CONFIG_PATH, "ZapApples.cfg");
        zapapples.put(BLOCK_VALUES, "block:zapAppleLogID; block:zapAppleLeavesID; block:zapAppleFlowersID");
        thirdPartyConfig.put("zapapples", zapapples);
        axeIDList = axeIDList + "; " + "<BiomesOPlenty.Muddy Axe ID>; " + "<IC2.itemToolBronzeAxe>; <IC2.itemToolChainsaw>; " + "<RedPowerWorld.axeRuby.id>; <RedPowerWorld.axeGreenSapphire.id>; <RedPowerWorld.axeSapphire.id>; " + "<Thaumcraft.Thaumaxe>; " + "<TwilightForest.IronwoodAxe>; <TwilightForest.SteeleafAxe>; <TwilightForest.MinotaurAxe>; " + "<DivineRPG.Bedrock Axe>; <DivineRPG.Crystal Axe>; <DivineRPG.Realmite Axe>; <DivineRPG.azuriteaxe>; <DivineRPG.corruptedaxe>; " + "<DivineRPG.denseaxe>; <DivineRPG.divineaxe>; <DivineRPG.donatoraxe>; <DivineRPG.energyaxe>; <DivineRPG.mythrilaxe>; " + "<DivineRPG.plasmaaxe>; <DivineRPG.serenityaxe>; <DivineRPG.twilightaxe>";
        HashMap<String, String> huge_brown_mushrooms = new HashMap<String, String>();
        huge_brown_mushrooms.put(LOGS, "99,10; 99,15");
        huge_brown_mushrooms.put(LEAVES, "99,1; 99,2; 99,3; 99,4; 99,5; 99,6; 99,7; 99,8; 99,9; 99,14");
        configBlockList.put("huge_brown_mushrooms", huge_brown_mushrooms);
        HashMap<String, String> huge_red_mushrooms = new HashMap<String, String>();
        huge_red_mushrooms.put(LOGS, "100,10; 100,15");
        huge_red_mushrooms.put(LEAVES, "100,1; 100,2; 100,3; 100,4; 100,5; 100,6; 100,7; 100,8; 100,9; 100,14");
        configBlockList.put("huge_red_mushrooms", huge_red_mushrooms);
        HashMap<String, String> vanilla_ebxl_oaks = new HashMap<String, String>();
        vanilla_ebxl_oaks.put(LOGS, "17,0; 17,4; 17,8; 17,12; <ExtrabiomesXL.quarterlog0.id>,2; <ExtrabiomesXL.quarterlog1.id>,2; <ExtrabiomesXL.quarterlog2.id>,2; <ExtrabiomesXL.quarterlog3.id>,2;");
        vanilla_ebxl_oaks.put(LEAVES, "18,0; <ExtrabiomesXL.autumnleaves.id>; <BiomesOPlenty.Dying Leaves ID>; <BiomesOPlenty.Origin Leaves ID>; <BiomesOPlenty.Apple Leaves ID>; <BiomesOPlenty.Fruitless Apple Leaves ID>; <BiomesOPlenty.Orange Autumn Leaves ID>; <BiomesOPlenty.Maple Leaves ID>");
        configBlockList.put("vanilla_ebxl_bop_oaks", vanilla_ebxl_oaks);
        HashMap<String, String> vanilla_ebxl_spruces = new HashMap<String, String>();
        vanilla_ebxl_spruces.put(LOGS, "17,1; 17,5; 17,9; 17,13");
        vanilla_ebxl_spruces.put(LEAVES, "18,1; <ExtrabiomesXL.autumnleaves.id>");
        configBlockList.put("vanilla_ebxl_spruces", vanilla_ebxl_spruces);
        HashMap<String, String> birches = new HashMap<String, String>();
        birches.put(LOGS, "17,2; 17,6; 17,10; 17,14");
        birches.put(LEAVES, "18,2; <BiomesOPlenty.Yellow Autumn Leaves ID>; 18,0");
        configBlockList.put("vanilla_bop_birches", birches);
        HashMap<String, String> jungle_trees = new HashMap<String, String>();
        jungle_trees.put(LOGS, "17,3; 17,7; 17,11; 17,15");
        jungle_trees.put(LEAVES, "18,3");
        configBlockList.put("jungle_trees", jungle_trees);
        HashMap<String, String> biomesoplenty_dead = new HashMap<String, String>();
        biomesoplenty_dead.put(LOGS, "<BiomesOPlenty.Dead Log ID>");
        configBlockList.put("biomesoplenty_dead", biomesoplenty_dead);
        HashMap<String, String> biomesoplenty_acacia = new HashMap<String, String>();
        biomesoplenty_acacia.put(LOGS, "<BiomesOPlenty.Acacia Log ID>");
        biomesoplenty_acacia.put(LEAVES, "<BiomesOPlenty.Acacia Leaves ID>");
        configBlockList.put("biomesoplenty_acacia", biomesoplenty_acacia);
        HashMap<String, String> biomesoplenty_bamboo = new HashMap<String, String>();
        biomesoplenty_bamboo.put(LOGS, "<BiomesOPlenty.Bamboo ID>");
        biomesoplenty_bamboo.put(LEAVES, "<BiomesOPlenty.Bamboo Leaves ID>");
        configBlockList.put("biomesoplenty_bamboo", biomesoplenty_bamboo);
        HashMap<String, String> biomesoplenty_cherry = new HashMap<String, String>();
        biomesoplenty_cherry.put(LOGS, "<BiomesOPlenty.Cherry Log ID>");
        biomesoplenty_cherry.put(LEAVES, "<BiomesOPlenty.Pink Cherry Leaves ID>; <BiomesOPlenty.White Cherry Leaves ID>");
        configBlockList.put("biomesoplenty_cherry", biomesoplenty_cherry);
        HashMap<String, String> biomesoplenty_dark = new HashMap<String, String>();
        biomesoplenty_dark.put(LOGS, "<BiomesOPlenty.Dark Log ID>");
        biomesoplenty_dark.put(LEAVES, "<BiomesOPlenty.Dark Leaves ID>; <BiomesOPlenty.White Cherry Leaves ID>");
        configBlockList.put("biomesoplenty_darkwood", biomesoplenty_dark);
        HashMap<String, String> biomesoplenty_fir = new HashMap<String, String>();
        biomesoplenty_fir.put(LOGS, "<BiomesOPlenty.Fir Log ID>");
        biomesoplenty_fir.put(LEAVES, "<BiomesOPlenty.Fir Leaves ID>");
        configBlockList.put("biomesoplenty_fir", biomesoplenty_fir);
        HashMap<String, String> biomesoplenty_magic = new HashMap<String, String>();
        biomesoplenty_magic.put(LOGS, "<BiomesOPlenty.Magic Log ID>");
        biomesoplenty_magic.put(LEAVES, "<BiomesOPlenty.Magic Leaves ID>");
        configBlockList.put("biomesoplenty_magic", biomesoplenty_magic);
        HashMap<String, String> biomesoplenty_mangrove = new HashMap<String, String>();
        biomesoplenty_mangrove.put(LOGS, "<BiomesOPlenty.Mangrove Log ID>");
        biomesoplenty_mangrove.put(LEAVES, "<BiomesOPlenty.Mangrove Leaves ID>");
        configBlockList.put("biomesoplenty_mangrove", biomesoplenty_mangrove);
        HashMap<String, String> biomesoplenty_palm = new HashMap<String, String>();
        biomesoplenty_palm.put(LOGS, "<BiomesOPlenty.Palm Log ID>");
        biomesoplenty_palm.put(LEAVES, "<BiomesOPlenty.Palm Leaves ID>");
        configBlockList.put("biomesoplenty_palm", biomesoplenty_palm);
        HashMap<String, String> biomesoplenty_redwood = new HashMap<String, String>();
        biomesoplenty_redwood.put(LOGS, "<BiomesOPlenty.Redwood Log ID>");
        biomesoplenty_redwood.put(LEAVES, "<BiomesOPlenty.Redwood Leaves ID>");
        configBlockList.put("biomesoplenty_redwood", biomesoplenty_redwood);
        HashMap<String, String> biomesoplenty_willow = new HashMap<String, String>();
        biomesoplenty_willow.put(LOGS, "<BiomesOPlenty.Willow Log ID>");
        biomesoplenty_willow.put(LEAVES, "<BiomesOPlenty.Willow Leaves ID>");
        configBlockList.put("biomesoplenty_willow", biomesoplenty_willow);
        HashMap<String, String> divinerpg_eucalyptus = new HashMap<String, String>();
        divinerpg_eucalyptus.put(LOGS, "<DivineRPG.eucalyptus>");
        divinerpg_eucalyptus.put(LEAVES, "18");
        configBlockList.put("divinerpg_eucalyptus", divinerpg_eucalyptus);
        HashMap<String, String> ebxl_redwoods = new HashMap<String, String>();
        ebxl_redwoods.put(LOGS, "<ExtrabiomesXL.quarterlog0.id>,0; <ExtrabiomesXL.quarterlog1.id>,0; <ExtrabiomesXL.quarterlog2.id>,0; <ExtrabiomesXL.quarterlog3.id>,0");
        ebxl_redwoods.put(LEAVES, "<ExtrabiomesXL.greenleaves.id>,1");
        configBlockList.put("ebxl_redwoods", ebxl_redwoods);
        HashMap<String, String> ebxl_firs = new HashMap<String, String>();
        ebxl_firs.put(LOGS, "<ExtrabiomesXL.customlog.id>,0; <ExtrabiomesXL.quarterlog0.id>,1; <ExtrabiomesXL.quarterlog1.id>,1; <ExtrabiomesXL.quarterlog2.id>,1; <ExtrabiomesXL.quarterlog3.id>,1");
        ebxl_firs.put(LEAVES, "<ExtrabiomesXL.greenleaves.id>,0");
        configBlockList.put("ebxl_firs", ebxl_firs);
        HashMap<String, String> ebxl_acacia = new HashMap<String, String>();
        ebxl_acacia.put(LOGS, "<ExtrabiomesXL.customlog.id>,1");
        ebxl_acacia.put(LEAVES, "<ExtrabiomesXL.greenleaves.id>,2");
        configBlockList.put("ebxl_acacia", ebxl_acacia);
        HashMap<String, String> forestry_larch = new HashMap<String, String>();
        forestry_larch.put(LOGS, "<Forestry.log1>,0; <Forestry.log1>,4; <Forestry.log1>,8");
        forestry_larch.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_larch", forestry_larch);
        HashMap<String, String> forestry_teak = new HashMap<String, String>();
        forestry_teak.put(LOGS, "<Forestry.log1>,1; <Forestry.log1>,5; <Forestry.log1>,9");
        forestry_teak.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_teak", forestry_teak);
        HashMap<String, String> forestry_acacia = new HashMap<String, String>();
        forestry_acacia.put(LOGS, "<Forestry.log1>,2; <Forestry.log1>,6; <Forestry.log1>,10");
        forestry_acacia.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_acacia", forestry_acacia);
        HashMap<String, String> forestry_lime = new HashMap<String, String>();
        forestry_lime.put(LOGS, "<Forestry.log1>,3; <Forestry.log1>,7; <Forestry.log1>,11");
        forestry_lime.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_lime", forestry_lime);
        HashMap<String, String> forestry_chestnut = new HashMap<String, String>();
        forestry_chestnut.put(LOGS, "<Forestry.log2>,0; <Forestry.log2>,4; <Forestry.log2>,8");
        forestry_chestnut.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_chestnut", forestry_chestnut);
        HashMap<String, String> forestry_wenge = new HashMap<String, String>();
        forestry_wenge.put(LOGS, "<Forestry.log2>,1; <Forestry.log2>,5; <Forestry.log2>,9");
        forestry_wenge.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_wenge", forestry_wenge);
        HashMap<String, String> forestry_baobab = new HashMap<String, String>();
        forestry_baobab.put(LOGS, "<Forestry.log2>,2; <Forestry.log2>,6; <Forestry.log2>,10");
        forestry_baobab.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_baobab", forestry_baobab);
        HashMap<String, String> forestry_sequoia = new HashMap<String, String>();
        forestry_sequoia.put(LOGS, "<Forestry.log2>,3; <Forestry.log2>,7; <Forestry.log2>,11");
        forestry_sequoia.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_sequoia", forestry_sequoia);
        HashMap<String, String> forestry_kapok = new HashMap<String, String>();
        forestry_kapok.put(LOGS, "<Forestry.log3>,0; <Forestry.log3>,4; <Forestry.log3>,8");
        forestry_kapok.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_kapok", forestry_kapok);
        HashMap<String, String> forestry_ebony = new HashMap<String, String>();
        forestry_ebony.put(LOGS, "<Forestry.log3>,1; <Forestry.log3>,5; <Forestry.log3>,9");
        forestry_ebony.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_ebony", forestry_ebony);
        HashMap<String, String> forestry_mahogany = new HashMap<String, String>();
        forestry_mahogany.put(LOGS, "<Forestry.log3>,2; <Forestry.log3>,6; <Forestry.log3>,10");
        forestry_mahogany.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_mahogany", forestry_mahogany);
        HashMap<String, String> forestry_balsa = new HashMap<String, String>();
        forestry_balsa.put(LOGS, "<Forestry.log3>,3; <Forestry.log3>,7; <Forestry.log3>,11");
        forestry_balsa.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_balsa", forestry_balsa);
        HashMap<String, String> forestry_willow = new HashMap<String, String>();
        forestry_willow.put(LOGS, "<Forestry.log4>,0; <Forestry.log4>,4; <Forestry.log4>,8");
        forestry_willow.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_willow", forestry_willow);
        HashMap<String, String> forestry_walnut = new HashMap<String, String>();
        forestry_walnut.put(LOGS, "<Forestry.log4>,1; <Forestry.log4>,5; <Forestry.log4>,9");
        forestry_walnut.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_walnut", forestry_walnut);
        HashMap<String, String> forestry_boojum = new HashMap<String, String>();
        forestry_boojum.put(LOGS, "<Forestry.log4>,2; <Forestry.log4>,6; <Forestry.log4>,10");
        forestry_boojum.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_boojum", forestry_boojum);
        HashMap<String, String> forestry_cherry = new HashMap<String, String>();
        forestry_cherry.put(LOGS, "<Forestry.log4>,3; <Forestry.log4>,7; <Forestry.log4>,11");
        forestry_cherry.put(LEAVES, "<Forestry.leaves>,0; <Forestry.leaves>,8");
        configBlockList.put("forestry_cherry", forestry_cherry);
        HashMap<String, String> ic2_rubber = new HashMap<String, String>();
        ic2_rubber.put(LOGS, "<IC2.blockRubWood>");
        ic2_rubber.put(LEAVES, "<IC2.blockRubLeaves>");
        configBlockList.put("ic2_rubber", ic2_rubber);
        HashMap<String, String> inficraft_bloodwood = new HashMap<String, String>();
        inficraft_bloodwood.put(LOGS, "<Flora Trees.Bloodwood Block>");
        inficraft_bloodwood.put(LEAVES, "<Flora Trees.Sakura Leaves>,2");
        configBlockList.put("inficraft_bloodwood", inficraft_bloodwood);
        HashMap<String, String> inficraft_eucalyptus = new HashMap<String, String>();
        inficraft_eucalyptus.put(LOGS, "<Flora Trees.Wood Block>,0; <Flora Trees.Wood Block>,4; <Flora Trees.Wood Block>,8");
        inficraft_eucalyptus.put(LEAVES, "<Flora Trees.Flora Leaves>,1");
        configBlockList.put("inficraft_eucalyptus", inficraft_eucalyptus);
        HashMap<String, String> inficraft_ghostwood = new HashMap<String, String>();
        inficraft_ghostwood.put(LOGS, "<Flora Trees.Wood Block>,2; <Flora Trees.Wood Block>, 6; <Flora Trees.Wood Block>, 10");
        inficraft_ghostwood.put(LEAVES, "<Flora Trees.Sakura Leaves>,1");
        configBlockList.put("inficraft_ghostwood", inficraft_ghostwood);
        HashMap<String, String> inficraft_hopseed = new HashMap<String, String>();
        inficraft_hopseed.put(LOGS, "<Flora Trees.Wood Block>,3; <Flora Trees.Wood Block>, 7; <Flora Trees.Wood Block>, 11");
        inficraft_hopseed.put(LEAVES, "<Flora Trees.Flora Leaves>,2");
        configBlockList.put("inficraft_hopseed", inficraft_hopseed);
        HashMap<String, String> inficraft_redwood = new HashMap<String, String>();
        inficraft_redwood.put(LOGS, "<Flora Trees.Redwood Block>");
        inficraft_redwood.put(LEAVES, "<Flora Trees.Flora Leaves>,0");
        configBlockList.put("inficraft_redwood", inficraft_redwood);
        HashMap<String, String> inficraft_sakura = new HashMap<String, String>();
        inficraft_sakura.put(LOGS, "<Flora Trees.Wood Block>, 1; <Flora Trees.Wood Block>, 5; <Flora Trees.Wood Block>, 9");
        inficraft_sakura.put(LEAVES, "<Flora Trees.Sakura Leaves>,0");
        configBlockList.put("inficraft_sakura", inficraft_sakura);
        HashMap<String, String> mfr_rubber = new HashMap<String, String>();
        mfr_rubber.put(LOGS, "<MFReloaded.ID.RubberWood>");
        mfr_rubber.put(LEAVES, "<MFReloaded.ID.RubberLeaves>");
        configBlockList.put("mfr_rubber", mfr_rubber);
        HashMap<String, String> rp2_rubber = new HashMap<String, String>();
        rp2_rubber.put(LOGS, "<RedPowerWorld.log.id>");
        rp2_rubber.put(LEAVES, "<RedPowerWorld.leaves.id>");
        configBlockList.put("rp2_rubber", rp2_rubber);
        HashMap<String, String> thaum_greatwood = new HashMap<String, String>();
        thaum_greatwood.put(LOGS, "<Thaumcraft.BlockMagicalLog>,0; <Thaumcraft.BlockMagicalLog>,4; <Thaumcraft.BlockMagicalLog>,8");
        thaum_greatwood.put(LEAVES, "<Thaumcraft.BlockMagicalLeaves>,0; <Thaumcraft.BlockMagicalLeaves>,8");
        configBlockList.put("thaum_greatwood", thaum_greatwood);
        HashMap<String, String> thaum_silverwood = new HashMap<String, String>();
        thaum_silverwood.put(LOGS, "<Thaumcraft.BlockMagicalLog>,1; <Thaumcraft.BlockMagicalLog>,5; <Thaumcraft.BlockMagicalLog>,9");
        thaum_silverwood.put(LEAVES, "<Thaumcraft.BlockMagicalLeaves>,1");
        configBlockList.put("thaum_silverwood", thaum_silverwood);
        HashMap<String, String> twilight_oaks = new HashMap<String, String>();
        twilight_oaks.put(LOGS, "<TwilightForest.Log>,0; <TwilightForest.Log>,4; <TwilightForest.Log>,8; <TwilightForest.Log>,12");
        twilight_oaks.put(LEAVES, "<TwilightForest.Leaves>,0; <TwilightForest.Leaves>,3; <TwilightForest.Leaves>,8; <TwilightForest.Leaves>,11");
        configBlockList.put("twilight_oaks", twilight_oaks);
        HashMap<String, String> twilight_canopy = new HashMap<String, String>();
        twilight_canopy.put(LOGS, "<TwilightForest.Log>,1; <TwilightForest.Log>,5; <TwilightForest.Log>,9; <TwilightForest.Log>,13");
        twilight_canopy.put(LEAVES, "<TwilightForest.Leaves>, 1; <TwilightForest.Leaves>,9");
        configBlockList.put("twilight_canopy", twilight_canopy);
        HashMap<String, String> twilight_mangrove = new HashMap<String, String>();
        twilight_mangrove.put(LOGS, "<TwilightForest.Log>,2; <TwilightForest.Log>,6; <TwilightForest.Log>,10; <TwilightForest.Log>,14");
        twilight_mangrove.put(LEAVES, "<TwilightForest.Leaves>, 1; <TwilightForest.Leaves>,9");
        configBlockList.put("twilight_mangrove", twilight_mangrove);
        HashMap<String, String> twilight_darkwood = new HashMap<String, String>();
        twilight_darkwood.put(LOGS, "<TwilightForest.Log>,3; <TwilightForest.Log>,7; <TwilightForest.Log>,11;  <TwilightForest.Log>,15");
        twilight_darkwood.put(LEAVES, "<TwilightForest.Hedge>,1");
        configBlockList.put("twilight_darkwood", twilight_darkwood);
        HashMap<String, String> twilight_time = new HashMap<String, String>();
        twilight_time.put(LOGS, "<TwilightForest.MagicLog>,0; <TwilightForest.Log>,4; <TwilightForest.Log>,8; <TwilightForest.MagicLog>,12");
        twilight_time.put(LEAVES, "<TwilightForest.MagicLeaves>,0; <TwilightForest.MagicLeaves>,8");
        configBlockList.put("twilight_time", twilight_time);
        HashMap<String, String> zapapple = new HashMap<String, String>();
        zapapple.put(LOGS, "<ZapApples.zapAppleLogID>");
        zapapple.put(LEAVES, "<ZapApples.zapAppleLeavesID>; <ZapApples.zapAppleFlowersID>");
        configBlockList.put("zapapple", zapapple);
    }
}

