/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.TreeCapitator;
import bspkrs.util.BlockID;
import bspkrs.util.CommonUtils;
import bspkrs.util.Coord;
import java.util.ArrayList;
import java.util.List;

public class TreeBlockBreaker {
    public sq player;
    public boolean shouldFell;
    private Coord startPos;
    private wm axe;
    private wm shears;
    private final ArrayList logIDList;
    private final ArrayList leafIDList;
    private final BlockID vineID;
    private float currentAxeDamage;
    private float currentShearsDamage = 0.0f;
    private int numLogsBroken;
    private int numLeavesSheared;
    private float logDamageMultiplier;
    private float leafDamageMultiplier;

    public TreeBlockBreaker(sq entityPlayer, ArrayList logIDList, ArrayList leafIDList) {
        this.player = entityPlayer;
        this.shouldFell = false;
        this.logIDList = logIDList;
        this.leafIDList = leafIDList;
        this.vineID = new BlockID(apa.by.cz);
        this.logDamageMultiplier = TreeCapitator.damageMultiplier;
        this.leafDamageMultiplier = TreeCapitator.damageMultiplier;
        this.numLogsBroken = 0;
        this.numLeavesSheared = 0;
    }

    public static boolean isBreakingPossible(aab world, sq entityPlayer) {
        if (!TreeBlockBreaker.isBreakingEnabled(entityPlayer)) {
            TreeCapitator.debugString("Chopping disabled due to player state or gamemode.", new Object[0]);
            return false;
        }
        wm axe = entityPlayer.cd();
        if (!world.I) {
            if (TreeBlockBreaker.isAxeItemEquipped(entityPlayer) || !TreeCapitator.needItem) {
                if (!entityPlayer.ce.d && TreeCapitator.allowItemDamage && axe != null && axe.g() && (float)(axe.l() - axe.k()) <= TreeCapitator.damageMultiplier && !TreeCapitator.allowMoreBlocksThanDamage) {
                    TreeCapitator.debugString("Chopping disabled due to axe durability.", new Object[0]);
                    return false;
                }
                return true;
            }
            TreeCapitator.debugString("Player does not have an axe equipped.", new Object[0]);
        }
        return false;
    }

    public static boolean isBreakingEnabled(sq player) {
        return (TreeCapitator.sneakAction.equalsIgnoreCase("none") || TreeCapitator.sneakAction.equalsIgnoreCase("disable") && !player.ag() || TreeCapitator.sneakAction.equalsIgnoreCase("enable") && player.ag()) && (!player.ce.d || !TreeCapitator.disableInCreative);
    }

    public void onBlockHarvested(aab world, int x, int y, int z, int md, sq entityPlayer) {
        TreeCapitator.debugString("In TreeBlockBreaker.onBlockHarvested() " + x + ", " + y + ", " + z, new Object[0]);
        this.player = entityPlayer;
        this.startPos = new Coord(x, y, z);
        if (!world.I) {
            if (TreeBlockBreaker.isBreakingEnabled(entityPlayer)) {
                Coord topLog = this.getTopLog(world, new Coord(x, y, z));
                if (!TreeCapitator.allowSmartTreeDetection || this.leafIDList.size() == 0 || this.hasXLeavesInDist(world, topLog, TreeCapitator.maxLeafIDDist, TreeCapitator.minLeavesToID)) {
                    if (this.isAxeItemEquipped() || !TreeCapitator.needItem) {
                        TreeCapitator.debugString("Proceeding to chop tree...", new Object[0]);
                        ArrayList listFinal = new ArrayList();
                        TreeCapitator.debugString("Finding log blocks...", new Object[0]);
                        List logs = this.addLogs(world, new Coord(x, y, z));
                        this.addLogsAbove(world, new Coord(x, y, z), listFinal);
                        TreeCapitator.debugString("Destroying log blocks...", new Object[0]);
                        this.destroyBlocks(world, logs);
                        if (TreeCapitator.destroyLeaves && this.leafIDList.size() != 0) {
                            TreeCapitator.debugString("Finding leaf blocks...", new Object[0]);
                            for (Coord pos : listFinal) {
                                List leaves = this.addLeaves(world, pos);
                                this.removeLeavesWithLogsAround(world, leaves);
                                this.destroyBlocksWithChance(world, leaves, 0.5f, this.hasShearsInHotbar(this.player));
                            }
                        }
                        if (this.currentAxeDamage > 0.0f && this.axe != null) {
                            this.currentAxeDamage = Math.round(this.currentAxeDamage);
                            for (int i = 0; i < kx.c((double)this.currentAxeDamage); ++i) {
                                this.axe.b().a(this.axe, world, 17, x, y, z, (ng)this.player);
                            }
                        }
                        if (this.currentShearsDamage > 0.0f && this.shears != null) {
                            this.currentShearsDamage = Math.round(this.currentShearsDamage);
                            int i = 0;
                            while ((double)i < Math.floor(this.currentShearsDamage)) {
                                if (TreeCapitator.isForge && this.shears.c == wk.bf.cp) {
                                    this.shears.a(1, (ng)this.player);
                                } else {
                                    this.shears.b().a(this.shears, world, 18, x, y, z, (ng)this.player);
                                }
                                ++i;
                            }
                        }
                    } else {
                        TreeCapitator.debugString("Axe item is not equipped.", new Object[0]);
                    }
                } else {
                    TreeCapitator.debugString("Could not identify tree.", new Object[0]);
                }
            } else {
                TreeCapitator.debugString("Tree Chopping is disabled due to player state or gamemode.", new Object[0]);
            }
        } else {
            TreeCapitator.debugString("World is remote, exiting TreeBlockBreaker.", new Object[0]);
        }
    }

    public float getBlockHardness() {
        return this.isAxeItemEquipped() ? TreeCapitator.logHardnessModified : TreeCapitator.logHardnessNormal;
    }

    public static float getBlockHardness(sq entityPlayer) {
        return TreeBlockBreaker.isAxeItemEquipped(entityPlayer) ? TreeCapitator.logHardnessModified : TreeCapitator.logHardnessNormal;
    }

    private Coord getTopLog(aab world, Coord pos) {
        while (this.logIDList.contains(new BlockID(world, pos.x, pos.y + 1, pos.z))) {
            ++pos.y;
        }
        TreeCapitator.debugString("Top Log: " + pos.x + ", " + pos.y + ", " + pos.z, new Object[0]);
        return pos;
    }

    private boolean hasXLeavesInDist(aab world, Coord pos, int range, int limit) {
        TreeCapitator.debugString("Attempting to identify tree...", new Object[0]);
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -1; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockID blockID = new BlockID(world, pos.x + x, pos.y + y, pos.z + z);
                    if (this.isLeafBlock(blockID)) {
                        TreeCapitator.debugString("Found leaf block: %s", blockID);
                        if (++i < limit) continue;
                        return true;
                    }
                    TreeCapitator.debugString("Not a leaf block: %s", blockID);
                }
            }
        }
        TreeCapitator.debugString("Number of leaf blocks is less than the limit. Found: %s", i);
        return false;
    }

    public int leavesInDist(aab world, Coord pos, int range) {
        int i = 0;
        for (int x = -range; x <= range; ++x) {
            for (int y = -1; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockID blockID = new BlockID(world, pos.x + x, pos.y + y, pos.z + z);
                    if (this.isLeafBlock(blockID)) {
                        TreeCapitator.debugString("Found leaf block: %s", blockID);
                        ++i;
                        continue;
                    }
                    TreeCapitator.debugString("Not a leaf block: %s", blockID);
                }
            }
        }
        TreeCapitator.debugString("Leaves within " + range + " blocks of " + pos.x + ", " + pos.y + ", " + pos.z + " : " + i, new Object[0]);
        return i;
    }

    public int leavesAround(aab world, Coord pos) {
        return this.leavesInDist(world, pos, 1);
    }

    private boolean isAxeItemEquipped() {
        wm item = this.player.cd();
        if (TreeCapitator.isAxeItem(item)) {
            this.axe = item;
            return true;
        }
        this.axe = null;
        return false;
    }

    public static boolean isAxeItemEquipped(sq entityPlayer) {
        wm item = entityPlayer.cd();
        return TreeCapitator.isAxeItem(item);
    }

    private boolean hasShearsInHotbar(sq entityplayer) {
        return this.shearsHotbarIndex(entityplayer) != -1;
    }

    private int shearsHotbarIndex(sq entityPlayer) {
        for (int i = 0; i < 9; ++i) {
            wm item = entityPlayer.bK.a[i];
            if (item == null || item.a <= 0 || !CommonUtils.isItemInList((int)item.c, (int)item.k(), (String)TreeCapitator.shearIDList)) continue;
            this.shears = item;
            return i;
        }
        this.shears = null;
        return -1;
    }

    public boolean isLeafBlock(BlockID blockID) {
        return this.leafIDList.contains(blockID) || this.leafIDList.contains(new BlockID(blockID.id, blockID.metadata & 7));
    }

    private void destroyBlocks(aab world, List list) {
        this.destroyBlocksWithChance(world, list, 1.0f, false);
    }

    private void destroyBlocksWithChance(aab world, List list, float f) {
        this.destroyBlocksWithChance(world, list, f, false);
    }

    private void destroyBlocksWithChance(aab world, List list, float f, boolean canShear) {
        TreeCapitator.debugString("Breaking identified blocks...", new Object[0]);
        while (list.size() > 0) {
            Coord pos = (Coord)list.remove(0);
            int id = world.a(pos.x, pos.y, pos.z);
            if (id == 0) continue;
            apa block = apa.r[id];
            int metadata = world.h(pos.x, pos.y, pos.z);
            if ((this.vineID.equals((Object)new BlockID(block, metadata)) && TreeCapitator.shearVines || this.isLeafBlock(new BlockID(block, metadata)) && TreeCapitator.shearLeaves) && canShear && (!this.player.ce.d || !TreeCapitator.disableCreativeDrops)) {
                world.d((mp)new rh(world, (double)pos.x, (double)pos.y, (double)pos.z, new wm(id, 1, block.a(metadata))));
                if (TreeCapitator.allowItemDamage && !this.player.ce.d && this.shears != null && this.shears.a > 0) {
                    canShear = this.damageShearsAndContinue(world, id, pos.x, pos.y, pos.z);
                    ++this.numLeavesSheared;
                    if (canShear && TreeCapitator.useIncreasingItemDamage && this.numLeavesSheared % TreeCapitator.increaseDamageEveryXBlocks == 0) {
                        this.leafDamageMultiplier += TreeCapitator.damageIncreaseAmount;
                    }
                }
            } else if (!this.player.ce.d || !TreeCapitator.disableCreativeDrops) {
                block.c(world, pos.x, pos.y, pos.z, metadata, 0);
                if (!(!TreeCapitator.allowItemDamage || this.player.ce.d || this.axe == null || this.axe.a <= 0 || this.vineID.equals((Object)new BlockID(block, metadata)) || this.isLeafBlock(new BlockID(block, metadata)) || pos.equals((Object)this.startPos))) {
                    if (!this.damageAxeAndContinue(world, id, pos.x, pos.y, pos.z)) {
                        list.clear();
                    }
                    ++this.numLogsBroken;
                    if (TreeCapitator.useIncreasingItemDamage && this.numLogsBroken % TreeCapitator.increaseDamageEveryXBlocks == 0) {
                        this.logDamageMultiplier += TreeCapitator.damageIncreaseAmount;
                    }
                }
            }
            if (world.d(pos.x, pos.y, pos.z)) {
                world.s(pos.x, pos.y, pos.z);
            }
            world.f(pos.x, pos.y, pos.z, 0, 0, 3);
        }
    }

    private boolean damageAxeAndContinue(aab world, int id, int x, int y, int z) {
        if (this.axe != null) {
            this.currentAxeDamage += this.logDamageMultiplier;
            for (int i = 0; i < (int)Math.floor(this.currentAxeDamage); ++i) {
                this.axe.b().a(this.axe, world, id, x, y, z, (ng)this.player);
            }
            this.currentAxeDamage = (float)((double)this.currentAxeDamage - Math.floor(this.currentAxeDamage));
            if (this.axe != null && this.axe.a < 1) {
                this.player.ce();
            }
        }
        return !TreeCapitator.needItem || TreeCapitator.allowMoreBlocksThanDamage || this.isAxeItemEquipped();
    }

    private boolean damageShearsAndContinue(aab world, int id, int x, int y, int z) {
        if (this.shears != null) {
            int shearsIndex = this.shearsHotbarIndex(this.player);
            this.currentShearsDamage += this.leafDamageMultiplier;
            int i = 0;
            while ((double)i < Math.floor(this.currentShearsDamage)) {
                if (TreeCapitator.isForge && this.shears.c == wk.bf.cp) {
                    this.shears.a(1, (ng)this.player);
                } else {
                    this.shears.b().a(this.shears, world, id, x, y, z, (ng)this.player);
                }
                ++i;
            }
            this.currentShearsDamage = (float)((double)this.currentShearsDamage - Math.floor(this.currentShearsDamage));
            if (this.shears != null && this.shears.a < 1 && shearsIndex != -1) {
                this.player.bK.a(shearsIndex, (wm)null);
            }
        }
        return TreeCapitator.allowMoreBlocksThanDamage || this.hasShearsInHotbar(this.player);
    }

    private List addLogs(aab world, Coord pos) {
        int index = 0;
        int lowY = pos.y;
        ArrayList<Coord> list = new ArrayList<Coord>();
        list.add(pos);
        do {
            Coord currentLog = (Coord)list.get(index);
            for (int x = -1; x <= 1; ++x) {
                int y;
                int n = y = TreeCapitator.onlyDestroyUpwards ? 0 : -1;
                while (y <= 1) {
                    for (int z = -1; z <= 1; ++z) {
                        if (!this.logIDList.contains(new BlockID(world, currentLog.x + x, currentLog.y + y, currentLog.z + z))) continue;
                        Coord newPos = new Coord(currentLog.x + x, currentLog.y + y, currentLog.z + z);
                        if (TreeCapitator.maxBreakDistance != -1 && (Math.abs(newPos.x - this.startPos.x) > TreeCapitator.maxBreakDistance || Math.abs(newPos.z - this.startPos.z) > TreeCapitator.maxBreakDistance) || list.contains(newPos) || newPos.y < lowY && TreeCapitator.onlyDestroyUpwards) continue;
                        list.add(newPos);
                    }
                    ++y;
                }
            }
        } while (++index < list.size());
        return list;
    }

    private void addLogsAbove(aab world, Coord position, List listFinal) {
        ArrayList<Coord> listAbove = new ArrayList<Coord>();
        listAbove.add(position);
        do {
            Coord newPosition;
            int z;
            int x;
            ArrayList<Coord> list = listAbove;
            listAbove = new ArrayList();
            for (Coord pos : list) {
                int counter = 0;
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (!this.logIDList.contains(new BlockID(world, pos.x + x, pos.y + 1, pos.z + z))) continue;
                        newPosition = new Coord(pos.x + x, pos.y + 1, pos.z + z);
                        if (!listAbove.contains(newPosition)) {
                            listAbove.add(newPosition);
                        }
                        ++counter;
                    }
                }
                if (counter != 0) continue;
                listFinal.add(pos.clone());
            }
            int index = -1;
            while (++index < listAbove.size()) {
                Coord pos = (Coord)listAbove.get(index);
                for (x = -1; x <= 1; ++x) {
                    for (z = -1; z <= 1; ++z) {
                        if (!this.logIDList.contains(new BlockID(world, pos.x + x, pos.y, pos.z + z)) || listAbove.contains(newPosition = new Coord(pos.x + x, pos.y, pos.z + z))) continue;
                        listAbove.add(newPosition);
                    }
                }
            }
        } while (listAbove.size() > 0);
    }

    public List addLeaves(aab world, Coord pos) {
        int index = -1;
        ArrayList list = new ArrayList();
        this.addLeavesInDistance(world, pos, TreeCapitator.maxLeafBreakDist, list);
        while (++index < list.size()) {
            Coord pos2 = (Coord)list.get(index);
            this.addLeavesInDistance(world, pos2, 1, list);
        }
        return list;
    }

    public void addLeavesInDistance(aab world, Coord pos, int range, List list) {
        for (int x = -range; x <= range; ++x) {
            for (int y = -range; y <= range; ++y) {
                for (int z = -range; z <= range; ++z) {
                    Coord newPos;
                    int blockID = world.a(x + pos.x, y + pos.y, z + pos.z);
                    int md = world.h(x + pos.x, y + pos.y, z + pos.z);
                    apa block = apa.r[blockID];
                    if (!this.isLeafBlock(new BlockID(blockID, md)) && !this.vineID.equals((Object)new BlockID(blockID))) continue;
                    int metadata = world.h(x + pos.x, y + pos.y, z + pos.z);
                    if (TreeCapitator.requireLeafDecayCheck && ((metadata & 8) == 0 || (metadata & 4) != 0) || list.contains(newPos = new Coord(x + pos.x, y + pos.y, z + pos.z))) continue;
                    list.add(newPos);
                }
            }
        }
    }

    public void removeLeavesWithLogsAround(aab world, List list) {
        int i = 0;
        while (i < list.size()) {
            if (this.hasLogClose(world, (Coord)list.get(i), 1)) {
                list.remove(i);
                continue;
            }
            ++i;
        }
    }

    public boolean hasLogClose(aab world, Coord pos, int i) {
        for (int x = -i; x <= i; ++x) {
            for (int y = -i; y <= i; ++y) {
                for (int z = -i; z <= i; ++z) {
                    Coord neighbor = new Coord(x + pos.x, y + pos.y, z + pos.z);
                    int neighborID = world.a(neighbor.x, neighbor.y, neighbor.z);
                    if (x == 0 && y == 0 && z == 0 || neighborID == 0 || !TreeCapitator.logIDList.contains(new BlockID(world, neighbor.x, neighbor.y, neighbor.z)) || neighbor.equals((Object)this.startPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

