/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.BlockID;
import bspkrs.util.ListUtils;
import bspkrs.util.config.ConfigCategory;
import bspkrs.util.config.Configuration;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;

public class TreeDefinition {
    protected List<BlockID> logBlocks = new ArrayList<BlockID>();
    protected List<BlockID> leafBlocks = new ArrayList<BlockID>();
    protected boolean allowSmartTreeDetection = TCSettings.allowSmartTreeDetection;
    protected boolean onlyDestroyUpwards = TCSettings.onlyDestroyUpwards;
    protected boolean requireLeafDecayCheck = TCSettings.requireLeafDecayCheck;
    protected int maxHorLogBreakDist = TCSettings.maxHorLogBreakDist;
    protected int maxVerLogBreakDist = TCSettings.maxVerLogBreakDist;
    protected int maxLeafIDDist = TCSettings.maxLeafIDDist;
    protected int maxHorLeafBreakDist = TCSettings.maxHorLeafBreakDist;
    protected int minLeavesToID = TCSettings.minLeavesToID;
    protected float breakSpeedModifier = TCSettings.breakSpeedModifier;
    protected boolean useAdvancedTopLogLogic = TCSettings.useAdvancedTopLogLogic;
    private static List<String> orderedKeys = new ArrayList<String>();
    private static Set<String> validKeys = new HashSet<String>();

    public TreeDefinition() {
    }

    public String toString() {
        return "Logs: " + ListUtils.getListAsDelimitedString(this.logBlocks, (String)"; ") + "  Leaves: " + ListUtils.getListAsDelimitedString(this.leafBlocks, (String)"; ");
    }

    public TreeDefinition(List<BlockID> logs, List<BlockID> leaves) {
        this();
        this.logBlocks.addAll(logs);
        this.leafBlocks.addAll(leaves);
    }

    public TreeDefinition(NBTTagCompound tree) {
        this();
        this.readFromNBT(tree);
    }

    public TreeDefinition(Configuration config, String category) {
        this();
        this.readFromConfiguration(config, category);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TreeDefinition)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        TreeDefinition td = (TreeDefinition)o;
        return td.logBlocks.equals(this.logBlocks) && td.leafBlocks.equals(this.leafBlocks);
    }

    public int hashCode() {
        HashFunction hf = Hashing.md5();
        Hasher h = hf.newHasher();
        for (BlockID blockID : this.logBlocks) {
            h.putInt(blockID.hashCode());
        }
        for (BlockID blockID : this.leafBlocks) {
            h.putInt(blockID.hashCode() << 8);
        }
        return h.hash().hashCode();
    }

    public boolean hasCommonLog(TreeDefinition td) {
        for (BlockID blockID : td.logBlocks) {
            if (!this.logBlocks.contains(blockID)) continue;
            return true;
        }
        return false;
    }

    public boolean isLogBlock(BlockID blockID) {
        return this.logBlocks.contains(blockID);
    }

    public boolean isLeafBlock(BlockID blockID) {
        return this.leafBlocks.contains(blockID);
    }

    public TreeDefinition addLogID(BlockID blockID) {
        if (!this.isLogBlock(blockID)) {
            this.logBlocks.add(blockID);
        }
        return this;
    }

    public TreeDefinition addLeafID(BlockID blockID) {
        if (!this.isLeafBlock(blockID)) {
            this.leafBlocks.add(blockID);
        }
        return this;
    }

    public TreeDefinition addAllLogIDs(List<BlockID> blockIDs) {
        for (BlockID blockID : blockIDs) {
            if (this.isLogBlock(blockID)) continue;
            this.logBlocks.add(blockID);
        }
        return this;
    }

    public TreeDefinition addAllLeafIDs(List<BlockID> blockIDs) {
        for (BlockID blockID : blockIDs) {
            if (this.isLeafBlock(blockID)) continue;
            this.leafBlocks.add(blockID);
        }
        return this;
    }

    public TreeDefinition append(TreeDefinition toAdd) {
        for (BlockID blockID : toAdd.logBlocks) {
            if (this.logBlocks.contains(blockID)) continue;
            this.logBlocks.add(blockID);
        }
        for (BlockID blockID : toAdd.leafBlocks) {
            if (this.leafBlocks.contains(blockID)) continue;
            this.leafBlocks.add(blockID);
        }
        return this;
    }

    public TreeDefinition appendWithSettings(TreeDefinition toAdd) {
        this.append(toAdd);
        if (toAdd.allowSmartTreeDetection != TCSettings.allowSmartTreeDetection) {
            this.allowSmartTreeDetection = toAdd.allowSmartTreeDetection;
        }
        if (toAdd.onlyDestroyUpwards != TCSettings.onlyDestroyUpwards) {
            this.onlyDestroyUpwards = toAdd.onlyDestroyUpwards;
        }
        if (toAdd.requireLeafDecayCheck != TCSettings.requireLeafDecayCheck) {
            this.requireLeafDecayCheck = toAdd.requireLeafDecayCheck;
        }
        if (toAdd.maxHorLogBreakDist != TCSettings.maxHorLogBreakDist) {
            this.maxHorLogBreakDist = toAdd.maxHorLogBreakDist;
        }
        if (toAdd.maxHorLeafBreakDist != TCSettings.maxHorLeafBreakDist) {
            this.maxHorLeafBreakDist = toAdd.maxHorLeafBreakDist;
        }
        if (toAdd.maxLeafIDDist != TCSettings.maxLeafIDDist) {
            this.maxLeafIDDist = toAdd.maxLeafIDDist;
        }
        if (toAdd.minLeavesToID != TCSettings.minLeavesToID) {
            this.minLeavesToID = toAdd.minLeavesToID;
        }
        if (toAdd.breakSpeedModifier != TCSettings.breakSpeedModifier) {
            this.breakSpeedModifier = toAdd.breakSpeedModifier;
        }
        if (toAdd.useAdvancedTopLogLogic != TCSettings.useAdvancedTopLogLogic) {
            this.useAdvancedTopLogLogic = toAdd.useAdvancedTopLogLogic;
        }
        return this;
    }

    public static boolean isValidNBT(NBTTagCompound treeDefNBT) {
        for (String s : treeDefNBT.func_150296_c()) {
            if (validKeys.contains(s)) continue;
            TCLog.warning("Unknown tag \"%s\" found while verifying a TreeDefinition NBTTagCompound object", s);
        }
        if (!treeDefNBT.func_74764_b("treeName")) {
            TCLog.severe("TreeDefinition NBTTagCompound objects must contain a string tag with the key \"%s\"", "treeName");
            return false;
        }
        if (!treeDefNBT.func_74764_b("logs") && !treeDefNBT.func_74764_b("leaves")) {
            TCLog.severe("TreeDefinition NBTTagCompound objects must contain at least one string tag with the key \"%s\" or \"%s\"", "logs", "leaves");
            return false;
        }
        return true;
    }

    public TreeDefinition readFromNBT(NBTTagCompound treeDefNBT) {
        if (treeDefNBT.func_74764_b("allowSmartTreeDetection")) {
            this.allowSmartTreeDetection = treeDefNBT.func_74767_n("allowSmartTreeDetection");
        }
        if (treeDefNBT.func_74764_b("onlyDestroyUpwards")) {
            this.onlyDestroyUpwards = treeDefNBT.func_74767_n("onlyDestroyUpwards");
        }
        if (treeDefNBT.func_74764_b("requireLeafDecayCheck")) {
            this.requireLeafDecayCheck = treeDefNBT.func_74767_n("requireLeafDecayCheck");
        }
        if (treeDefNBT.func_74764_b("maxHorLogBreakDist")) {
            this.maxHorLogBreakDist = treeDefNBT.func_74762_e("maxHorLogBreakDist");
        }
        if (treeDefNBT.func_74764_b("maxVerLogBreakDist")) {
            this.maxVerLogBreakDist = treeDefNBT.func_74762_e("maxVerLogBreakDist");
        }
        if (treeDefNBT.func_74764_b("maxHorLeafBreakDist")) {
            this.maxHorLeafBreakDist = treeDefNBT.func_74762_e("maxHorLeafBreakDist");
        }
        if (treeDefNBT.func_74764_b("maxLeafIDDist")) {
            this.maxLeafIDDist = treeDefNBT.func_74762_e("maxLeafIDDist");
        }
        if (treeDefNBT.func_74764_b("minLeavesToID")) {
            this.minLeavesToID = treeDefNBT.func_74762_e("minLeavesToID");
        }
        if (treeDefNBT.func_74764_b("breakSpeedModifier")) {
            this.breakSpeedModifier = treeDefNBT.func_74760_g("breakSpeedModifier");
        }
        if (treeDefNBT.func_74764_b("useAdvancedTopLogLogic")) {
            this.useAdvancedTopLogLogic = treeDefNBT.func_74767_n("useAdvancedTopLogLogic");
        }
        this.logBlocks = treeDefNBT.func_74764_b("logs") && treeDefNBT.func_74779_i("logs").length() > 0 ? ListUtils.getDelimitedStringAsBlockIDList((String)treeDefNBT.func_74779_i("logs"), (String)";") : new ArrayList<BlockID>();
        this.leafBlocks = treeDefNBT.func_74764_b("leaves") && treeDefNBT.func_74779_i("leaves").length() > 0 ? ListUtils.getDelimitedStringAsBlockIDList((String)treeDefNBT.func_74779_i("leaves"), (String)";") : new ArrayList<BlockID>();
        return this;
    }

    public void writeToNBT(NBTTagCompound treeDefNBT) {
        treeDefNBT.func_74757_a("allowSmartTreeDetection", this.allowSmartTreeDetection);
        treeDefNBT.func_74757_a("onlyDestroyUpwards", this.onlyDestroyUpwards);
        treeDefNBT.func_74757_a("requireLeafDecayCheck", this.requireLeafDecayCheck);
        treeDefNBT.func_74768_a("maxHorLogBreakDist", this.maxHorLogBreakDist);
        treeDefNBT.func_74768_a("maxVerLogBreakDist", this.maxVerLogBreakDist);
        treeDefNBT.func_74768_a("maxHorLeafBreakDist", this.maxHorLeafBreakDist);
        treeDefNBT.func_74768_a("maxLeafIDDist", this.maxLeafIDDist);
        treeDefNBT.func_74768_a("minLeavesToID", this.minLeavesToID);
        treeDefNBT.func_74776_a("breakSpeedModifier", this.breakSpeedModifier);
        treeDefNBT.func_74757_a("useAdvancedTopLogLogic", this.useAdvancedTopLogLogic);
        treeDefNBT.func_74778_a("logs", ListUtils.getListAsDelimitedString(this.logBlocks, (String)";"));
        treeDefNBT.func_74778_a("leaves", ListUtils.getListAsDelimitedString(this.leafBlocks, (String)";"));
    }

    public TreeDefinition readFromConfiguration(Configuration config, String category) {
        ConfigCategory cc = config.getCategory(category);
        if (cc.containsKey("allowSmartTreeDetection")) {
            this.onlyDestroyUpwards = cc.get("allowSmartTreeDetection").setPropLanguageKey("bspkrs.tc.configgui.allowSmartTreeDetection").getBoolean(TCSettings.allowSmartTreeDetection);
        }
        if (cc.containsKey("onlyDestroyUpwards")) {
            this.onlyDestroyUpwards = cc.get("onlyDestroyUpwards").setPropLanguageKey("bspkrs.tc.configgui.onlyDestroyUpwards").getBoolean(TCSettings.onlyDestroyUpwards);
        }
        if (cc.containsKey("requireLeafDecayCheck")) {
            this.requireLeafDecayCheck = cc.get("requireLeafDecayCheck").setPropLanguageKey("bspkrs.tc.configgui.requireLeafDecayCheck").getBoolean(TCSettings.requireLeafDecayCheck);
        }
        if (cc.containsKey("maxHorLogBreakDist")) {
            this.maxHorLogBreakDist = cc.get("maxHorLogBreakDist").setPropLanguageKey("bspkrs.tc.configgui.maxHorLogBreakDist").getInt(TCSettings.maxHorLogBreakDist);
        }
        if (cc.containsKey("maxVerLogBreakDist")) {
            this.maxVerLogBreakDist = cc.get("maxVerLogBreakDist").setPropLanguageKey("bspkrs.tc.configgui.maxVerLogBreakDist").getInt(TCSettings.maxVerLogBreakDist);
        }
        if (cc.containsKey("maxHorLeafBreakDist")) {
            this.maxHorLeafBreakDist = cc.get("maxHorLeafBreakDist").setPropLanguageKey("bspkrs.tc.configgui.maxHorLeafBreakDist").getInt(TCSettings.maxHorLeafBreakDist);
        }
        if (cc.containsKey("maxLeafIDDist")) {
            this.maxLeafIDDist = cc.get("maxLeafIDDist").setPropLanguageKey("bspkrs.tc.configgui.maxLeafIDDist").getInt(TCSettings.maxLeafIDDist);
        }
        if (cc.containsKey("minLeavesToID")) {
            this.minLeavesToID = cc.get("minLeavesToID").setPropLanguageKey("bspkrs.tc.configgui.minLeavesToID").getInt();
        }
        if (cc.containsKey("breakSpeedModifier")) {
            this.breakSpeedModifier = (float)cc.get("breakSpeedModifier").setPropLanguageKey("bspkrs.tc.configgui.breakSpeedModifier").getDouble((double)TCSettings.breakSpeedModifier);
        }
        if (cc.containsKey("useAdvancedTopLogLogic")) {
            this.useAdvancedTopLogLogic = cc.get("useAdvancedTopLogLogic").setPropLanguageKey("bspkrs.tc.configgui.useAdvancedTopLogLogic").getBoolean(TCSettings.useAdvancedTopLogLogic);
        }
        if (cc.containsKey("logs")) {
            this.logBlocks = ListUtils.getDelimitedStringAsBlockIDList((String)cc.get("logs").setPropLanguageKey("bspkrs.tc.configgui.logs").getString(), (String)"; ");
        }
        if (cc.containsKey("leaves")) {
            this.leafBlocks = ListUtils.getDelimitedStringAsBlockIDList((String)cc.get("leaves").setPropLanguageKey("bspkrs.tc.configgui.leaves").getString(), (String)"; ");
        }
        cc.setPropertyOrder(orderedKeys);
        return this;
    }

    public void writeToConfiguration(Configuration config, String category) {
        if (this.allowSmartTreeDetection != TCSettings.allowSmartTreeDetection) {
            config.get(category, "allowSmartTreeDetection", TCSettings.allowSmartTreeDetection, "Optional").setValue(this.allowSmartTreeDetection).setPropLanguageKey("bspkrs.tc.configgui.allowSmartTreeDetection");
        }
        if (this.onlyDestroyUpwards != TCSettings.onlyDestroyUpwards) {
            config.get(category, "onlyDestroyUpwards", TCSettings.onlyDestroyUpwards, "Optional").setValue(this.onlyDestroyUpwards).setPropLanguageKey("bspkrs.tc.configgui.onlyDestroyUpwards");
        }
        if (this.requireLeafDecayCheck != TCSettings.requireLeafDecayCheck) {
            config.get(category, "requireLeafDecayCheck", TCSettings.requireLeafDecayCheck, "Optional").setValue(this.requireLeafDecayCheck).setPropLanguageKey("bspkrs.tc.configgui.requireLeafDecayCheck");
        }
        if (this.maxHorLogBreakDist != TCSettings.maxHorLogBreakDist) {
            config.get(category, "maxHorLogBreakDist", TCSettings.maxHorLogBreakDist, "Optional").setValue(this.maxHorLogBreakDist).setPropLanguageKey("bspkrs.tc.configgui.maxHorLogBreakDist");
        }
        if (this.maxVerLogBreakDist != TCSettings.maxVerLogBreakDist) {
            config.get(category, "maxVerLogBreakDist", TCSettings.maxVerLogBreakDist, "Optional").setValue(this.maxVerLogBreakDist).setPropLanguageKey("bspkrs.tc.configgui.maxVerLogBreakDist");
        }
        if (this.maxHorLeafBreakDist != TCSettings.maxHorLeafBreakDist) {
            config.get(category, "maxHorLeafBreakDist", TCSettings.maxHorLeafBreakDist, "Optional").setValue(this.maxHorLeafBreakDist).setPropLanguageKey("bspkrs.tc.configgui.maxHorLeafBreakDist");
        }
        if (this.maxLeafIDDist != TCSettings.maxLeafIDDist) {
            config.get(category, "maxLeafIDDist", TCSettings.maxLeafIDDist, "Optional").setValue(this.maxLeafIDDist).setPropLanguageKey("bspkrs.tc.configgui.maxLeafIDDist");
        }
        if (this.minLeavesToID != TCSettings.minLeavesToID) {
            config.get(category, "minLeavesToID", TCSettings.minLeavesToID, "Optional").setValue(this.minLeavesToID).setPropLanguageKey("bspkrs.tc.configgui.minLeavesToID");
        }
        if (this.breakSpeedModifier != TCSettings.breakSpeedModifier) {
            config.get(category, "breakSpeedModifier", (double)TCSettings.breakSpeedModifier, "Optional").setValue((double)this.breakSpeedModifier).setPropLanguageKey("bspkrs.tc.configgui.breakSpeedModifier");
        }
        if (this.useAdvancedTopLogLogic != TCSettings.useAdvancedTopLogLogic) {
            config.get(category, "useAdvancedTopLogLogic", TCSettings.useAdvancedTopLogLogic, "Optional").setValue(this.useAdvancedTopLogLogic).setPropLanguageKey("bspkrs.tc.configgui.useAdvancedTopLogLogic");
        }
        config.get(category, "logs", ListUtils.getListAsDelimitedString(this.logBlocks, (String)"; ")).setPropLanguageKey("bspkrs.tc.configgui.logs");
        config.get(category, "leaves", ListUtils.getListAsDelimitedString(this.leafBlocks, (String)"; ")).setPropLanguageKey("bspkrs.tc.configgui.leaves");
        config.setCategoryPropertyOrder(category, orderedKeys);
    }

    public TreeDefinition setAllowSmartTreeDetection(boolean allowSmartTreeDetection) {
        this.allowSmartTreeDetection = allowSmartTreeDetection;
        return this;
    }

    public TreeDefinition setOnlyDestroyUpwards(boolean onlyDestroyUpwards) {
        this.onlyDestroyUpwards = onlyDestroyUpwards;
        return this;
    }

    public TreeDefinition setRequireLeafDecayCheck(boolean requireLeafDecayCheck) {
        this.requireLeafDecayCheck = requireLeafDecayCheck;
        return this;
    }

    public TreeDefinition setMaxHorLogBreakDist(int maxHorLogBreakDist) {
        this.maxHorLogBreakDist = maxHorLogBreakDist;
        return this;
    }

    public TreeDefinition setMaxVerLogBreakDist(int maxVerLogBreakDist) {
        this.maxVerLogBreakDist = maxVerLogBreakDist;
        return this;
    }

    public TreeDefinition setMaxLeafIDDist(int maxLeafIDDist) {
        this.maxLeafIDDist = maxLeafIDDist;
        return this;
    }

    public TreeDefinition setMaxHorLeafBreakDist(int maxLeafBreakDist) {
        this.maxHorLeafBreakDist = maxLeafBreakDist;
        return this;
    }

    public TreeDefinition setMinLeavesToID(int minLeavesToID) {
        this.minLeavesToID = minLeavesToID;
        return this;
    }

    public TreeDefinition setBreakSpeedModifier(float breakSpeedModifier) {
        this.breakSpeedModifier = breakSpeedModifier;
        return this;
    }

    public TreeDefinition setUseAdvancedTopLogLogic(boolean useAdvancedTopLogLogic) {
        this.useAdvancedTopLogLogic = useAdvancedTopLogLogic;
        return this;
    }

    public List<BlockID> getLogList() {
        return this.logBlocks;
    }

    public List<BlockID> getLeafList() {
        return this.leafBlocks;
    }

    public boolean allowSmartTreeDetection() {
        return this.allowSmartTreeDetection;
    }

    public boolean onlyDestroyUpwards() {
        return this.onlyDestroyUpwards;
    }

    public boolean requireLeafDecayCheck() {
        return this.requireLeafDecayCheck;
    }

    public int maxHorLogBreakDist() {
        return this.maxHorLogBreakDist;
    }

    public int maxVerLogBreakDist() {
        return this.maxVerLogBreakDist;
    }

    public int maxLeafIDDist() {
        return this.maxLeafIDDist;
    }

    public int maxHorLeafBreakDist() {
        return this.maxHorLeafBreakDist;
    }

    public int minLeavesToID() {
        return this.minLeavesToID;
    }

    public float breakSpeedModifier() {
        return this.breakSpeedModifier;
    }

    public boolean useAdvancedTopLogLogic() {
        return this.useAdvancedTopLogLogic;
    }

    static {
        orderedKeys.add("logs");
        orderedKeys.add("leaves");
        orderedKeys.add("allowSmartTreeDetection");
        orderedKeys.add("maxLeafIDDist");
        orderedKeys.add("minLeavesToID");
        orderedKeys.add("onlyDestroyUpwards");
        orderedKeys.add("requireLeafDecayCheck");
        orderedKeys.add("maxHorLogBreakDist");
        orderedKeys.add("maxVerLogBreakDist");
        orderedKeys.add("maxHorLeafBreakDist");
        orderedKeys.add("breakSpeedModifier");
        orderedKeys.add("useAdvancedTopLogLogic");
        validKeys.add("treeName");
        validKeys.add("allowSmartTreeDetection");
        validKeys.add("onlyDestroyUpwards");
        validKeys.add("requireLeafDecayCheck");
        validKeys.add("maxHorLogBreakDist");
        validKeys.add("maxVerLogBreakDist");
        validKeys.add("maxHorLeafBreakDist");
        validKeys.add("maxLeafIDDist");
        validKeys.add("minLeavesToID");
        validKeys.add("breakSpeedModifier");
        validKeys.add("useAdvancedTopLogLogic");
        validKeys.add("logs");
        validKeys.add("leaves");
    }
}

