/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.directionhud;

import bspkrs.client.util.HUDUtils;
import bspkrs.directionhud.ConfigElement;
import bspkrs.directionhud.fml.Reference;
import bspkrs.util.CommonUtils;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import org.lwjgl.opengl.GL11;

public class DirectionHUD {
    protected static float zLevel = -100.0f;
    private static ScaledResolution scaledResolution;
    private static final boolean enabledDefault = true;
    public static boolean enabled;
    private static final String alignModeDefault = "topcenter";
    public static String alignMode;
    private static final String markerColorDefault = "c";
    public static String markerColor;
    private static final int compassIndexDefault = 0;
    public static int compassIndex;
    private static final int xOffsetDefault = 2;
    public static int xOffset;
    private static final int yOffsetDefault = 2;
    public static int yOffset;
    private static final int yOffsetBottomCenterDefault = 41;
    public static int yOffsetBottomCenter;
    private static final boolean applyXOffsetToCenterDefault = false;
    public static boolean applyXOffsetToCenter;
    private static final boolean applyYOffsetToMiddleDefault = false;
    public static boolean applyYOffsetToMiddle;
    private static final boolean showInChatDefault = true;
    public static boolean showInChat;

    public static void initConfig(File file) {
        Reference.config = new Configuration(file);
        if (!CommonUtils.isObfuscatedEnv()) {
            // empty if block
        }
        DirectionHUD.syncConfig();
    }

    public static void syncConfig() {
        String ctgyGen = "general";
        Reference.config.load();
        Reference.config.addCustomCategoryComment(ctgyGen, "ATTENTION: Editing this file manually is no longer necessary. \nType the command '/directionhud config' without the quotes in-game to modify these settings.");
        ArrayList<String> orderedKeys = new ArrayList<String>(ConfigElement.values().length);
        enabled = Reference.config.getBoolean(ConfigElement.ENABLED.key(), ctgyGen, true, ConfigElement.ENABLED.desc(), ConfigElement.ENABLED.languageKey());
        orderedKeys.add(ConfigElement.ENABLED.key());
        alignMode = Reference.config.getString(ConfigElement.ALIGN_MODE.key(), ctgyGen, alignModeDefault, ConfigElement.ALIGN_MODE.desc(), ConfigElement.ALIGN_MODE.validStrings(), ConfigElement.ALIGN_MODE.languageKey());
        orderedKeys.add(ConfigElement.ALIGN_MODE.key());
        markerColor = Reference.config.getString(ConfigElement.MARKER_COLOR.key(), ctgyGen, markerColorDefault, ConfigElement.MARKER_COLOR.desc(), ConfigElement.MARKER_COLOR.validStrings(), ConfigElement.MARKER_COLOR.languageKey());
        orderedKeys.add(ConfigElement.MARKER_COLOR.key());
        compassIndex = Reference.config.getInt(ConfigElement.COMPASS_INDEX.key(), ctgyGen, 0, 0, 9, ConfigElement.COMPASS_INDEX.desc(), ConfigElement.COMPASS_INDEX.languageKey());
        orderedKeys.add(ConfigElement.COMPASS_INDEX.key());
        showInChat = Reference.config.getBoolean(ConfigElement.SHOW_IN_CHAT.key(), ctgyGen, true, ConfigElement.SHOW_IN_CHAT.desc(), ConfigElement.SHOW_IN_CHAT.languageKey());
        orderedKeys.add(ConfigElement.SHOW_IN_CHAT.key());
        xOffset = Reference.config.getInt(ConfigElement.X_OFFSET.key(), ctgyGen, 2, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.X_OFFSET.desc(), ConfigElement.X_OFFSET.languageKey());
        orderedKeys.add(ConfigElement.X_OFFSET.key());
        applyXOffsetToCenter = Reference.config.getBoolean(ConfigElement.APPLY_X_OFFSET_TO_CENTER.key(), ctgyGen, false, ConfigElement.APPLY_X_OFFSET_TO_CENTER.desc(), ConfigElement.APPLY_X_OFFSET_TO_CENTER.languageKey());
        orderedKeys.add(ConfigElement.APPLY_X_OFFSET_TO_CENTER.key());
        yOffset = Reference.config.getInt(ConfigElement.Y_OFFSET.key(), ctgyGen, 2, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.Y_OFFSET.desc(), ConfigElement.Y_OFFSET.languageKey());
        orderedKeys.add(ConfigElement.Y_OFFSET.key());
        applyYOffsetToMiddle = Reference.config.getBoolean(ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.key(), ctgyGen, false, ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.desc(), ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.languageKey());
        orderedKeys.add(ConfigElement.APPLY_Y_OFFSET_TO_MIDDLE.key());
        yOffsetBottomCenter = Reference.config.getInt(ConfigElement.Y_OFFSET_BOTTOM_CENTER.key(), ctgyGen, 41, Integer.MIN_VALUE, Integer.MAX_VALUE, ConfigElement.Y_OFFSET_BOTTOM_CENTER.desc(), ConfigElement.Y_OFFSET_BOTTOM_CENTER.languageKey());
        orderedKeys.add(ConfigElement.Y_OFFSET_BOTTOM_CENTER.key());
        Reference.config.setCategoryPropertyOrder(ctgyGen, orderedKeys);
        Reference.config.save();
    }

    public static boolean onTickInGame(Minecraft mc) {
        if (enabled && (mc.field_71415_G || mc.field_71462_r == null || mc.field_71462_r instanceof GuiChat && showInChat) && !mc.field_71474_y.field_74330_P) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            DirectionHUD.displayHUD(mc);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        return true;
    }

    private static int getX(int width) {
        if (alignMode.equalsIgnoreCase(alignModeDefault) || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78326_a() / 2 - width / 2 + (applyXOffsetToCenter ? xOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("topright") || alignMode.equalsIgnoreCase("middleright") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78326_a() - width - xOffset;
        }
        return xOffset;
    }

    private static int getY(int rowCount, int height) {
        if (alignMode.equalsIgnoreCase("middleleft") || alignMode.equalsIgnoreCase("middlecenter") || alignMode.equalsIgnoreCase("middleright")) {
            return scaledResolution.func_78328_b() / 2 - rowCount * height / 2 + (applyYOffsetToMiddle ? yOffset : 0);
        }
        if (alignMode.equalsIgnoreCase("bottomleft") || alignMode.equalsIgnoreCase("bottomright")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffset;
        }
        if (alignMode.equalsIgnoreCase("bottomcenter")) {
            return scaledResolution.func_78328_b() - rowCount * height - yOffsetBottomCenter;
        }
        return yOffset;
    }

    private static void displayHUD(Minecraft mc) {
        int direction = MathHelper.func_76128_c((double)((double)(mc.field_71439_g.field_70177_z * 256.0f / 360.0f) + 0.5)) & 0xFF;
        int yBase = DirectionHUD.getY(1, 12);
        int xBase = DirectionHUD.getX(65);
        mc.func_110434_K().func_110577_a(new ResourceLocation("DirectionHUD:textures/gui/compass.png"));
        if (direction < 128) {
            HUDUtils.drawTexturedModalRect((int)xBase, (int)yBase, (int)direction, (int)(compassIndex * 24), (int)65, (int)12, (float)zLevel);
        } else {
            HUDUtils.drawTexturedModalRect((int)xBase, (int)yBase, (int)(direction - 128), (int)(compassIndex * 24 + 12), (int)65, (int)12, (float)zLevel);
        }
        mc.field_71466_p.func_78276_b("\u00a7" + markerColor.toLowerCase() + "|", xBase + 32, yBase + 1, 0xFFFFFF);
        mc.field_71466_p.func_78276_b("\u00a7" + markerColor.toLowerCase() + "|\u00a7r", xBase + 32, yBase + 5, 0xFFFFFF);
    }

    static {
        enabled = true;
        alignMode = alignModeDefault;
        markerColor = markerColorDefault;
        compassIndex = 0;
        xOffset = 2;
        yOffset = 2;
        yOffsetBottomCenter = 41;
        applyXOffsetToCenter = false;
        applyYOffsetToMiddle = false;
        showInChat = true;
    }
}

