/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_mobEquipment", name="Dynamic Lights on Mob Equipment", version="1.0.3", dependencies="required-after:DynamicLights")
public class EntityLivingEquipmentLightSource {
    private Minecraft mcinstance;
    private long nextUpdate;
    private long updateInterval;
    private ArrayList<EntityLightAdapter> trackedEntities;
    private Thread thread;
    private boolean threadRunning;
    private HashMap<Integer, Integer> itemsMap;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        String[] tokens;
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property updateI = config.get("general", "update Interval", 1000);
        updateI.comment = "Update Interval time for all EntityLiving in milliseconds. The lower the better and costlier.";
        this.updateInterval = updateI.getInt();
        this.itemsMap = new HashMap();
        Property itemsList = config.get("general", "LightItems", "50:15,89:12,348:10,91:15,327:15,76:10,331:10,314:14,418:15");
        itemsList.comment = "Item and Armor IDs that shine light when found on any EntityLiving. Syntax: ItemID:LightValue, seperated by commas";
        for (String pair : tokens = itemsList.getString().split(",")) {
            String[] values = pair.split(":");
            int id = Integer.valueOf(values[0]);
            int value = Integer.valueOf(values[1]);
            this.itemsMap.put(id, value);
        }
        config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        this.mcinstance = FMLClientHandler.instance().getClient();
        this.nextUpdate = System.currentTimeMillis();
        this.trackedEntities = new ArrayList();
        this.threadRunning = false;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    private int getEquipmentLightLevel(EntityLivingBase ent) {
        if (ent instanceof EntityHorse) {
            String horseArmorTexture = ((EntityHorse)ent).func_110212_cp()[2];
            if (horseArmorTexture.equals("textures/entity/horse/armor/horse_armor_gold.png")) {
                return this.getLightFromItemStack(new ItemStack(Item.field_111216_cf));
            }
            if (horseArmorTexture.equals("textures/entity/horse/armor/horse_armor_iron.png")) {
                return this.getLightFromItemStack(new ItemStack(Item.field_111215_ce));
            }
            if (horseArmorTexture.equals("textures/entity/horse/armor/horse_armor_diamond.png")) {
                return this.getLightFromItemStack(new ItemStack(Item.field_111213_cg));
            }
        }
        return this.getMobEquipMaxLight(ent);
    }

    private int getMobEquipMaxLight(EntityLivingBase ent) {
        int light = this.getLightFromItemStack(ent.func_71124_b(0));
        for (int i = 1; i < ent.func_70035_c().length; ++i) {
            light = Math.max(light, this.getLightFromItemStack(ent.func_70035_c()[i]));
        }
        return light;
    }

    private int getLightFromItemStack(ItemStack stack) {
        Integer i;
        if (stack != null && (i = this.itemsMap.get(stack.field_77993_c)) != null) {
            return i;
        }
        return 0;
    }

    private class EntityLightAdapter
    implements IDynamicLightSource {
        private EntityLivingBase entity;
        private int lightLevel = 0;
        private boolean enabled = false;

        public EntityLightAdapter(EntityLivingBase e) {
            this.entity = e;
        }

        public void onTick() {
            this.lightLevel = EntityLivingEquipmentLightSource.this.getMobEquipMaxLight(this.entity);
            if (this.entity.getEntityData().func_74779_i("InfernalMobsMod") != null) {
                this.lightLevel = 15;
            }
            if (!this.enabled && this.lightLevel > 0) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 1) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public Entity getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.lightLevel;
        }
    }

    private class EntityListChecker
    extends Thread {
        private final Object[] list;

        public EntityListChecker(List<Entity> input) {
            this.list = input.toArray();
        }

        @Override
        public void run() {
            ArrayList<EntityLightAdapter> newList = new ArrayList<EntityLightAdapter>();
            for (Object o : this.list) {
                Entity ent = (Entity)o;
                if (!(ent instanceof EntityLivingBase) || !ent.func_70089_S() || ent instanceof EntityPlayer || EntityLivingEquipmentLightSource.this.getEquipmentLightLevel((EntityLivingBase)ent) <= 0) continue;
                boolean found = false;
                Iterator iter = EntityLivingEquipmentLightSource.this.trackedEntities.iterator();
                EntityLightAdapter adapter = null;
                while (iter.hasNext()) {
                    adapter = (EntityLightAdapter)iter.next();
                    if (!adapter.getAttachmentEntity().equals((Object)ent)) continue;
                    adapter.onTick();
                    newList.add(adapter);
                    found = true;
                    iter.remove();
                    break;
                }
                if (found) continue;
                adapter = new EntityLightAdapter((EntityLivingBase)ent);
                adapter.onTick();
                newList.add(adapter);
            }
            for (EntityLightAdapter adapter : EntityLivingEquipmentLightSource.this.trackedEntities) {
                adapter.onTick();
            }
            EntityLivingEquipmentLightSource.this.trackedEntities = newList;
            EntityLivingEquipmentLightSource.this.threadRunning = false;
        }
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet<TickType> ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            if (((EntityLivingEquipmentLightSource)EntityLivingEquipmentLightSource.this).mcinstance.field_71441_e != null && System.currentTimeMillis() > EntityLivingEquipmentLightSource.this.nextUpdate && !DynamicLights.globalLightsOff()) {
                EntityLivingEquipmentLightSource.this.nextUpdate = System.currentTimeMillis() + EntityLivingEquipmentLightSource.this.updateInterval;
                if (!EntityLivingEquipmentLightSource.this.threadRunning) {
                    EntityLivingEquipmentLightSource.this.thread = new EntityListChecker(((EntityLivingEquipmentLightSource)EntityLivingEquipmentLightSource.this).mcinstance.field_71441_e.field_72996_f);
                    EntityLivingEquipmentLightSource.this.thread.setPriority(1);
                    EntityLivingEquipmentLightSource.this.thread.start();
                    EntityLivingEquipmentLightSource.this.threadRunning = true;
                }
            }
        }

        public EnumSet<TickType> ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_onFire";
        }
    }
}

