/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.modules;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import atomicstryker.dynamiclights.client.ItemConfigHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.util.EnumSet;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

@Mod(modid="DynamicLights_thePlayer", name="Dynamic Lights Player Light", version="1.0.9", dependencies="required-after:DynamicLights")
public class PlayerSelfLightSource
implements IDynamicLightSource {
    private EntityPlayer thePlayer;
    private World lastWorld;
    private int lightLevel;
    private boolean enabled;
    private ItemConfigHelper itemsMap;
    private ItemConfigHelper notWaterProofItems;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Configuration config = new Configuration(evt.getSuggestedConfigurationFile());
        config.load();
        Property itemsList = config.get("general", "LightItems", "50,89=12,348=10,91,327,76=10,331=10,314=14,418=15");
        itemsList.comment = "Item IDs that shine light while held. Armor Items also work when worn. [ONLY ON YOURSELF]";
        this.itemsMap = new ItemConfigHelper(itemsList.getString(), 15);
        Property notWaterProofList = config.get("general", "TurnedOffByWaterItems", "50,327");
        notWaterProofList.comment = "Item IDs that do not shine light when held in water, have to be present in LightItems.";
        this.notWaterProofItems = new ItemConfigHelper(notWaterProofList.getString(), 1);
        config.save();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        this.lightLevel = 0;
        this.enabled = false;
        this.lastWorld = null;
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
    }

    private int getLightFromItemStack(ItemStack stack) {
        if (stack != null) {
            int r = this.itemsMap.retrieveValue(stack.field_77993_c, stack.func_77960_j());
            return r < 0 ? 0 : r;
        }
        return 0;
    }

    private void enableLight() {
        DynamicLights.addLightSource(this);
        this.enabled = true;
    }

    private void disableLight() {
        DynamicLights.removeLightSource(this);
        this.enabled = false;
    }

    @Override
    public Entity getAttachmentEntity() {
        return this.thePlayer;
    }

    @Override
    public int getLightLevel() {
        return this.lightLevel;
    }

    private class TickHandler
    implements ITickHandler {
        private final EnumSet<TickType> ticks = EnumSet.of(TickType.CLIENT);

        public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        }

        public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
            if (PlayerSelfLightSource.this.lastWorld != FMLClientHandler.instance().getClient().field_71441_e || PlayerSelfLightSource.this.thePlayer != FMLClientHandler.instance().getClient().field_71439_g) {
                PlayerSelfLightSource.this.thePlayer = (EntityPlayer)FMLClientHandler.instance().getClient().field_71439_g;
                if (PlayerSelfLightSource.this.thePlayer != null) {
                    PlayerSelfLightSource.this.lastWorld = ((PlayerSelfLightSource)PlayerSelfLightSource.this).thePlayer.field_70170_p;
                } else {
                    PlayerSelfLightSource.this.lastWorld = null;
                }
            }
            if (PlayerSelfLightSource.this.thePlayer != null && PlayerSelfLightSource.this.thePlayer.func_70089_S() && !DynamicLights.globalLightsOff()) {
                int prevLight = PlayerSelfLightSource.this.lightLevel;
                ItemStack item = PlayerSelfLightSource.this.thePlayer.func_71045_bC();
                PlayerSelfLightSource.this.lightLevel = PlayerSelfLightSource.this.getLightFromItemStack(item);
                for (ItemStack armor : ((PlayerSelfLightSource)PlayerSelfLightSource.this).thePlayer.field_71071_by.field_70460_b) {
                    PlayerSelfLightSource.this.lightLevel = Math.max(PlayerSelfLightSource.this.lightLevel, PlayerSelfLightSource.this.getLightFromItemStack(armor));
                }
                if (prevLight != 0 && PlayerSelfLightSource.this.lightLevel != prevLight) {
                    PlayerSelfLightSource.this.lightLevel = 0;
                } else if (PlayerSelfLightSource.this.thePlayer.func_70027_ad()) {
                    PlayerSelfLightSource.this.lightLevel = 15;
                } else if (this.checkPlayerWater(PlayerSelfLightSource.this.thePlayer) && item != null && PlayerSelfLightSource.this.notWaterProofItems.retrieveValue(item.field_77993_c, item.func_77960_j()) == 1) {
                    PlayerSelfLightSource.this.lightLevel = 0;
                    for (ItemStack armor : ((PlayerSelfLightSource)PlayerSelfLightSource.this).thePlayer.field_71071_by.field_70460_b) {
                        if (armor == null || PlayerSelfLightSource.this.notWaterProofItems.retrieveValue(armor.field_77993_c, item.func_77960_j()) != 0) continue;
                        PlayerSelfLightSource.this.lightLevel = Math.max(PlayerSelfLightSource.this.lightLevel, PlayerSelfLightSource.this.getLightFromItemStack(armor));
                    }
                }
                if (!PlayerSelfLightSource.this.enabled && PlayerSelfLightSource.this.lightLevel > 0) {
                    PlayerSelfLightSource.this.enableLight();
                } else if (PlayerSelfLightSource.this.enabled && PlayerSelfLightSource.this.lightLevel < 1) {
                    PlayerSelfLightSource.this.disableLight();
                }
            }
        }

        private boolean checkPlayerWater(EntityPlayer thePlayer) {
            if (thePlayer.func_70090_H()) {
                int z;
                int y;
                int x = MathHelper.func_76128_c((double)(thePlayer.field_70165_t + 0.5));
                return thePlayer.field_70170_p.func_72803_f(x, y = MathHelper.func_76128_c((double)(thePlayer.field_70163_u + (double)thePlayer.func_70047_e())), z = MathHelper.func_76128_c((double)(thePlayer.field_70161_v + 0.5))) == Material.field_76244_g;
            }
            return false;
        }

        public EnumSet<TickType> ticks() {
            return this.ticks;
        }

        public String getLabel() {
            return "DynamicLights_thePlayer";
        }
    }
}

