/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client;

import atomicstryker.dynamiclights.client.CommonProxy;
import atomicstryker.dynamiclights.client.DynamicLightSourceContainer;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import atomicstryker.dynamiclights.client.adaptors.BaseAdaptor;
import atomicstryker.dynamiclights.client.adaptors.PlayerSelfAdaptor;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

@Mod(modid="DynamicLights", name="Dynamic Lights", version="1.3.9a", acceptedMinecraftVersions="1.7.10")
public class DynamicLights {
    public static final String modId = "DynamicLights";
    static Minecraft mcinstance;
    static PlayerSelfAdaptor thePlayer;
    private static IBlockAccess lastWorld;
    private static ConcurrentLinkedQueue<DynamicLightSourceContainer> lastList;
    static ArrayList<BaseAdaptor> trackedEntities;
    static ConcurrentHashMap<World, ConcurrentLinkedQueue<DynamicLightSourceContainer>> worldLightsMap;
    public static boolean globalLightsOff;
    static long nextLightUpdateTime;
    static KeyBinding toggleButton;
    static long nextKeyTriggerTime;
    static boolean coloredLights;
    public static boolean fmlOverrideEnable;
    public static HashMap<Class<? extends Entity>, Boolean> lightValueMap;
    public static HashMap<Class<? extends Entity>, Integer> glowValueMap;
    @SidedProxy(clientSide="atomicstryker.dynamiclights.client.ClientProxy", serverSide="atomicstryker.dynamiclights.client.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        proxy.preInit(evt);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxy.init();
    }

    public static int getLightValue(IBlockAccess world, Block block, int x, int y, int z) {
        int vanillaValue = block.getLightValue(world, x, y, z);
        if (globalLightsOff || world instanceof WorldServer) {
            return vanillaValue;
        }
        if (!world.equals(lastWorld) || lastList == null) {
            lastWorld = world;
            lastList = worldLightsMap.get(world);
        }
        int dynamicValue = 0;
        if (lastList != null && !lastList.isEmpty()) {
            for (DynamicLightSourceContainer light : lastList) {
                if (light.getX() != x || light.getY() != y || light.getZ() != z) continue;
                dynamicValue = DynamicLights.maxLight(dynamicValue, light.getLightSource().getLightLevel());
            }
        }
        return DynamicLights.maxLight(vanillaValue, dynamicValue);
    }

    public static void addLightSource(IDynamicLightSource lightToAdd) {
        if (lightToAdd.getAttachmentEntity() != null) {
            if (lightToAdd.getAttachmentEntity().func_70089_S()) {
                DynamicLightSourceContainer newLightContainer = new DynamicLightSourceContainer(lightToAdd);
                ConcurrentLinkedQueue<DynamicLightSourceContainer> lightList = worldLightsMap.get(lightToAdd.getAttachmentEntity().field_70170_p);
                if (lightList != null) {
                    if (!lightList.contains(newLightContainer)) {
                        lightList.add(newLightContainer);
                    } else {
                        System.out.println("Cannot add Dynamic Light: Attachment Entity is already registered!");
                    }
                } else {
                    lightList = new ConcurrentLinkedQueue();
                    lightList.add(newLightContainer);
                    worldLightsMap.put(lightToAdd.getAttachmentEntity().field_70170_p, lightList);
                }
            } else {
                System.err.println("Cannot add Dynamic Light: Attachment Entity is dead!");
            }
        } else {
            System.err.println("Cannot add Dynamic Light: Attachment Entity is null!");
        }
    }

    public static void removeLightSource(IDynamicLightSource lightToRemove) {
        World world;
        if (lightToRemove != null && lightToRemove.getAttachmentEntity() != null && (world = lightToRemove.getAttachmentEntity().field_70170_p) != null) {
            DynamicLightSourceContainer iterContainer = null;
            ConcurrentLinkedQueue<DynamicLightSourceContainer> lightList = worldLightsMap.get(world);
            if (lightList != null) {
                Iterator<DynamicLightSourceContainer> iter = lightList.iterator();
                while (iter.hasNext()) {
                    iterContainer = iter.next();
                    if (!iterContainer.getLightSource().equals(lightToRemove)) continue;
                    iter.remove();
                    break;
                }
                if (iterContainer != null) {
                    world.func_147463_c(EnumSkyBlock.Block, iterContainer.getX(), iterContainer.getY(), iterContainer.getZ());
                }
            }
        }
    }

    public static int maxLight(int a, int b) {
        if (coloredLights) {
            if (((0x100000 | b) - a & 0x84210) > 0) {
                return a;
            }
            return b;
        }
        return Math.max(a, b);
    }
}

