/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client;

import atomicstryker.dynamiclights.client.Config;
import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.adaptors.BrightAdaptor;
import atomicstryker.dynamiclights.client.adaptors.CreeperAdaptor;
import atomicstryker.dynamiclights.client.adaptors.EntityBurningAdaptor;
import atomicstryker.dynamiclights.client.adaptors.EntityItemAdaptor;
import atomicstryker.dynamiclights.client.adaptors.FloodLightAdaptor;
import atomicstryker.dynamiclights.client.adaptors.MobLightAdaptor;
import atomicstryker.dynamiclights.client.adaptors.PlayerOtherAdaptor;
import atomicstryker.dynamiclights.client.adaptors.PlayerSelfAdaptor;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

public class ForgeEventHandler {
    @SubscribeEvent
    public void onJoinWorld(EntityJoinWorldEvent event) {
        if (!event.world.field_72995_K) {
            return;
        }
        Entity entity = event.entity;
        if (!entity.func_70089_S()) {
            return;
        }
        if (entity instanceof EntityItem) {
            if (!Config.lightDroppedItems) {
                return;
            }
            EntityItemAdaptor adapter = new EntityItemAdaptor((EntityItem)entity);
            adapter.onTick();
            DynamicLights.trackedEntities.add(adapter);
        } else if (entity instanceof EntityLivingBase && !(entity instanceof EntityPlayer)) {
            int value;
            int minLight = 0;
            int catchesFire = 0;
            if (Config.lightBurningEntities) {
                if (!DynamicLights.lightValueMap.containsKey(entity.getClass())) {
                    value = Config.getMobFire(entity.getClass().getSimpleName());
                    DynamicLights.lightValueMap.put(entity.getClass(), value != 0);
                    catchesFire = value;
                } else {
                    catchesFire = DynamicLights.lightValueMap.get(entity.getClass()).booleanValue();
                }
            }
            if (Config.lightGlowingEntities) {
                if (!DynamicLights.glowValueMap.containsKey(entity.getClass())) {
                    value = Config.getMobGlow(entity);
                    DynamicLights.glowValueMap.put(entity.getClass(), value);
                    minLight = value;
                } else {
                    minLight = DynamicLights.glowValueMap.get(entity.getClass());
                }
            }
            if (catchesFire != 0) {
                EntityBurningAdaptor adaptor = new EntityBurningAdaptor(entity);
                adaptor.minLight = minLight;
                adaptor.onTick();
                DynamicLights.trackedEntities.add(adaptor);
            } else if (minLight > 0) {
                BrightAdaptor adaptor = new BrightAdaptor(entity, minLight);
                adaptor.onTick();
                DynamicLights.trackedEntities.add(adaptor);
            }
            if (Config.lightMobEquipment) {
                MobLightAdaptor adapter = new MobLightAdaptor((Entity)((EntityLivingBase)entity));
                adapter.onTick();
                DynamicLights.trackedEntities.add(adapter);
            }
        } else if (entity instanceof EntityArrow || entity instanceof EntityFireball) {
            if (!Config.lightFlamingArrows) {
                return;
            }
            EntityBurningAdaptor adapter = new EntityBurningAdaptor(entity);
            adapter.onTick();
            DynamicLights.trackedEntities.add(adapter);
        } else if (entity instanceof EntityXPOrb) {
            if (!Config.lightXP) {
                return;
            }
            BrightAdaptor adapter = new BrightAdaptor(entity, 10);
            adapter.onTick();
            DynamicLights.trackedEntities.add(adapter);
        } else if (entity instanceof EntityOtherPlayerMP) {
            if (!Config.lightOtherPlayers) {
                return;
            }
            PlayerOtherAdaptor adapter = new PlayerOtherAdaptor((EntityPlayer)((EntityOtherPlayerMP)entity));
            adapter.onTick();
            DynamicLights.trackedEntities.add(adapter);
        } else if (entity instanceof EntityPlayerSP) {
            if (Config.lightFloodLight) {
                FloodLightAdaptor adaptor = new FloodLightAdaptor(entity, Config.simpleMode);
                adaptor.onTick();
                DynamicLights.trackedEntities.add(adaptor);
            }
            if (!Config.lightThisPlayer) {
                return;
            }
            DynamicLights.thePlayer = new PlayerSelfAdaptor((EntityPlayer)entity);
            DynamicLights.thePlayer.onTick();
            DynamicLights.trackedEntities.add(DynamicLights.thePlayer);
            this.checkForOptifine();
        }
    }

    private void checkForOptifine() {
        if (FMLClientHandler.instance().hasOptifine() && !Config.optifineOverride) {
            DynamicLights.mcinstance.field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("Optifine is loaded.  Disabling Atomic Stryker's Dynamic Lights.  Check the config file to override."));
            DynamicLights.globalLightsOff = true;
        }
    }

    @SubscribeEvent
    public void onPlaySoundAtEntity(PlaySoundAtEntityEvent event) {
        if (Config.lightChargingCreepers && event.name != null && event.name.equals("creeper.primed") && event.entity != null && event.entity instanceof EntityCreeper && event.entity.func_70089_S()) {
            CreeperAdaptor creeper = new CreeperAdaptor((EntityCreeper)event.entity);
            creeper.onTick();
            DynamicLights.addLightSource(creeper);
        }
    }
}

