/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.adaptors;

import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.IDynamicLightSource;
import net.minecraft.entity.Entity;

public class BaseAdaptor
implements IDynamicLightSource {
    protected Entity entity;
    protected int lightLevel;
    protected boolean enabled;

    BaseAdaptor(Entity entity) {
        this.entity = entity;
        this.lightLevel = 0;
        this.enabled = false;
    }

    @Override
    public Entity getAttachmentEntity() {
        return this.entity;
    }

    @Override
    public int getLightLevel() {
        return this.lightLevel;
    }

    public void enableLight() {
        DynamicLights.addLightSource(this);
        this.enabled = true;
    }

    public void disableLight() {
        DynamicLights.removeLightSource(this);
        this.enabled = false;
    }

    protected void checkForchange() {
        if (!this.enabled && this.lightLevel > 0) {
            this.enableLight();
        } else if (this.enabled && this.lightLevel < 1) {
            this.disableLight();
        }
    }

    public void onTick() {
        this.checkForchange();
    }
}

