/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.client.adaptors;

import atomicstryker.dynamiclights.client.Config;
import atomicstryker.dynamiclights.client.DynamicLights;
import atomicstryker.dynamiclights.client.adaptors.BaseAdaptor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class FloodLightAdaptor
extends BaseAdaptor {
    private EntityPlayer thePlayer;
    private final PartialLightAdaptor[] partialLights;
    private final boolean simpleMode;
    private final float beamStrength = 16.0f;

    public FloodLightAdaptor(Entity entity, boolean simpleMode) {
        super(entity);
        this.thePlayer = (EntityPlayer)entity;
        this.simpleMode = simpleMode;
        this.partialLights = simpleMode ? new PartialLightAdaptor[1] : new PartialLightAdaptor[5];
    }

    @Override
    public void onTick() {
        if (this.thePlayer != null && this.thePlayer.func_70089_S() && !DynamicLights.globalLightsOff) {
            int lightLevel = Config.floodLights.getLightFromItemStack(this.thePlayer.func_71045_bC());
            this.checkDummyInit(this.thePlayer.field_70170_p);
            if (lightLevel > 0) {
                this.handleLight(this.partialLights[0], lightLevel, 0.0f, 0.0f);
                if (!this.simpleMode) {
                    this.handleLight(this.partialLights[1], lightLevel, 12.0f, 9.0f);
                    this.handleLight(this.partialLights[2], lightLevel, 9.0f, -12.0f);
                    this.handleLight(this.partialLights[3], lightLevel, -12.0f, -9.0f);
                    this.handleLight(this.partialLights[4], lightLevel, -9.0f, 12.0f);
                }
                this.setLightsEnabled(true);
            } else {
                this.setLightsEnabled(false);
            }
        }
    }

    private void handleLight(PartialLightAdaptor source, int light, float yawRot, float pitchRot) {
        Vec3 origin = this.thePlayer.func_70666_h(1.0f);
        Vec3 look = FloodLightAdaptor.getVector(this.thePlayer.field_70177_z + yawRot, this.thePlayer.field_70125_A + pitchRot);
        look = origin.func_72441_c(look.field_72450_a * 16.0, look.field_72448_b * 16.0, look.field_72449_c * 16.0);
        MovingObjectPosition mop = this.thePlayer.field_70170_p.func_72933_a(origin, look);
        if (mop != null) {
            int dist = (int)Math.round(this.thePlayer.func_70011_f(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c));
            source.lightLevel = Math.max(0, light - dist);
            source.entity.field_70165_t = mop.field_72307_f.field_72450_a;
            source.entity.field_70163_u = mop.field_72307_f.field_72448_b;
            source.entity.field_70161_v = mop.field_72307_f.field_72449_c;
        } else {
            source.lightLevel = 0;
        }
        source.onTick();
    }

    public static Vec3 getVector(float rotYaw, float rotPitch) {
        float f1 = MathHelper.func_76134_b((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = MathHelper.func_76126_a((float)(-rotYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = -MathHelper.func_76134_b((float)(-rotPitch * ((float)Math.PI / 180)));
        float f4 = MathHelper.func_76126_a((float)(-rotPitch * ((float)Math.PI / 180)));
        return Vec3.func_72443_a((double)(f2 * f3), (double)f4, (double)(f1 * f3));
    }

    @Override
    public void disableLight() {
        this.setLightsEnabled(false);
        super.disableLight();
    }

    private void setLightsEnabled(boolean newEnabled) {
        if (newEnabled != this.enabled) {
            this.enabled = newEnabled;
            for (PartialLightAdaptor p : this.partialLights) {
                if (newEnabled) {
                    p.onTick();
                    continue;
                }
                p.lightLevel = 0;
                p.onTick();
            }
        }
    }

    private void checkDummyInit(World world) {
        if (this.partialLights[0] == null) {
            for (int i = 0; i < this.partialLights.length; ++i) {
                this.partialLights[i] = new PartialLightAdaptor(new DummyEntity(world));
                this.partialLights[i].onTick();
            }
        }
    }

    private class DummyEntity
    extends Entity {
        public DummyEntity(World par1World) {
            super(par1World);
        }

        protected void func_70088_a() {
        }

        protected void func_70037_a(NBTTagCompound var1) {
        }

        protected void func_70014_b(NBTTagCompound var1) {
        }
    }

    private class PartialLightAdaptor
    extends BaseAdaptor {
        PartialLightAdaptor(Entity entity) {
            super(entity);
        }
    }
}

