/*
 * Decompiled with CFR 0.152.
 */
package backpack.gui.parts;

import backpack.gui.helper.GuiRectangle;
import backpack.gui.parts.GuiPart;
import backpack.inventory.container.ContainerAdvanced;
import backpack.inventory.slot.SlotScrolling;
import backpack.misc.ConfigurationBackpack;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public abstract class GuiPartScrolling
extends GuiPart {
    protected boolean hasScrollbar;
    protected int scrollbarOffset = -6;
    protected GuiRectangle slider;
    protected GuiRectangle scrollbar;
    protected boolean isSliding = false;
    protected float currentScroll = 0.0f;

    public GuiPartScrolling(ContainerAdvanced container, IInventory inventory, int inventoryRows, int inventoryCols, boolean big) {
        super(container, inventory, inventoryRows, inventoryCols, big);
        this.hasScrollbar = big ? inventoryRows > ConfigurationBackpack.DISPLAY_ROWS_L : inventoryRows > ConfigurationBackpack.DISPLAY_ROWS_S;
    }

    @Override
    public void initGui(int guiLeft, int guiTop) {
        super.initGui(guiLeft, guiTop);
        this.slider = new GuiRectangle(guiLeft + this.xSize + 2, guiTop + this.offsetY + this.scrollbarOffset + 7, 12, 15);
        this.scrollbar = new GuiRectangle(guiLeft + this.xSize + 2, guiTop + this.offsetY + this.scrollbarOffset + 7, 12, this.inventoryRows * this.SLOT - 2);
    }

    @Override
    public void drawBackgroundLayer(float f, int x, int y) {
        super.drawBackgroundLayer(f, x, y);
        for (int i = this.firstSlot; i < this.lastSlot; ++i) {
            Slot slot = (Slot)this.container.field_75151_b.get(i);
            int offset = 0;
            if (slot instanceof SlotScrolling && ((SlotScrolling)slot).isDisabled()) {
                offset = 18;
            }
            this.drawTexturedModalRect(this.guiLeft + slot.field_75223_e - 1, this.guiTop + slot.field_75221_f - 1, 201 + offset, 0, 18, 18);
        }
        if (this.hasScrollbar) {
            this.drawTexturedModalRect(this.scrollbar.x - 5, this.scrollbar.y - 7, this.xSize, 0, 25, 7);
            if (this.scrollbar.height <= 106) {
                this.drawTexturedModalRect(this.scrollbar.x - 5, this.scrollbar.y, this.xSize, 7, 25, this.scrollbar.height);
            } else {
                int drawn = 0;
                int i = 0;
                while ((double)i < Math.ceil((double)this.scrollbar.height / 106.0)) {
                    int toDraw = this.scrollbar.height - drawn > 106 ? 106 : this.scrollbar.height - drawn;
                    this.drawTexturedModalRect(this.scrollbar.x - 5, this.scrollbar.y + drawn, this.xSize, 7, 25, toDraw);
                    drawn += toDraw;
                    ++i;
                }
            }
            this.drawTexturedModalRect(this.scrollbar.x - 5, this.scrollbar.y + this.scrollbar.height, this.xSize, 113, 25, 7);
            this.drawTexturedModalRect(this.slider.x, this.slider.y, 244, 0, this.slider.width, this.slider.height);
        }
    }

    public void setScrollbarOffset(int offset) {
        this.scrollbarOffset = offset;
    }

    public void mouseClicked(int x, int y) {
        if (this.slider.isInRectangle(x, y)) {
            this.isSliding = true;
        } else if (this.scrollbar.isInRectangle(x, y)) {
            this.setSliderByMouse(y);
        }
    }

    public void mouseClickMove(int x, int y) {
        if (this.isSliding || this.slider.isInRectangle(x, y)) {
            this.setSliderByMouse(y);
        }
    }

    public void mouseReleased(int x, int y) {
        this.isSliding = false;
    }

    public void mouseScrollWheel(int scrollDirection) {
        if (scrollDirection != 0 && this.hasScrollbar) {
            int maxScroll = this.inventory.func_70302_i_() / 9 - this.inventoryRows;
            this.currentScroll = (float)((double)this.currentScroll - (double)scrollDirection / (double)maxScroll);
            this.updateSliderPosition();
        }
    }

    protected void setSliderByMouse(int y) {
        this.currentScroll = ((float)(y - this.scrollbar.y) - 7.5f) / ((float)this.scrollbar.height - 15.0f);
        this.updateSliderPosition();
    }

    protected void updateSliderPosition() {
        this.checkScrollbarBoundaries();
        this.slider.y = this.slider.origY + (int)((float)(this.scrollbar.height - this.slider.height) * this.currentScroll);
        int lastRow = (int)Math.ceil((double)this.inventory.func_70302_i_() / 9.0 - (double)this.inventoryRows);
        int offset = (int)((double)(this.currentScroll * (float)lastRow) + 0.5);
        if (offset < 0) {
            offset = 0;
        }
        this.container.sendScrollbarToServer(this, offset);
    }

    protected void checkScrollbarBoundaries() {
        if (this.currentScroll < 0.0f) {
            this.currentScroll = 0.0f;
        }
        if (this.currentScroll > 1.0f) {
            this.currentScroll = 1.0f;
        }
    }

    public GuiRectangle getScrollbar() {
        return this.scrollbar;
    }
}

