/*
 * Decompiled with CFR 0.152.
 */
package backpack.inventory;

import backpack.inventory.IInventoryBackpack;
import backpack.inventory.InventoryWorkbenchBackpack;
import backpack.util.BackpackUtil;
import java.util.Arrays;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;

public class InventoryCraftingAdvanced
extends InventoryCrafting
implements IInventoryBackpack {
    protected InventoryWorkbenchBackpack backpackInventory = null;
    protected boolean useInventoryMode = false;
    protected int[] mapping;

    public InventoryCraftingAdvanced(Container eventHandler, IInventory backpackInventory) {
        super(eventHandler, 3, 3);
        if (backpackInventory instanceof InventoryWorkbenchBackpack) {
            this.backpackInventory = (InventoryWorkbenchBackpack)backpackInventory;
        }
        this.mapping = new int[this.func_70302_i_()];
        Arrays.fill(this.mapping, -1);
    }

    public ItemStack func_70298_a(int pos, int amount) {
        ItemStack returnIS = super.func_70298_a(pos, amount);
        if (this.backpackInventory != null) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                this.backpackInventory.setCraftingSlotContent(i, this.func_70301_a(i));
            }
            this.backpackInventory.func_70296_d();
        }
        return returnIS;
    }

    public void func_70299_a(int slotPosition, ItemStack newItemStack) {
        int correspondingSlot;
        if (this.useInventoryMode && (correspondingSlot = this.findCorrespondingSlot(slotPosition)) != -1) {
            this.backpackInventory.func_70299_a(correspondingSlot, newItemStack);
            return;
        }
        super.func_70299_a(slotPosition, newItemStack);
        if (this.backpackInventory != null) {
            this.backpackInventory.setCraftingSlotContent(slotPosition, this.func_70301_a(slotPosition));
        }
    }

    public ItemStack func_70301_a(int slotPosition) {
        if (this.useInventoryMode) {
            int correspondingSlot = this.findCorrespondingSlot(slotPosition);
            if (correspondingSlot == -1) {
                return null;
            }
            return this.backpackInventory.func_70301_a(correspondingSlot);
        }
        return super.func_70301_a(slotPosition);
    }

    public void loadContent() {
        if (this.backpackInventory != null) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                super.func_70299_a(i, this.backpackInventory.getStackInCraftingSlot(i));
            }
        }
    }

    public void loadRecipe(int recipe) {
        if (this.backpackInventory != null && this.backpackInventory.hasRecipe(recipe)) {
            this.backpackInventory.loadRecipe(recipe);
            this.loadContent();
        }
    }

    public void setUseInventoryMode(boolean value) {
        this.useInventoryMode = value;
        if (!value) {
            Arrays.fill(this.mapping, -1);
        }
    }

    protected int findCorrespondingSlot(int recipeSlotPosition) {
        ItemStack inventoryStack;
        int i;
        if (this.mapping[recipeSlotPosition] != -1) {
            return this.mapping[recipeSlotPosition];
        }
        ItemStack craftingGridStack = super.func_70301_a(recipeSlotPosition);
        for (i = 0; i < this.backpackInventory.func_70302_i_(); ++i) {
            inventoryStack = this.backpackInventory.func_70301_a(i);
            if (!BackpackUtil.areStacksEqual(craftingGridStack, inventoryStack)) continue;
            this.mapping[recipeSlotPosition] = i;
            return i;
        }
        for (i = 0; i < this.backpackInventory.func_70302_i_(); ++i) {
            inventoryStack = this.backpackInventory.func_70301_a(i);
            if (!BackpackUtil.areStacksEqualByOD(craftingGridStack, inventoryStack)) continue;
            this.mapping[recipeSlotPosition] = i;
            return i;
        }
        return -1;
    }
}

