/*
 * Decompiled with CFR 0.152.
 */
package backpack.inventory.container;

import backpack.gui.parts.GuiPart;
import backpack.gui.parts.GuiPartBackpack;
import backpack.gui.parts.GuiPartBrewing;
import backpack.gui.parts.GuiPartFlexible;
import backpack.gui.parts.GuiPartFurnace;
import backpack.gui.parts.GuiPartPlayerInventory;
import backpack.gui.parts.GuiPartScrolling;
import backpack.inventory.container.ContainerAdvanced;
import backpack.item.ItemBackpackBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityBrewingStand;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.tileentity.TileEntityHopper;

public class ContainerBackpackCombined
extends ContainerAdvanced {
    protected int backpackStartSlot;
    protected int backpackEndSlot;

    public ContainerBackpackCombined(IInventory playerInventory, IInventory otherInventory, IInventory backpackInventory, ItemStack backpack) {
        super(backpackInventory, otherInventory, backpack);
        GuiPart top;
        if (this.upperInventory instanceof TileEntityFurnace) {
            top = new GuiPartFurnace(this, ((InventoryPlayer)playerInventory).field_70458_d, this.upperInventory, this.upperInventoryRows);
            top.setTextPosition(GuiPart.TEXTPOSITION.MIDDLE);
        } else if (this.upperInventory instanceof TileEntityDispenser || this.upperInventory instanceof TileEntityDropper) {
            top = new GuiPartFlexible(this, this.upperInventory, 3, 3);
            top.setTextPosition(GuiPart.TEXTPOSITION.MIDDLE);
        } else if (this.upperInventory instanceof TileEntityHopper) {
            top = new GuiPartFlexible(this, this.upperInventory, this.upperInventoryRows);
        } else if (this.upperInventory instanceof TileEntityBrewingStand) {
            top = new GuiPartBrewing(this, this.upperInventory, this.upperInventoryRows);
            top.setTextPosition(GuiPart.TEXTPOSITION.MIDDLE);
        } else {
            top = new GuiPartFlexible(this, this.upperInventory, this.upperInventoryRows, 9, this.lowerInventoryRows <= 3);
            ((GuiPartScrolling)top).setScrollbarOffset(-6);
        }
        GuiPartBackpack bottom = new GuiPartBackpack((ContainerAdvanced)this, this.lowerInventory, this.lowerInventoryRows, this.upperInventoryRows <= 3);
        ((GuiPartScrolling)bottom).setScrollbarOffset(2);
        GuiPartPlayerInventory hotbar = new GuiPartPlayerInventory((ContainerAdvanced)this, playerInventory, true);
        top.setSpacings(0, 6);
        bottom.setSpacings(7, 6);
        int offset = 16;
        top.setOffsetY(offset);
        bottom.setOffsetY(offset += top.ySize);
        hotbar.setOffsetY(offset += bottom.ySize);
        top.addSlots();
        this.backpackStartSlot = this.field_75151_b.size();
        ((GuiPart)bottom).addSlots();
        this.backpackEndSlot = this.field_75151_b.size();
        ((GuiPart)hotbar).addSlots();
        this.parts.add(top);
        this.parts.add(bottom);
        this.parts.add(hotbar);
    }

    public void func_75132_a(ICrafting par1iCrafting) {
        super.func_75132_a(par1iCrafting);
        ((GuiPart)this.parts.get(0)).addCraftingToCrafters(par1iCrafting);
    }

    public void func_75142_b() {
        super.func_75142_b();
        ((GuiPart)this.parts.get(0)).detectAndSendChanges();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int par1, int par2) {
        super.func_75137_b(par1, par2);
        ((GuiPart)this.parts.get(0)).updateProgressBar(par1, par2);
    }

    public ItemStack func_82846_b(EntityPlayer par1EntityPlayer, int slotPos) {
        ItemStack returnStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotPos);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemStack = slot.func_75211_c();
            if (itemStack.func_77973_b() instanceof ItemBackpackBase) {
                return returnStack;
            }
            returnStack = itemStack.func_77946_l();
            if (slotPos < this.backpackStartSlot ? !this.func_75135_a(itemStack, this.backpackStartSlot, this.backpackEndSlot, false) : (slotPos >= this.backpackStartSlot && slotPos < this.backpackEndSlot ? !this.func_75135_a(itemStack, 0, this.backpackStartSlot, false) : !this.func_75135_a(itemStack, 0, this.backpackEndSlot, false))) {
                return null;
            }
            if (itemStack.field_77994_a == 0) {
                slot.func_75215_d((ItemStack)null);
            } else {
                slot.func_75218_e();
            }
        }
        return returnStack;
    }
}

