/*
 * Decompiled with CFR 0.152.
 */
package backpack.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class NBTSave {
    protected File saveFile = null;
    protected NBTTagCompound nbtData = null;
    protected boolean isDirty = false;

    public NBTSave(String fileName, File saveLocation) {
        this.saveFile = new File(saveLocation, fileName + ".dat");
        if (!this.saveFile.getParentFile().exists()) {
            this.saveFile.getParentFile().mkdirs();
        }
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        this.nbtData = new NBTTagCompound();
        FilterInputStream inputStream = null;
        try {
            if (!this.saveFile.exists()) {
                this.saveFile.createNewFile();
            }
            if (this.saveFile.length() > 0L) {
                inputStream = new DataInputStream(new FileInputStream(this.saveFile));
                this.nbtData = (NBTTagCompound)NBTBase.func_74739_b((DataInput)((Object)inputStream));
            }
        }
        catch (Exception e) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public final void save() {
        this.save(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(boolean force) {
        if (!this.isDirty() && !force) {
            return;
        }
        FilterOutputStream outputStream = null;
        try {
            outputStream = new DataOutputStream(new FileOutputStream(this.saveFile));
            NBTBase.func_74731_a((NBTBase)this.nbtData, (DataOutput)((Object)outputStream));
            this.setDirty(false);
        }
        catch (Exception e) {
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public final void setDirty(boolean state) {
        this.isDirty = state;
    }

    public final boolean isDirty() {
        return this.isDirty;
    }
}

