/*
 * Decompiled with CFR 0.152.
 */
package backpack.util;

import backpack.item.ItemBackpackBase;
import backpack.util.NBTSave;
import java.io.File;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerSave
extends NBTSave {
    protected static final String WORN = "wornBackpack";
    protected static final String LATEST = "latestSeenVersion";

    public PlayerSave(String playerName, File saveLocation) {
        super(playerName, saveLocation);
    }

    @Override
    protected void load() {
        super.load();
        if (!this.nbtData.func_74764_b(WORN)) {
            this.nbtData.func_74766_a(WORN, new NBTTagCompound());
        }
    }

    public void setWornBackpack(ItemStack wornBackpackStack) {
        if (wornBackpackStack == null) {
            if (this.getWornBackpack() != null) {
                this.nbtData.func_74766_a(WORN, new NBTTagCompound());
                this.setDirty(true);
            }
        } else if (wornBackpackStack.func_77973_b() instanceof ItemBackpackBase) {
            this.nbtData.func_74766_a(WORN, wornBackpackStack.func_77955_b(new NBTTagCompound()));
            this.setDirty(true);
        }
    }

    public ItemStack getWornBackpack() {
        NBTTagCompound wornBackpack = this.nbtData.func_74775_l(WORN);
        ItemStack wornBackpackStack = null;
        if (!wornBackpack.func_82582_d()) {
            wornBackpackStack = ItemStack.func_77949_a((NBTTagCompound)wornBackpack);
        }
        return wornBackpackStack;
    }

    public void setLatestSeenVersion(String latestSeenVersion) {
        if (!this.getLatestSeenVersion().equals(latestSeenVersion)) {
            this.nbtData.func_74778_a(LATEST, latestSeenVersion);
            this.setDirty(true);
        }
    }

    public String getLatestSeenVersion() {
        return this.nbtData.func_74779_i(LATEST);
    }
}

